/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramInsightsResult;
import com.facebook.ads.sdk.ShadowIGComment;
import com.facebook.ads.sdk.ShadowIGUser;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowIGMedia
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="comments_count")
    private Long mCommentsCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ig_id")
    private String mIgId = null;
    @SerializedName(value="is_comment_enabled")
    private Boolean mIsCommentEnabled = null;
    @SerializedName(value="like_count")
    private Long mLikeCount = null;
    @SerializedName(value="media_type")
    private String mMediaType = null;
    @SerializedName(value="media_url")
    private String mMediaUrl = null;
    @SerializedName(value="owner")
    private ShadowIGUser mOwner = null;
    @SerializedName(value="permalink")
    private String mPermalink = null;
    @SerializedName(value="shortcode")
    private String mShortcode = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    ShadowIGMedia() {
    }

    public ShadowIGMedia(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ShadowIGMedia(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ShadowIGMedia fetch() throws APIException {
        ShadowIGMedia newInstance = ShadowIGMedia.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ShadowIGMedia fetchById(Long id, APIContext context) throws APIException {
        return ShadowIGMedia.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ShadowIGMedia> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ShadowIGMedia.fetchByIdAsync(id.toString(), context);
    }

    public static ShadowIGMedia fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ShadowIGMedia> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ShadowIGMedia> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ShadowIGMedia>(context, "", "/", "GET", ShadowIGMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ShadowIGMedia>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ShadowIGMedia>(context, "", "/", "GET", ShadowIGMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ShadowIGMedia loadJSON(String json, APIContext context) {
        ShadowIGMedia shadowIGMedia = (ShadowIGMedia)ShadowIGMedia.getGson().fromJson(json, ShadowIGMedia.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(shadowIGMedia.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        shadowIGMedia.context = context;
        shadowIGMedia.rawValue = json;
        return shadowIGMedia;
    }

    public static APINodeList<ShadowIGMedia> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ShadowIGMedia> shadowIGMedias = new APINodeList<ShadowIGMedia>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        shadowIGMedias.add(ShadowIGMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return shadowIGMedias;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            shadowIGMedias.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        shadowIGMedias.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            shadowIGMedias.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            shadowIGMedias.add(ShadowIGMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                shadowIGMedias.add(ShadowIGMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            shadowIGMedias.add(ShadowIGMedia.loadJSON(obj.toString(), context));
                        }
                    }
                    return shadowIGMedias;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        shadowIGMedias.add(ShadowIGMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return shadowIGMedias;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        shadowIGMedias.add(ShadowIGMedia.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return shadowIGMedias;
                }
                shadowIGMedias.clear();
                shadowIGMedias.add(ShadowIGMedia.loadJSON(json, context));
                return shadowIGMedias;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ShadowIGMedia.getGson().toJson((Object)this);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public Long getFieldCommentsCount() {
        return this.mCommentsCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIgId() {
        return this.mIgId;
    }

    public Boolean getFieldIsCommentEnabled() {
        return this.mIsCommentEnabled;
    }

    public Long getFieldLikeCount() {
        return this.mLikeCount;
    }

    public String getFieldMediaType() {
        return this.mMediaType;
    }

    public String getFieldMediaUrl() {
        return this.mMediaUrl;
    }

    public ShadowIGUser getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public String getFieldPermalink() {
        return this.mPermalink;
    }

    public String getFieldShortcode() {
        return this.mShortcode;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ShadowIGMedia copyFrom(ShadowIGMedia instance) {
        this.mCaption = instance.mCaption;
        this.mCommentsCount = instance.mCommentsCount;
        this.mId = instance.mId;
        this.mIgId = instance.mIgId;
        this.mIsCommentEnabled = instance.mIsCommentEnabled;
        this.mLikeCount = instance.mLikeCount;
        this.mMediaType = instance.mMediaType;
        this.mMediaUrl = instance.mMediaUrl;
        this.mOwner = instance.mOwner;
        this.mPermalink = instance.mPermalink;
        this.mShortcode = instance.mShortcode;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mTimestamp = instance.mTimestamp;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ShadowIGMedia> getParser() {
        return new APIRequest.ResponseParser<ShadowIGMedia>(){

            @Override
            public APINodeList<ShadowIGMedia> parseResponse(String response, APIContext context, APIRequest<ShadowIGMedia> request) throws APIException.MalformedResponseException {
                return ShadowIGMedia.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<ShadowIGMedia> {
        ShadowIGMedia lastResponse = null;
        public static final String[] PARAMS = new String[]{"comment_enabled"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ShadowIGMedia getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGMedia parseResponse(String response) throws APIException {
            return ShadowIGMedia.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ShadowIGMedia execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGMedia execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGMedia> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGMedia> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGMedia>(){

                public ShadowIGMedia apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setCommentEnabled(Boolean commentEnabled) {
            this.setParam("comment_enabled", commentEnabled);
            return this;
        }

        public APIRequestUpdate setCommentEnabled(String commentEnabled) {
            this.setParam("comment_enabled", commentEnabled);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ShadowIGMedia> {
        ShadowIGMedia lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "comments_count", "id", "ig_id", "is_comment_enabled", "like_count", "media_type", "media_url", "owner", "permalink", "shortcode", "thumbnail_url", "timestamp", "username"};

        @Override
        public ShadowIGMedia getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGMedia parseResponse(String response) throws APIException {
            return ShadowIGMedia.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ShadowIGMedia execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGMedia execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGMedia> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGMedia> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGMedia>(){

                public ShadowIGMedia apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestCommentsCountField() {
            return this.requestCommentsCountField(true);
        }

        public APIRequestGet requestCommentsCountField(boolean value) {
            this.requestField("comments_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIgIdField() {
            return this.requestIgIdField(true);
        }

        public APIRequestGet requestIgIdField(boolean value) {
            this.requestField("ig_id", value);
            return this;
        }

        public APIRequestGet requestIsCommentEnabledField() {
            return this.requestIsCommentEnabledField(true);
        }

        public APIRequestGet requestIsCommentEnabledField(boolean value) {
            this.requestField("is_comment_enabled", value);
            return this;
        }

        public APIRequestGet requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGet requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGet requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGet requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGet requestMediaUrlField() {
            return this.requestMediaUrlField(true);
        }

        public APIRequestGet requestMediaUrlField(boolean value) {
            this.requestField("media_url", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGet requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGet requestShortcodeField() {
            return this.requestShortcodeField(true);
        }

        public APIRequestGet requestShortcodeField(boolean value) {
            this.requestField("shortcode", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<InstagramInsightsResult> {
        APINodeList<InstagramInsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"metric", "period"};
        public static final String[] FIELDS = new String[]{"description", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InstagramInsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InstagramInsightsResult> parseResponse(String response) throws APIException {
            return InstagramInsightsResult.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<InstagramInsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InstagramInsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InstagramInsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InstagramInsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<InstagramInsightsResult>>(){

                public APINodeList<InstagramInsightsResult> apply(String result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setMetric(List<InstagramInsightsResult.EnumMetric> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setPeriod(List<InstagramInsightsResult.EnumPeriod> period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateComment
    extends APIRequest<ShadowIGComment> {
        ShadowIGComment lastResponse = null;
        public static final String[] PARAMS = new String[]{"message"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ShadowIGComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGComment parseResponse(String response) throws APIException {
            return ShadowIGComment.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ShadowIGComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGComment execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGComment>(){

                public ShadowIGComment apply(String result) {
                    try {
                        return APIRequestCreateComment.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

