/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadTargetingCategories
extends APINode {
    @SerializedName(value="category_description")
    private String mCategoryDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent_category")
    private String mParentCategory = null;
    @SerializedName(value="path")
    private List<String> mPath = null;
    @SerializedName(value="size")
    private Long mSize = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="type")
    private Long mType = null;
    @SerializedName(value="type_name")
    private String mTypeName = null;
    @SerializedName(value="untranslated_name")
    private String mUntranslatedName = null;
    @SerializedName(value="untranslated_parent_name")
    private String mUntranslatedParentName = null;
    protected static Gson gson = null;

    BroadTargetingCategories() {
    }

    public BroadTargetingCategories(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BroadTargetingCategories(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BroadTargetingCategories fetch() throws APIException {
        BroadTargetingCategories newInstance = BroadTargetingCategories.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BroadTargetingCategories fetchById(Long id, APIContext context) throws APIException {
        return BroadTargetingCategories.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BroadTargetingCategories> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BroadTargetingCategories.fetchByIdAsync(id.toString(), context);
    }

    public static BroadTargetingCategories fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BroadTargetingCategories> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BroadTargetingCategories> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BroadTargetingCategories>(context, "", "/", "GET", BroadTargetingCategories.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BroadTargetingCategories>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BroadTargetingCategories>(context, "", "/", "GET", BroadTargetingCategories.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BroadTargetingCategories loadJSON(String json, APIContext context) {
        BroadTargetingCategories broadTargetingCategories = (BroadTargetingCategories)BroadTargetingCategories.getGson().fromJson(json, BroadTargetingCategories.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(broadTargetingCategories.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        broadTargetingCategories.context = context;
        broadTargetingCategories.rawValue = json;
        return broadTargetingCategories;
    }

    public static APINodeList<BroadTargetingCategories> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BroadTargetingCategories> broadTargetingCategoriess = new APINodeList<BroadTargetingCategories>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return broadTargetingCategoriess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            broadTargetingCategoriess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        broadTargetingCategoriess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            broadTargetingCategoriess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(obj.toString(), context));
                        }
                    }
                    return broadTargetingCategoriess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return broadTargetingCategoriess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return broadTargetingCategoriess;
                }
                broadTargetingCategoriess.clear();
                broadTargetingCategoriess.add(BroadTargetingCategories.loadJSON(json, context));
                return broadTargetingCategoriess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BroadTargetingCategories.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCategoryDescription() {
        return this.mCategoryDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldParentCategory() {
        return this.mParentCategory;
    }

    public List<String> getFieldPath() {
        return this.mPath;
    }

    public Long getFieldSize() {
        return this.mSize;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Long getFieldType() {
        return this.mType;
    }

    public String getFieldTypeName() {
        return this.mTypeName;
    }

    public String getFieldUntranslatedName() {
        return this.mUntranslatedName;
    }

    public String getFieldUntranslatedParentName() {
        return this.mUntranslatedParentName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BroadTargetingCategories copyFrom(BroadTargetingCategories instance) {
        this.mCategoryDescription = instance.mCategoryDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mParentCategory = instance.mParentCategory;
        this.mPath = instance.mPath;
        this.mSize = instance.mSize;
        this.mSource = instance.mSource;
        this.mType = instance.mType;
        this.mTypeName = instance.mTypeName;
        this.mUntranslatedName = instance.mUntranslatedName;
        this.mUntranslatedParentName = instance.mUntranslatedParentName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BroadTargetingCategories> getParser() {
        return new APIRequest.ResponseParser<BroadTargetingCategories>(){

            @Override
            public APINodeList<BroadTargetingCategories> parseResponse(String response, APIContext context, APIRequest<BroadTargetingCategories> request) throws APIException.MalformedResponseException {
                return BroadTargetingCategories.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BroadTargetingCategories> {
        BroadTargetingCategories lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"category_description", "id", "name", "parent_category", "path", "size", "source", "type", "type_name", "untranslated_name", "untranslated_parent_name"};

        @Override
        public BroadTargetingCategories getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BroadTargetingCategories parseResponse(String response) throws APIException {
            return BroadTargetingCategories.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BroadTargetingCategories execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BroadTargetingCategories execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BroadTargetingCategories> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BroadTargetingCategories> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BroadTargetingCategories>(){

                public BroadTargetingCategories apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCategoryDescriptionField() {
            return this.requestCategoryDescriptionField(true);
        }

        public APIRequestGet requestCategoryDescriptionField(boolean value) {
            this.requestField("category_description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestParentCategoryField() {
            return this.requestParentCategoryField(true);
        }

        public APIRequestGet requestParentCategoryField(boolean value) {
            this.requestField("parent_category", value);
            return this;
        }

        public APIRequestGet requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGet requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGet requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGet requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestTypeNameField() {
            return this.requestTypeNameField(true);
        }

        public APIRequestGet requestTypeNameField(boolean value) {
            this.requestField("type_name", value);
            return this;
        }

        public APIRequestGet requestUntranslatedNameField() {
            return this.requestUntranslatedNameField(true);
        }

        public APIRequestGet requestUntranslatedNameField(boolean value) {
            this.requestField("untranslated_name", value);
            return this;
        }

        public APIRequestGet requestUntranslatedParentNameField() {
            return this.requestUntranslatedParentNameField(true);
        }

        public APIRequestGet requestUntranslatedParentNameField(boolean value) {
            this.requestField("untranslated_parent_name", value);
            return this;
        }
    }
}

