/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CustomAudience;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudiencePermission
extends APINode {
    @SerializedName(value="audience")
    private CustomAudience mAudience = null;
    @SerializedName(value="share_account_id")
    private String mShareAccountId = null;
    @SerializedName(value="share_account_name")
    private String mShareAccountName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AudiencePermission() {
    }

    public AudiencePermission(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudiencePermission(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudiencePermission fetch() throws APIException {
        AudiencePermission newInstance = AudiencePermission.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudiencePermission fetchById(Long id, APIContext context) throws APIException {
        return AudiencePermission.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudiencePermission> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudiencePermission.fetchByIdAsync(id.toString(), context);
    }

    public static AudiencePermission fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudiencePermission> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudiencePermission> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudiencePermission>(context, "", "/", "GET", AudiencePermission.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudiencePermission>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudiencePermission>(context, "", "/", "GET", AudiencePermission.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudiencePermission loadJSON(String json, APIContext context) {
        AudiencePermission audiencePermission = (AudiencePermission)AudiencePermission.getGson().fromJson(json, AudiencePermission.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audiencePermission.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audiencePermission.context = context;
        audiencePermission.rawValue = json;
        return audiencePermission;
    }

    public static APINodeList<AudiencePermission> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudiencePermission> audiencePermissions = new APINodeList<AudiencePermission>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audiencePermissions.add(AudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return audiencePermissions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audiencePermissions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audiencePermissions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audiencePermissions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audiencePermissions.add(AudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audiencePermissions.add(AudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audiencePermissions.add(AudiencePermission.loadJSON(obj.toString(), context));
                        }
                    }
                    return audiencePermissions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audiencePermissions.add(AudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return audiencePermissions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audiencePermissions.add(AudiencePermission.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audiencePermissions;
                }
                audiencePermissions.clear();
                audiencePermissions.add(AudiencePermission.loadJSON(json, context));
                return audiencePermissions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudiencePermission.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public CustomAudience getFieldAudience() {
        if (this.mAudience != null) {
            this.mAudience.context = this.getContext();
        }
        return this.mAudience;
    }

    public String getFieldShareAccountId() {
        return this.mShareAccountId;
    }

    public String getFieldShareAccountName() {
        return this.mShareAccountName;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudiencePermission copyFrom(AudiencePermission instance) {
        this.mAudience = instance.mAudience;
        this.mShareAccountId = instance.mShareAccountId;
        this.mShareAccountName = instance.mShareAccountName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudiencePermission> getParser() {
        return new APIRequest.ResponseParser<AudiencePermission>(){

            @Override
            public APINodeList<AudiencePermission> parseResponse(String response, APIContext context, APIRequest<AudiencePermission> request) throws APIException.MalformedResponseException {
                return AudiencePermission.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AudiencePermission> {
        AudiencePermission lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"audience", "share_account_id", "share_account_name", "id"};

        @Override
        public AudiencePermission getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudiencePermission parseResponse(String response) throws APIException {
            return AudiencePermission.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AudiencePermission execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudiencePermission execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AudiencePermission> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudiencePermission> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AudiencePermission>(){

                public AudiencePermission apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAudienceField() {
            return this.requestAudienceField(true);
        }

        public APIRequestGet requestAudienceField(boolean value) {
            this.requestField("audience", value);
            return this;
        }

        public APIRequestGet requestShareAccountIdField() {
            return this.requestShareAccountIdField(true);
        }

        public APIRequestGet requestShareAccountIdField(boolean value) {
            this.requestField("share_account_id", value);
            return this;
        }

        public APIRequestGet requestShareAccountNameField() {
            return this.requestShareAccountNameField(true);
        }

        public APIRequestGet requestShareAccountNameField(boolean value) {
            this.requestField("share_account_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

