/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgencyClientDeclaration
extends APINode {
    @SerializedName(value="agency_representing_client")
    private Long mAgencyRepresentingClient = null;
    @SerializedName(value="client_based_in_france")
    private Long mClientBasedInFrance = null;
    @SerializedName(value="client_city")
    private String mClientCity = null;
    @SerializedName(value="client_country_code")
    private String mClientCountryCode = null;
    @SerializedName(value="client_email_address")
    private String mClientEmailAddress = null;
    @SerializedName(value="client_name")
    private String mClientName = null;
    @SerializedName(value="client_postal_code")
    private String mClientPostalCode = null;
    @SerializedName(value="client_province")
    private String mClientProvince = null;
    @SerializedName(value="client_street")
    private String mClientStreet = null;
    @SerializedName(value="client_street2")
    private String mClientStreet2 = null;
    @SerializedName(value="has_written_mandate_from_advertiser")
    private Long mHasWrittenMandateFromAdvertiser = null;
    @SerializedName(value="is_client_paying_invoices")
    private Long mIsClientPayingInvoices = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AgencyClientDeclaration() {
    }

    public AgencyClientDeclaration(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AgencyClientDeclaration(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AgencyClientDeclaration fetch() throws APIException {
        AgencyClientDeclaration newInstance = AgencyClientDeclaration.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AgencyClientDeclaration fetchById(Long id, APIContext context) throws APIException {
        return AgencyClientDeclaration.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AgencyClientDeclaration> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AgencyClientDeclaration.fetchByIdAsync(id.toString(), context);
    }

    public static AgencyClientDeclaration fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AgencyClientDeclaration> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AgencyClientDeclaration> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AgencyClientDeclaration>(context, "", "/", "GET", AgencyClientDeclaration.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AgencyClientDeclaration>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AgencyClientDeclaration>(context, "", "/", "GET", AgencyClientDeclaration.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AgencyClientDeclaration loadJSON(String json, APIContext context) {
        AgencyClientDeclaration agencyClientDeclaration = (AgencyClientDeclaration)AgencyClientDeclaration.getGson().fromJson(json, AgencyClientDeclaration.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(agencyClientDeclaration.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        agencyClientDeclaration.context = context;
        agencyClientDeclaration.rawValue = json;
        return agencyClientDeclaration;
    }

    public static APINodeList<AgencyClientDeclaration> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AgencyClientDeclaration> agencyClientDeclarations = new APINodeList<AgencyClientDeclaration>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return agencyClientDeclarations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            agencyClientDeclarations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        agencyClientDeclarations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            agencyClientDeclarations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(obj.toString(), context));
                        }
                    }
                    return agencyClientDeclarations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return agencyClientDeclarations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return agencyClientDeclarations;
                }
                agencyClientDeclarations.clear();
                agencyClientDeclarations.add(AgencyClientDeclaration.loadJSON(json, context));
                return agencyClientDeclarations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AgencyClientDeclaration.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAgencyRepresentingClient() {
        return this.mAgencyRepresentingClient;
    }

    public Long getFieldClientBasedInFrance() {
        return this.mClientBasedInFrance;
    }

    public String getFieldClientCity() {
        return this.mClientCity;
    }

    public String getFieldClientCountryCode() {
        return this.mClientCountryCode;
    }

    public String getFieldClientEmailAddress() {
        return this.mClientEmailAddress;
    }

    public String getFieldClientName() {
        return this.mClientName;
    }

    public String getFieldClientPostalCode() {
        return this.mClientPostalCode;
    }

    public String getFieldClientProvince() {
        return this.mClientProvince;
    }

    public String getFieldClientStreet() {
        return this.mClientStreet;
    }

    public String getFieldClientStreet2() {
        return this.mClientStreet2;
    }

    public Long getFieldHasWrittenMandateFromAdvertiser() {
        return this.mHasWrittenMandateFromAdvertiser;
    }

    public Long getFieldIsClientPayingInvoices() {
        return this.mIsClientPayingInvoices;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AgencyClientDeclaration copyFrom(AgencyClientDeclaration instance) {
        this.mAgencyRepresentingClient = instance.mAgencyRepresentingClient;
        this.mClientBasedInFrance = instance.mClientBasedInFrance;
        this.mClientCity = instance.mClientCity;
        this.mClientCountryCode = instance.mClientCountryCode;
        this.mClientEmailAddress = instance.mClientEmailAddress;
        this.mClientName = instance.mClientName;
        this.mClientPostalCode = instance.mClientPostalCode;
        this.mClientProvince = instance.mClientProvince;
        this.mClientStreet = instance.mClientStreet;
        this.mClientStreet2 = instance.mClientStreet2;
        this.mHasWrittenMandateFromAdvertiser = instance.mHasWrittenMandateFromAdvertiser;
        this.mIsClientPayingInvoices = instance.mIsClientPayingInvoices;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AgencyClientDeclaration> getParser() {
        return new APIRequest.ResponseParser<AgencyClientDeclaration>(){

            @Override
            public APINodeList<AgencyClientDeclaration> parseResponse(String response, APIContext context, APIRequest<AgencyClientDeclaration> request) throws APIException.MalformedResponseException {
                return AgencyClientDeclaration.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AgencyClientDeclaration> {
        AgencyClientDeclaration lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"agency_representing_client", "client_based_in_france", "client_city", "client_country_code", "client_email_address", "client_name", "client_postal_code", "client_province", "client_street", "client_street2", "has_written_mandate_from_advertiser", "is_client_paying_invoices", "id"};

        @Override
        public AgencyClientDeclaration getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AgencyClientDeclaration parseResponse(String response) throws APIException {
            return AgencyClientDeclaration.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AgencyClientDeclaration execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AgencyClientDeclaration execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AgencyClientDeclaration> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AgencyClientDeclaration> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AgencyClientDeclaration>(){

                public AgencyClientDeclaration apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAgencyRepresentingClientField() {
            return this.requestAgencyRepresentingClientField(true);
        }

        public APIRequestGet requestAgencyRepresentingClientField(boolean value) {
            this.requestField("agency_representing_client", value);
            return this;
        }

        public APIRequestGet requestClientBasedInFranceField() {
            return this.requestClientBasedInFranceField(true);
        }

        public APIRequestGet requestClientBasedInFranceField(boolean value) {
            this.requestField("client_based_in_france", value);
            return this;
        }

        public APIRequestGet requestClientCityField() {
            return this.requestClientCityField(true);
        }

        public APIRequestGet requestClientCityField(boolean value) {
            this.requestField("client_city", value);
            return this;
        }

        public APIRequestGet requestClientCountryCodeField() {
            return this.requestClientCountryCodeField(true);
        }

        public APIRequestGet requestClientCountryCodeField(boolean value) {
            this.requestField("client_country_code", value);
            return this;
        }

        public APIRequestGet requestClientEmailAddressField() {
            return this.requestClientEmailAddressField(true);
        }

        public APIRequestGet requestClientEmailAddressField(boolean value) {
            this.requestField("client_email_address", value);
            return this;
        }

        public APIRequestGet requestClientNameField() {
            return this.requestClientNameField(true);
        }

        public APIRequestGet requestClientNameField(boolean value) {
            this.requestField("client_name", value);
            return this;
        }

        public APIRequestGet requestClientPostalCodeField() {
            return this.requestClientPostalCodeField(true);
        }

        public APIRequestGet requestClientPostalCodeField(boolean value) {
            this.requestField("client_postal_code", value);
            return this;
        }

        public APIRequestGet requestClientProvinceField() {
            return this.requestClientProvinceField(true);
        }

        public APIRequestGet requestClientProvinceField(boolean value) {
            this.requestField("client_province", value);
            return this;
        }

        public APIRequestGet requestClientStreetField() {
            return this.requestClientStreetField(true);
        }

        public APIRequestGet requestClientStreetField(boolean value) {
            this.requestField("client_street", value);
            return this;
        }

        public APIRequestGet requestClientStreet2Field() {
            return this.requestClientStreet2Field(true);
        }

        public APIRequestGet requestClientStreet2Field(boolean value) {
            this.requestField("client_street2", value);
            return this;
        }

        public APIRequestGet requestHasWrittenMandateFromAdvertiserField() {
            return this.requestHasWrittenMandateFromAdvertiserField(true);
        }

        public APIRequestGet requestHasWrittenMandateFromAdvertiserField(boolean value) {
            this.requestField("has_written_mandate_from_advertiser", value);
            return this;
        }

        public APIRequestGet requestIsClientPayingInvoicesField() {
            return this.requestIsClientPayingInvoicesField(true);
        }

        public APIRequestGet requestIsClientPayingInvoicesField(boolean value) {
            this.requestField("is_client_paying_invoices", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

