/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCampaignGroupStats
extends APINode {
    @SerializedName(value="actions")
    private Map<String, Long> mActions = null;
    @SerializedName(value="campaign_group_id")
    private String mCampaignGroupId = null;
    @SerializedName(value="clicks")
    private Long mClicks = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="impressions")
    private Long mImpressions = null;
    @SerializedName(value="inline_actions")
    private Map<String, Long> mInlineActions = null;
    @SerializedName(value="social_clicks")
    private Long mSocialClicks = null;
    @SerializedName(value="social_impressions")
    private Long mSocialImpressions = null;
    @SerializedName(value="social_spent")
    private Long mSocialSpent = null;
    @SerializedName(value="social_unique_clicks")
    private Long mSocialUniqueClicks = null;
    @SerializedName(value="social_unique_impressions")
    private Long mSocialUniqueImpressions = null;
    @SerializedName(value="spent")
    private Long mSpent = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="unique_clicks")
    private Long mUniqueClicks = null;
    @SerializedName(value="unique_impressions")
    private Long mUniqueImpressions = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCampaignGroupStats() {
    }

    public AdCampaignGroupStats(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCampaignGroupStats(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCampaignGroupStats fetch() throws APIException {
        AdCampaignGroupStats newInstance = AdCampaignGroupStats.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCampaignGroupStats fetchById(Long id, APIContext context) throws APIException {
        return AdCampaignGroupStats.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCampaignGroupStats> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCampaignGroupStats.fetchByIdAsync(id.toString(), context);
    }

    public static AdCampaignGroupStats fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCampaignGroupStats> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCampaignGroupStats> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCampaignGroupStats>(context, "", "/", "GET", AdCampaignGroupStats.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCampaignGroupStats>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCampaignGroupStats>(context, "", "/", "GET", AdCampaignGroupStats.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCampaignGroupStats loadJSON(String json, APIContext context) {
        AdCampaignGroupStats adCampaignGroupStats = (AdCampaignGroupStats)AdCampaignGroupStats.getGson().fromJson(json, AdCampaignGroupStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignGroupStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignGroupStats.context = context;
        adCampaignGroupStats.rawValue = json;
        return adCampaignGroupStats;
    }

    public static APINodeList<AdCampaignGroupStats> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignGroupStats> adCampaignGroupStatss = new APINodeList<AdCampaignGroupStats>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCampaignGroupStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignGroupStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignGroupStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignGroupStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCampaignGroupStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCampaignGroupStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignGroupStatss;
                }
                adCampaignGroupStatss.clear();
                adCampaignGroupStatss.add(AdCampaignGroupStats.loadJSON(json, context));
                return adCampaignGroupStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignGroupStats.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Map<String, Long> getFieldActions() {
        return this.mActions;
    }

    public String getFieldCampaignGroupId() {
        return this.mCampaignGroupId;
    }

    public Long getFieldClicks() {
        return this.mClicks;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Long getFieldImpressions() {
        return this.mImpressions;
    }

    public Map<String, Long> getFieldInlineActions() {
        return this.mInlineActions;
    }

    public Long getFieldSocialClicks() {
        return this.mSocialClicks;
    }

    public Long getFieldSocialImpressions() {
        return this.mSocialImpressions;
    }

    public Long getFieldSocialSpent() {
        return this.mSocialSpent;
    }

    public Long getFieldSocialUniqueClicks() {
        return this.mSocialUniqueClicks;
    }

    public Long getFieldSocialUniqueImpressions() {
        return this.mSocialUniqueImpressions;
    }

    public Long getFieldSpent() {
        return this.mSpent;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public Long getFieldUniqueClicks() {
        return this.mUniqueClicks;
    }

    public Long getFieldUniqueImpressions() {
        return this.mUniqueImpressions;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignGroupStats copyFrom(AdCampaignGroupStats instance) {
        this.mActions = instance.mActions;
        this.mCampaignGroupId = instance.mCampaignGroupId;
        this.mClicks = instance.mClicks;
        this.mEndTime = instance.mEndTime;
        this.mImpressions = instance.mImpressions;
        this.mInlineActions = instance.mInlineActions;
        this.mSocialClicks = instance.mSocialClicks;
        this.mSocialImpressions = instance.mSocialImpressions;
        this.mSocialSpent = instance.mSocialSpent;
        this.mSocialUniqueClicks = instance.mSocialUniqueClicks;
        this.mSocialUniqueImpressions = instance.mSocialUniqueImpressions;
        this.mSpent = instance.mSpent;
        this.mStartTime = instance.mStartTime;
        this.mUniqueClicks = instance.mUniqueClicks;
        this.mUniqueImpressions = instance.mUniqueImpressions;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignGroupStats> getParser() {
        return new APIRequest.ResponseParser<AdCampaignGroupStats>(){

            @Override
            public APINodeList<AdCampaignGroupStats> parseResponse(String response, APIContext context, APIRequest<AdCampaignGroupStats> request) throws APIException.MalformedResponseException {
                return AdCampaignGroupStats.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCampaignGroupStats> {
        AdCampaignGroupStats lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "campaign_group_id", "clicks", "end_time", "impressions", "inline_actions", "social_clicks", "social_impressions", "social_spent", "social_unique_clicks", "social_unique_impressions", "spent", "start_time", "unique_clicks", "unique_impressions", "id"};

        @Override
        public AdCampaignGroupStats getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCampaignGroupStats parseResponse(String response) throws APIException {
            return AdCampaignGroupStats.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCampaignGroupStats execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCampaignGroupStats execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCampaignGroupStats> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCampaignGroupStats> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCampaignGroupStats>(){

                public AdCampaignGroupStats apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGet requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGet requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGet requestClicksField() {
            return this.requestClicksField(true);
        }

        public APIRequestGet requestClicksField(boolean value) {
            this.requestField("clicks", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGet requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGet requestInlineActionsField() {
            return this.requestInlineActionsField(true);
        }

        public APIRequestGet requestInlineActionsField(boolean value) {
            this.requestField("inline_actions", value);
            return this;
        }

        public APIRequestGet requestSocialClicksField() {
            return this.requestSocialClicksField(true);
        }

        public APIRequestGet requestSocialClicksField(boolean value) {
            this.requestField("social_clicks", value);
            return this;
        }

        public APIRequestGet requestSocialImpressionsField() {
            return this.requestSocialImpressionsField(true);
        }

        public APIRequestGet requestSocialImpressionsField(boolean value) {
            this.requestField("social_impressions", value);
            return this;
        }

        public APIRequestGet requestSocialSpentField() {
            return this.requestSocialSpentField(true);
        }

        public APIRequestGet requestSocialSpentField(boolean value) {
            this.requestField("social_spent", value);
            return this;
        }

        public APIRequestGet requestSocialUniqueClicksField() {
            return this.requestSocialUniqueClicksField(true);
        }

        public APIRequestGet requestSocialUniqueClicksField(boolean value) {
            this.requestField("social_unique_clicks", value);
            return this;
        }

        public APIRequestGet requestSocialUniqueImpressionsField() {
            return this.requestSocialUniqueImpressionsField(true);
        }

        public APIRequestGet requestSocialUniqueImpressionsField(boolean value) {
            this.requestField("social_unique_impressions", value);
            return this;
        }

        public APIRequestGet requestSpentField() {
            return this.requestSpentField(true);
        }

        public APIRequestGet requestSpentField(boolean value) {
            this.requestField("spent", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestUniqueClicksField() {
            return this.requestUniqueClicksField(true);
        }

        public APIRequestGet requestUniqueClicksField(boolean value) {
            this.requestField("unique_clicks", value);
            return this;
        }

        public APIRequestGet requestUniqueImpressionsField() {
            return this.requestUniqueImpressionsField(true);
        }

        public APIRequestGet requestUniqueImpressionsField(boolean value) {
            this.requestField("unique_impressions", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

