/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.CustomConversionStatsResult;
import com.facebook.ads.sdk.ExternalEventSource;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversion
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="aggregation_rule")
    private String mAggregationRule = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="custom_event_type")
    private EnumCustomEventType mCustomEventType = null;
    @SerializedName(value="data_sources")
    private List<ExternalEventSource> mDataSources = null;
    @SerializedName(value="default_conversion_value")
    private Long mDefaultConversionValue = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event_source_type")
    private String mEventSourceType = null;
    @SerializedName(value="first_fired_time")
    private String mFirstFiredTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_archived")
    private Boolean mIsArchived = null;
    @SerializedName(value="last_fired_time")
    private String mLastFiredTime = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offline_conversion_data_set")
    private OfflineConversionDataSet mOfflineConversionDataSet = null;
    @SerializedName(value="pixel")
    private AdsPixel mPixel = null;
    @SerializedName(value="retention_days")
    private Long mRetentionDays = null;
    @SerializedName(value="rule")
    private String mRule = null;
    protected static Gson gson = null;

    CustomConversion() {
    }

    public CustomConversion(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CustomConversion(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CustomConversion fetch() throws APIException {
        CustomConversion newInstance = CustomConversion.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CustomConversion fetchById(Long id, APIContext context) throws APIException {
        return CustomConversion.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CustomConversion> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CustomConversion.fetchByIdAsync(id.toString(), context);
    }

    public static CustomConversion fetchById(String id, APIContext context) throws APIException {
        CustomConversion customConversion = new APIRequestGet(id, context).requestAllFields().execute();
        return customConversion;
    }

    public static ListenableFuture<CustomConversion> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<CustomConversion> customConversion = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return customConversion;
    }

    public static APINodeList<CustomConversion> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CustomConversion>(context, "", "/", "GET", CustomConversion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CustomConversion>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> customConversion = new APIRequest<CustomConversion>(context, "", "/", "GET", CustomConversion.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return customConversion;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomConversion loadJSON(String json, APIContext context) {
        CustomConversion customConversion = (CustomConversion)CustomConversion.getGson().fromJson(json, CustomConversion.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customConversion.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customConversion.context = context;
        customConversion.rawValue = json;
        return customConversion;
    }

    public static APINodeList<CustomConversion> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomConversion> customConversions = new APINodeList<CustomConversion>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customConversions.add(CustomConversion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customConversions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customConversions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customConversions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customConversions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customConversions.add(CustomConversion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customConversions.add(CustomConversion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customConversions.add(CustomConversion.loadJSON(obj.toString(), context));
                        }
                    }
                    return customConversions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customConversions.add(CustomConversion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customConversions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customConversions.add(CustomConversion.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customConversions;
                }
                customConversions.clear();
                customConversions.add(CustomConversion.loadJSON(json, context));
                return customConversions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomConversion.getGson().toJson((Object)this);
    }

    public APIRequestGetActivities getActivities() {
        return new APIRequestGetActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAdAccounts deleteAdAccounts() {
        return new APIRequestDeleteAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAccount createAdAccount() {
        return new APIRequestCreateAdAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteSharedAgencies deleteSharedAgencies() {
        return new APIRequestDeleteSharedAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSharedAgency createSharedAgency() {
        return new APIRequestCreateSharedAgency(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetStats getStats() {
        return new APIRequestGetStats(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldAggregationRule() {
        return this.mAggregationRule;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public EnumCustomEventType getFieldCustomEventType() {
        return this.mCustomEventType;
    }

    public List<ExternalEventSource> getFieldDataSources() {
        return this.mDataSources;
    }

    public Long getFieldDefaultConversionValue() {
        return this.mDefaultConversionValue;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEventSourceType() {
        return this.mEventSourceType;
    }

    public String getFieldFirstFiredTime() {
        return this.mFirstFiredTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsArchived() {
        return this.mIsArchived;
    }

    public String getFieldLastFiredTime() {
        return this.mLastFiredTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    public OfflineConversionDataSet getFieldOfflineConversionDataSet() {
        if (this.mOfflineConversionDataSet != null) {
            this.mOfflineConversionDataSet.context = this.getContext();
        }
        return this.mOfflineConversionDataSet;
    }

    public AdsPixel getFieldPixel() {
        if (this.mPixel != null) {
            this.mPixel.context = this.getContext();
        }
        return this.mPixel;
    }

    public Long getFieldRetentionDays() {
        return this.mRetentionDays;
    }

    public String getFieldRule() {
        return this.mRule;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomConversion copyFrom(CustomConversion instance) {
        this.mAccountId = instance.mAccountId;
        this.mAggregationRule = instance.mAggregationRule;
        this.mCreationTime = instance.mCreationTime;
        this.mCustomEventType = instance.mCustomEventType;
        this.mDataSources = instance.mDataSources;
        this.mDefaultConversionValue = instance.mDefaultConversionValue;
        this.mDescription = instance.mDescription;
        this.mEventSourceType = instance.mEventSourceType;
        this.mFirstFiredTime = instance.mFirstFiredTime;
        this.mId = instance.mId;
        this.mIsArchived = instance.mIsArchived;
        this.mLastFiredTime = instance.mLastFiredTime;
        this.mName = instance.mName;
        this.mOfflineConversionDataSet = instance.mOfflineConversionDataSet;
        this.mPixel = instance.mPixel;
        this.mRetentionDays = instance.mRetentionDays;
        this.mRule = instance.mRule;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomConversion> getParser() {
        return new APIRequest.ResponseParser<CustomConversion>(){

            @Override
            public APINodeList<CustomConversion> parseResponse(String response, APIContext context, APIRequest<CustomConversion> request) throws APIException.MalformedResponseException {
                return CustomConversion.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_CONVERSION_CREATE("conversion_create"),
        VALUE_CONVERSION_DELETE("conversion_delete"),
        VALUE_CONVERSION_UPDATE("conversion_update"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCustomEventType {
        VALUE_ADD_PAYMENT_INFO("ADD_PAYMENT_INFO"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_ADD_TO_WISHLIST("ADD_TO_WISHLIST"),
        VALUE_COMPLETE_REGISTRATION("COMPLETE_REGISTRATION"),
        VALUE_CONTENT_VIEW("CONTENT_VIEW"),
        VALUE_INITIATED_CHECKOUT("INITIATED_CHECKOUT"),
        VALUE_LEAD("LEAD"),
        VALUE_PURCHASE("PURCHASE"),
        VALUE_SEARCH("SEARCH"),
        VALUE_CONTACT("CONTACT"),
        VALUE_CUSTOMIZE_PRODUCT("CUSTOMIZE_PRODUCT"),
        VALUE_DONATE("DONATE"),
        VALUE_FIND_LOCATION("FIND_LOCATION"),
        VALUE_SCHEDULE("SCHEDULE"),
        VALUE_START_TRIAL("START_TRIAL"),
        VALUE_SUBMIT_APPLICATION("SUBMIT_APPLICATION"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_OTHER("OTHER"),
        NULL(null);

        private String value;

        private EnumCustomEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"default_conversion_value", "description", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setDefaultConversionValue(Double defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestUpdate setDefaultConversionValue(String defaultConversionValue) {
            this.setParam("default_conversion_value", defaultConversionValue);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "aggregation_rule", "creation_time", "custom_event_type", "data_sources", "default_conversion_value", "description", "event_source_type", "first_fired_time", "id", "is_archived", "last_fired_time", "name", "offline_conversion_data_set", "pixel", "retention_days", "rule"};

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAggregationRuleField() {
            return this.requestAggregationRuleField(true);
        }

        public APIRequestGet requestAggregationRuleField(boolean value) {
            this.requestField("aggregation_rule", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCustomEventTypeField() {
            return this.requestCustomEventTypeField(true);
        }

        public APIRequestGet requestCustomEventTypeField(boolean value) {
            this.requestField("custom_event_type", value);
            return this;
        }

        public APIRequestGet requestDataSourcesField() {
            return this.requestDataSourcesField(true);
        }

        public APIRequestGet requestDataSourcesField(boolean value) {
            this.requestField("data_sources", value);
            return this;
        }

        public APIRequestGet requestDefaultConversionValueField() {
            return this.requestDefaultConversionValueField(true);
        }

        public APIRequestGet requestDefaultConversionValueField(boolean value) {
            this.requestField("default_conversion_value", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEventSourceTypeField() {
            return this.requestEventSourceTypeField(true);
        }

        public APIRequestGet requestEventSourceTypeField(boolean value) {
            this.requestField("event_source_type", value);
            return this;
        }

        public APIRequestGet requestFirstFiredTimeField() {
            return this.requestFirstFiredTimeField(true);
        }

        public APIRequestGet requestFirstFiredTimeField(boolean value) {
            this.requestField("first_fired_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsArchivedField() {
            return this.requestIsArchivedField(true);
        }

        public APIRequestGet requestIsArchivedField(boolean value) {
            this.requestField("is_archived", value);
            return this;
        }

        public APIRequestGet requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGet requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGet requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGet requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGet requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }

        public APIRequestGet requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGet requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGet requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGet requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetStats
    extends APIRequest<CustomConversionStatsResult> {
        APINodeList<CustomConversionStatsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"aggregation", "end_time", "start_time"};
        public static final String[] FIELDS = new String[]{"aggregation", "data", "timestamp"};

        @Override
        public APINodeList<CustomConversionStatsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomConversionStatsResult> parseResponse(String response) throws APIException {
            return CustomConversionStatsResult.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomConversionStatsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomConversionStatsResult> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomConversionStatsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomConversionStatsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomConversionStatsResult>>(){

                public APINodeList<CustomConversionStatsResult> apply(String result) {
                    try {
                        return APIRequestGetStats.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetStats(String nodeId, APIContext context) {
            super(context, nodeId, "/stats", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetStats setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetStats setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetStats setAggregation(CustomConversionStatsResult.EnumAggregation aggregation) {
            this.setParam("aggregation", (Object)aggregation);
            return this;
        }

        public APIRequestGetStats setAggregation(String aggregation) {
            this.setParam("aggregation", aggregation);
            return this;
        }

        public APIRequestGetStats setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetStats setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetStats requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetStats requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetStats requestAggregationField() {
            return this.requestAggregationField(true);
        }

        public APIRequestGetStats requestAggregationField(boolean value) {
            this.requestField("aggregation", value);
            return this;
        }

        public APIRequestGetStats requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetStats requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetStats requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetStats requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateSharedAgency
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestCreateSharedAgency.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateSharedAgency(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_agencies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSharedAgency setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSharedAgency setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSharedAgency setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateSharedAgency requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSharedAgency requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAgency requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSharedAgency requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAgency requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSharedAgency requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteSharedAgencies
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteSharedAgencies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteSharedAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_agencies", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteSharedAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteSharedAgencies setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteSharedAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteSharedAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteSharedAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdAccount
    extends APIRequest<CustomConversion> {
        CustomConversion lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomConversion getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversion parseResponse(String response) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversion execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversion execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversion> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversion> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversion>(){

                public CustomConversion apply(String result) {
                    try {
                        return APIRequestCreateAdAccount.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdAccount setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestCreateAdAccount setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateAdAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteAdAccounts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdAccounts setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestDeleteAdAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetActivities
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"end_time", "event_type", "start_time"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetActivities.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetActivities setEndTime(Object endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEventType(EnumEventType eventType) {
            this.setParam("event_type", (Object)eventType);
            return this;
        }

        public APIRequestGetActivities setEventType(String eventType) {
            this.setParam("event_type", eventType);
            return this;
        }

        public APIRequestGetActivities setStartTime(Object startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

