/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Photo;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Album
extends APINode {
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="backdated_time_granularity")
    private String mBackdatedTimeGranularity = null;
    @SerializedName(value="can_backdate")
    private Boolean mCanBackdate = null;
    @SerializedName(value="can_upload")
    private Boolean mCanUpload = null;
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="cover_photo")
    private Photo mCoverPhoto = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="edit_link")
    private Object mEditLink = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_user_facing")
    private Boolean mIsUserFacing = null;
    @SerializedName(value="link")
    private Object mLink = null;
    @SerializedName(value="location")
    private String mLocation = null;
    @SerializedName(value="modified_major")
    private String mModifiedMajor = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="photo_count")
    private Long mPhotoCount = null;
    @SerializedName(value="place")
    private Object mPlace = null;
    @SerializedName(value="privacy")
    private String mPrivacy = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="video_count")
    private Long mVideoCount = null;
    protected static Gson gson = null;

    Album() {
    }

    public Album(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Album(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Album fetch() throws APIException {
        Album newInstance = Album.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Album fetchById(Long id, APIContext context) throws APIException {
        return Album.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Album> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Album.fetchByIdAsync(id.toString(), context);
    }

    public static Album fetchById(String id, APIContext context) throws APIException {
        Album album = new APIRequestGet(id, context).requestAllFields().execute();
        return album;
    }

    public static ListenableFuture<Album> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<Album> album = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return album;
    }

    public static APINodeList<Album> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Album>(context, "", "/", "GET", Album.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Album>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> album = new APIRequest<Album>(context, "", "/", "GET", Album.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return album;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Album loadJSON(String json, APIContext context) {
        Album album = (Album)Album.getGson().fromJson(json, Album.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(album.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        album.context = context;
        album.rawValue = json;
        return album;
    }

    public static APINodeList<Album> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Album> albums = new APINodeList<Album>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        albums.add(Album.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return albums;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            albums.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        albums.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            albums.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            albums.add(Album.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                albums.add(Album.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            albums.add(Album.loadJSON(obj.toString(), context));
                        }
                    }
                    return albums;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        albums.add(Album.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return albums;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        albums.add(Album.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return albums;
                }
                albums.clear();
                albums.add(Album.loadJSON(json, context));
                return albums;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Album.getGson().toJson((Object)this);
    }

    public APIRequestCreatePhoto createPhoto() {
        return new APIRequestCreatePhoto(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public String getFieldBackdatedTimeGranularity() {
        return this.mBackdatedTimeGranularity;
    }

    public Boolean getFieldCanBackdate() {
        return this.mCanBackdate;
    }

    public Boolean getFieldCanUpload() {
        return this.mCanUpload;
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public Photo getFieldCoverPhoto() {
        if (this.mCoverPhoto != null) {
            this.mCoverPhoto.context = this.getContext();
        }
        return this.mCoverPhoto;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Object getFieldEditLink() {
        return this.mEditLink;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsUserFacing() {
        return this.mIsUserFacing;
    }

    public Object getFieldLink() {
        return this.mLink;
    }

    public String getFieldLocation() {
        return this.mLocation;
    }

    public String getFieldModifiedMajor() {
        return this.mModifiedMajor;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldPhotoCount() {
        return this.mPhotoCount;
    }

    public Object getFieldPlace() {
        return this.mPlace;
    }

    public String getFieldPrivacy() {
        return this.mPrivacy;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public Long getFieldVideoCount() {
        return this.mVideoCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Album copyFrom(Album instance) {
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mBackdatedTimeGranularity = instance.mBackdatedTimeGranularity;
        this.mCanBackdate = instance.mCanBackdate;
        this.mCanUpload = instance.mCanUpload;
        this.mCount = instance.mCount;
        this.mCoverPhoto = instance.mCoverPhoto;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEditLink = instance.mEditLink;
        this.mEvent = instance.mEvent;
        this.mFrom = instance.mFrom;
        this.mId = instance.mId;
        this.mIsUserFacing = instance.mIsUserFacing;
        this.mLink = instance.mLink;
        this.mLocation = instance.mLocation;
        this.mModifiedMajor = instance.mModifiedMajor;
        this.mName = instance.mName;
        this.mPhotoCount = instance.mPhotoCount;
        this.mPlace = instance.mPlace;
        this.mPrivacy = instance.mPrivacy;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVideoCount = instance.mVideoCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Album> getParser() {
        return new APIRequest.ResponseParser<Album>(){

            @Override
            public APINodeList<Album> parseResponse(String response, APIContext context, APIRequest<Album> request) throws APIException.MalformedResponseException {
                return Album.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Album> {
        Album lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"backdated_time", "backdated_time_granularity", "can_backdate", "can_upload", "count", "cover_photo", "created_time", "description", "edit_link", "event", "from", "id", "is_user_facing", "link", "location", "modified_major", "name", "photo_count", "place", "privacy", "type", "updated_time", "video_count"};

        @Override
        public Album getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Album parseResponse(String response) throws APIException {
            return Album.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Album execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Album execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Album> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Album> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Album>(){

                public Album apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGet requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGet requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGet requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGet requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGet requestCanUploadField() {
            return this.requestCanUploadField(true);
        }

        public APIRequestGet requestCanUploadField(boolean value) {
            this.requestField("can_upload", value);
            return this;
        }

        public APIRequestGet requestCountField() {
            return this.requestCountField(true);
        }

        public APIRequestGet requestCountField(boolean value) {
            this.requestField("count", value);
            return this;
        }

        public APIRequestGet requestCoverPhotoField() {
            return this.requestCoverPhotoField(true);
        }

        public APIRequestGet requestCoverPhotoField(boolean value) {
            this.requestField("cover_photo", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEditLinkField() {
            return this.requestEditLinkField(true);
        }

        public APIRequestGet requestEditLinkField(boolean value) {
            this.requestField("edit_link", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsUserFacingField() {
            return this.requestIsUserFacingField(true);
        }

        public APIRequestGet requestIsUserFacingField(boolean value) {
            this.requestField("is_user_facing", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestModifiedMajorField() {
            return this.requestModifiedMajorField(true);
        }

        public APIRequestGet requestModifiedMajorField(boolean value) {
            this.requestField("modified_major", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPhotoCountField() {
            return this.requestPhotoCountField(true);
        }

        public APIRequestGet requestPhotoCountField(boolean value) {
            this.requestField("photo_count", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGet requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestVideoCountField() {
            return this.requestVideoCountField(true);
        }

        public APIRequestGet requestVideoCountField(boolean value) {
            this.requestField("video_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePhoto
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"aid", "allow_spherical_photo", "application_id", "audience_exp", "backdated_time", "backdated_time_granularity", "caption", "composer_session_id", "direct_share_status", "feed_targeting", "full_res_is_coming_later", "initial_view_heading_override_degrees", "initial_view_pitch_override_degrees", "initial_view_vertical_fov_override_degrees", "is_explicit_location", "is_explicit_place", "manual_privacy", "message", "name", "no_story", "offline_id", "og_action_type_id", "og_icon_id", "og_object_id", "og_phrase", "og_set_profile_badge", "og_suggestion_mechanism", "place", "privacy", "profile_id", "published", "qn", "scheduled_publish_time", "spherical_metadata", "sponsor_id", "sponsor_relationship", "tags", "target_id", "targeting", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Photo>(){

                public Photo apply(String result) {
                    try {
                        return APIRequestCreatePhoto.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePhoto(String nodeId, APIContext context) {
            super(context, nodeId, "/photos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePhoto setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePhoto setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePhoto setAid(String aid) {
            this.setParam("aid", aid);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(Boolean allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(String allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(Photo.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreatePhoto setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(Object feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(String feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(Boolean fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(String fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(Long initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(String initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(Long initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(String initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(Long initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(String initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(Boolean isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(String isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreatePhoto setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(Boolean noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(String noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(Long offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(String offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreatePhoto setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreatePhoto setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreatePhoto setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreatePhoto setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePhoto setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(Long profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(String profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setQn(String qn) {
            this.setParam("qn", qn);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(Long scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(Map<String, String> sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(String sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setTags(List<Object> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(Long targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestCreatePhoto requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePhoto requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

