/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Targeting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingSentenceLine
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="params")
    private Targeting mParams = null;
    @SerializedName(value="targetingsentencelines")
    private JsonArray mTargetingsentencelines = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TargetingSentenceLine loadJSON(String json, APIContext context) {
        TargetingSentenceLine targetingSentenceLine = (TargetingSentenceLine)TargetingSentenceLine.getGson().fromJson(json, TargetingSentenceLine.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingSentenceLine.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingSentenceLine.context = context;
        targetingSentenceLine.rawValue = json;
        return targetingSentenceLine;
    }

    public static APINodeList<TargetingSentenceLine> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<TargetingSentenceLine> targetingSentenceLines = new APINodeList<TargetingSentenceLine>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingSentenceLines.add(TargetingSentenceLine.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingSentenceLines;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingSentenceLines.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingSentenceLines.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingSentenceLines.add(TargetingSentenceLine.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingSentenceLines.add(TargetingSentenceLine.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingSentenceLines.add(TargetingSentenceLine.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingSentenceLines;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingSentenceLines.add(TargetingSentenceLine.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingSentenceLines;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingSentenceLines.add(TargetingSentenceLine.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingSentenceLines;
                }
                targetingSentenceLines.clear();
                targetingSentenceLines.add(TargetingSentenceLine.loadJSON(json, context));
                return targetingSentenceLines;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingSentenceLine.getGson().toJson((Object)this);
    }

    public String getFieldId() {
        return this.mId;
    }

    public TargetingSentenceLine setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Targeting getFieldParams() {
        return this.mParams;
    }

    public TargetingSentenceLine setFieldParams(Targeting value) {
        this.mParams = value;
        return this;
    }

    public TargetingSentenceLine setFieldParams(String value) {
        Type type = new TypeToken<Targeting>(){}.getType();
        this.mParams = (Targeting)Targeting.getGson().fromJson(value, type);
        return this;
    }

    public JsonArray getFieldTargetingsentencelines() {
        return this.mTargetingsentencelines;
    }

    public TargetingSentenceLine setFieldTargetingsentencelines(JsonArray value) {
        this.mTargetingsentencelines = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingSentenceLine copyFrom(TargetingSentenceLine instance) {
        this.mId = instance.mId;
        this.mParams = instance.mParams;
        this.mTargetingsentencelines = instance.mTargetingsentencelines;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingSentenceLine> getParser() {
        return new APIRequest.ResponseParser<TargetingSentenceLine>(){

            @Override
            public APINodeList<TargetingSentenceLine> parseResponse(String response, APIContext context, APIRequest<TargetingSentenceLine> request) throws APIException.MalformedResponseException {
                return TargetingSentenceLine.parseResponse(response, context, request);
            }
        };
    }
}

