/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Album;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Photo
extends APINode {
    @SerializedName(value="album")
    private Album mAlbum = null;
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="backdated_time_granularity")
    private String mBackdatedTimeGranularity = null;
    @SerializedName(value="can_backdate")
    private Boolean mCanBackdate = null;
    @SerializedName(value="can_delete")
    private Boolean mCanDelete = null;
    @SerializedName(value="can_tag")
    private Boolean mCanTag = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="images")
    private List<Object> mImages = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="name_tags")
    private List<Object> mNameTags = null;
    @SerializedName(value="page_story_id")
    private String mPageStoryId = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place")
    private Object mPlace = null;
    @SerializedName(value="position")
    private Long mPosition = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="target")
    private Profile mTarget = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="webp_images")
    private List<Object> mWebpImages = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    Photo() {
    }

    public Photo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Photo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Photo fetch() throws APIException {
        Photo newInstance = Photo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Photo fetchById(Long id, APIContext context) throws APIException {
        return Photo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Photo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Photo.fetchByIdAsync(id.toString(), context);
    }

    public static Photo fetchById(String id, APIContext context) throws APIException {
        Photo photo = new APIRequestGet(id, context).requestAllFields().execute();
        return photo;
    }

    public static ListenableFuture<Photo> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<Photo> photo = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return photo;
    }

    public static APINodeList<Photo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Photo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> photo = new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return photo;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Photo loadJSON(String json, APIContext context) {
        Photo photo = (Photo)Photo.getGson().fromJson(json, Photo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(photo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        photo.context = context;
        photo.rawValue = json;
        return photo;
    }

    public static APINodeList<Photo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<Photo> photos = new APINodeList<Photo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return photos;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            photos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        photos.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            photos.add(Photo.loadJSON(obj.toString(), context));
                        }
                    }
                    return photos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return photos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        photos.add(Photo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return photos;
                }
                photos.clear();
                photos.add(Photo.loadJSON(json, context));
                return photos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Photo.getGson().toJson((Object)this);
    }

    public APIRequestDeleteLikes deleteLikes() {
        return new APIRequestDeleteLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLike createLike() {
        return new APIRequestCreateLike(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateTag createTag() {
        return new APIRequestCreateTag(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Album getFieldAlbum() {
        if (this.mAlbum != null) {
            this.mAlbum.context = this.getContext();
        }
        return this.mAlbum;
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public String getFieldBackdatedTimeGranularity() {
        return this.mBackdatedTimeGranularity;
    }

    public Boolean getFieldCanBackdate() {
        return this.mCanBackdate;
    }

    public Boolean getFieldCanDelete() {
        return this.mCanDelete;
    }

    public Boolean getFieldCanTag() {
        return this.mCanTag;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Object> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<Object> getFieldNameTags() {
        return this.mNameTags;
    }

    public String getFieldPageStoryId() {
        return this.mPageStoryId;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public Object getFieldPlace() {
        return this.mPlace;
    }

    public Long getFieldPosition() {
        return this.mPosition;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Profile getFieldTarget() {
        if (this.mTarget != null) {
            this.mTarget.context = this.getContext();
        }
        return this.mTarget;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public List<Object> getFieldWebpImages() {
        return this.mWebpImages;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Photo copyFrom(Photo instance) {
        this.mAlbum = instance.mAlbum;
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mBackdatedTimeGranularity = instance.mBackdatedTimeGranularity;
        this.mCanBackdate = instance.mCanBackdate;
        this.mCanDelete = instance.mCanDelete;
        this.mCanTag = instance.mCanTag;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEvent = instance.mEvent;
        this.mFrom = instance.mFrom;
        this.mHeight = instance.mHeight;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mImages = instance.mImages;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mNameTags = instance.mNameTags;
        this.mPageStoryId = instance.mPageStoryId;
        this.mPicture = instance.mPicture;
        this.mPlace = instance.mPlace;
        this.mPosition = instance.mPosition;
        this.mSource = instance.mSource;
        this.mTarget = instance.mTarget;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mWebpImages = instance.mWebpImages;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Photo> getParser() {
        return new APIRequest.ResponseParser<Photo>(){

            @Override
            public APINodeList<Photo> parseResponse(String response, APIContext context, APIRequest<Photo> request) throws APIException.MalformedResponseException {
                return Photo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCheckinEntryPoint {
        VALUE_BRANDING_CHECKIN("BRANDING_CHECKIN"),
        VALUE_BRANDING_STATUS("BRANDING_STATUS"),
        VALUE_BRANDING_PHOTO("BRANDING_PHOTO"),
        VALUE_BRANDING_OTHER("BRANDING_OTHER"),
        NULL(null);

        private String value;

        private EnumCheckinEntryPoint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumUnpublishedContentType {
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_ADS_POST("ADS_POST"),
        VALUE_INLINE_CREATED("INLINE_CREATED"),
        VALUE_PUBLISHED("PUBLISHED"),
        NULL(null);

        private String value;

        private EnumUnpublishedContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_PROFILE("profile"),
        VALUE_TAGGED("tagged"),
        VALUE_UPLOADED("uploaded"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackdatedTimeGranularity {
        VALUE_YEAR("year"),
        VALUE_MONTH("month"),
        VALUE_DAY("day"),
        VALUE_HOUR("hour"),
        VALUE_MIN("min"),
        VALUE_NONE("none"),
        NULL(null);

        private String value;

        private EnumBackdatedTimeGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"android_key_hash", "asset3d_id", "backdated_time", "backdated_time_granularity", "checkin_entry_point", "composer_session_id", "direct_share_status", "ios_bundle_id", "is_checkin", "is_cropped", "is_explicit_location", "og_action_type_id", "og_icon_id", "og_object_id", "og_phrase", "og_set_profile_badge", "og_suggestion_mechanism", "place", "privacy", "prompt_id", "prompt_tracking_string", "proxied_app_id", "published", "referenced_sticker_id", "sponsor_id", "sponsor_relationship", "tags", "target", "target_post", "time_since_original_post"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Photo>(){

                public Photo apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestUpdate setAsset3dId(Long asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestUpdate setAsset3dId(String asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestUpdate setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestUpdate setBackdatedTimeGranularity(EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestUpdate setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestUpdate setCheckinEntryPoint(EnumCheckinEntryPoint checkinEntryPoint) {
            this.setParam("checkin_entry_point", (Object)checkinEntryPoint);
            return this;
        }

        public APIRequestUpdate setCheckinEntryPoint(String checkinEntryPoint) {
            this.setParam("checkin_entry_point", checkinEntryPoint);
            return this;
        }

        public APIRequestUpdate setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestUpdate setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestUpdate setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestUpdate setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestUpdate setIsCheckin(Boolean isCheckin) {
            this.setParam("is_checkin", isCheckin);
            return this;
        }

        public APIRequestUpdate setIsCheckin(String isCheckin) {
            this.setParam("is_checkin", isCheckin);
            return this;
        }

        public APIRequestUpdate setIsCropped(Boolean isCropped) {
            this.setParam("is_cropped", isCropped);
            return this;
        }

        public APIRequestUpdate setIsCropped(String isCropped) {
            this.setParam("is_cropped", isCropped);
            return this;
        }

        public APIRequestUpdate setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestUpdate setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestUpdate setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestUpdate setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestUpdate setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestUpdate setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestUpdate setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestUpdate setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestUpdate setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestUpdate setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestUpdate setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestUpdate setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestUpdate setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestUpdate setPromptId(String promptId) {
            this.setParam("prompt_id", promptId);
            return this;
        }

        public APIRequestUpdate setPromptTrackingString(String promptTrackingString) {
            this.setParam("prompt_tracking_string", promptTrackingString);
            return this;
        }

        public APIRequestUpdate setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestUpdate setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestUpdate setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestUpdate setReferencedStickerId(String referencedStickerId) {
            this.setParam("referenced_sticker_id", referencedStickerId);
            return this;
        }

        public APIRequestUpdate setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestUpdate setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestUpdate setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestUpdate setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestUpdate setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestUpdate setTarget(Object target) {
            this.setParam("target", target);
            return this;
        }

        public APIRequestUpdate setTarget(String target) {
            this.setParam("target", target);
            return this;
        }

        public APIRequestUpdate setTargetPost(String targetPost) {
            this.setParam("target_post", targetPost);
            return this;
        }

        public APIRequestUpdate setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestUpdate setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"album", "backdated_time", "backdated_time_granularity", "can_backdate", "can_delete", "can_tag", "created_time", "event", "from", "height", "icon", "id", "images", "link", "name", "name_tags", "page_story_id", "picture", "place", "position", "source", "target", "updated_time", "webp_images", "width"};

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Photo>(){

                public Photo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAlbumField() {
            return this.requestAlbumField(true);
        }

        public APIRequestGet requestAlbumField(boolean value) {
            this.requestField("album", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGet requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGet requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGet requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGet requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGet requestCanDeleteField() {
            return this.requestCanDeleteField(true);
        }

        public APIRequestGet requestCanDeleteField(boolean value) {
            this.requestField("can_delete", value);
            return this;
        }

        public APIRequestGet requestCanTagField() {
            return this.requestCanTagField(true);
        }

        public APIRequestGet requestCanTagField(boolean value) {
            this.requestField("can_tag", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGet requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNameTagsField() {
            return this.requestNameTagsField(true);
        }

        public APIRequestGet requestNameTagsField(boolean value) {
            this.requestField("name_tags", value);
            return this;
        }

        public APIRequestGet requestPageStoryIdField() {
            return this.requestPageStoryIdField(true);
        }

        public APIRequestGet requestPageStoryIdField(boolean value) {
            this.requestField("page_story_id", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGet requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestWebpImagesField() {
            return this.requestWebpImagesField(true);
        }

        public APIRequestGet requestWebpImagesField(boolean value) {
            this.requestField("webp_images", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"pid"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete setPid(String pid) {
            this.setParam("pid", pid);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateTag
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"tag_text", "tag_uid", "tags", "x", "y"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateTag.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateTag(String nodeId, APIContext context) {
            super(context, nodeId, "/tags", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateTag setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateTag setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateTag setTagText(String tagText) {
            this.setParam("tag_text", tagText);
            return this;
        }

        public APIRequestCreateTag setTagUid(Long tagUid) {
            this.setParam("tag_uid", tagUid);
            return this;
        }

        public APIRequestCreateTag setTagUid(String tagUid) {
            this.setParam("tag_uid", tagUid);
            return this;
        }

        public APIRequestCreateTag setTags(List<Object> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateTag setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateTag setX(Double x) {
            this.setParam("x", x);
            return this;
        }

        public APIRequestCreateTag setX(String x) {
            this.setParam("x", x);
            return this;
        }

        public APIRequestCreateTag setY(Double y) {
            this.setParam("y", y);
            return this;
        }

        public APIRequestCreateTag setY(String y) {
            this.setParam("y", y);
            return this;
        }

        public APIRequestCreateTag requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateTag requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTag requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateTag requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTag requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateTag requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLike
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateLike.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLike(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLike setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLike setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLike requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLike requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteLikes
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteLikes.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

