/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementReport
extends APINode {
    @SerializedName(value="download_urls")
    private List<String> mDownloadUrls = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="metadata")
    private Map<String, String> mMetadata = null;
    @SerializedName(value="report_type")
    private String mReportType = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="upload_urls")
    private List<String> mUploadUrls = null;
    protected static Gson gson = null;

    MeasurementReport() {
    }

    public MeasurementReport(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MeasurementReport(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MeasurementReport fetch() throws APIException {
        MeasurementReport newInstance = MeasurementReport.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MeasurementReport fetchById(Long id, APIContext context) throws APIException {
        return MeasurementReport.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MeasurementReport> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MeasurementReport.fetchByIdAsync(id.toString(), context);
    }

    public static MeasurementReport fetchById(String id, APIContext context) throws APIException {
        MeasurementReport measurementReport = new APIRequestGet(id, context).requestAllFields().execute();
        return measurementReport;
    }

    public static ListenableFuture<MeasurementReport> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<MeasurementReport> measurementReport = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return measurementReport;
    }

    public static APINodeList<MeasurementReport> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MeasurementReport>(context, "", "/", "GET", MeasurementReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MeasurementReport>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> measurementReport = new APIRequest<MeasurementReport>(context, "", "/", "GET", MeasurementReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return measurementReport;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MeasurementReport loadJSON(String json, APIContext context) {
        MeasurementReport measurementReport = (MeasurementReport)MeasurementReport.getGson().fromJson(json, MeasurementReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(measurementReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        measurementReport.context = context;
        measurementReport.rawValue = json;
        return measurementReport;
    }

    public static APINodeList<MeasurementReport> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<MeasurementReport> measurementReports = new APINodeList<MeasurementReport>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        measurementReports.add(MeasurementReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return measurementReports;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            measurementReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        measurementReports.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            measurementReports.add(MeasurementReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                measurementReports.add(MeasurementReport.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            measurementReports.add(MeasurementReport.loadJSON(obj.toString(), context));
                        }
                    }
                    return measurementReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        measurementReports.add(MeasurementReport.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return measurementReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        measurementReports.add(MeasurementReport.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return measurementReports;
                }
                measurementReports.clear();
                measurementReports.add(MeasurementReport.loadJSON(json, context));
                return measurementReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MeasurementReport.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldDownloadUrls() {
        return this.mDownloadUrls;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Map<String, String> getFieldMetadata() {
        return this.mMetadata;
    }

    public String getFieldReportType() {
        return this.mReportType;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldUploadUrls() {
        return this.mUploadUrls;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MeasurementReport copyFrom(MeasurementReport instance) {
        this.mDownloadUrls = instance.mDownloadUrls;
        this.mId = instance.mId;
        this.mMetadata = instance.mMetadata;
        this.mReportType = instance.mReportType;
        this.mStatus = instance.mStatus;
        this.mUploadUrls = instance.mUploadUrls;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MeasurementReport> getParser() {
        return new APIRequest.ResponseParser<MeasurementReport>(){

            @Override
            public APINodeList<MeasurementReport> parseResponse(String response, APIContext context, APIRequest<MeasurementReport> request) throws APIException.MalformedResponseException {
                return MeasurementReport.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumReportType {
        VALUE_MULTI_CHANNEL_REPORT("multi_channel_report"),
        VALUE_VIDEO_METRICS_REPORT("video_metrics_report"),
        VALUE_FRUIT_ROLLUP_REPORT("fruit_rollup_report"),
        VALUE_THIRD_PARTY_MTA_REPORT("third_party_mta_report"),
        VALUE_PARTNER_LIFT_STUDY_REPORT("partner_lift_study_report"),
        VALUE_MMM_REPORT("mmm_report"),
        NULL(null);

        private String value;

        private EnumReportType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<MeasurementReport> {
        MeasurementReport lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_last_batch", "payload", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public MeasurementReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MeasurementReport parseResponse(String response) throws APIException {
            return MeasurementReport.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public MeasurementReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MeasurementReport execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<MeasurementReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MeasurementReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MeasurementReport>(){

                public MeasurementReport apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setIsLastBatch(Boolean isLastBatch) {
            this.setParam("is_last_batch", isLastBatch);
            return this;
        }

        public APIRequestUpdate setIsLastBatch(String isLastBatch) {
            this.setParam("is_last_batch", isLastBatch);
            return this;
        }

        public APIRequestUpdate setPayload(File payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestUpdate setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MeasurementReport> {
        MeasurementReport lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"download_urls", "id", "metadata", "report_type", "status", "upload_urls"};

        @Override
        public MeasurementReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MeasurementReport parseResponse(String response) throws APIException {
            return MeasurementReport.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public MeasurementReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MeasurementReport execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<MeasurementReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MeasurementReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, MeasurementReport>(){

                public MeasurementReport apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDownloadUrlsField() {
            return this.requestDownloadUrlsField(true);
        }

        public APIRequestGet requestDownloadUrlsField(boolean value) {
            this.requestField("download_urls", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMetadataField() {
            return this.requestMetadataField(true);
        }

        public APIRequestGet requestMetadataField(boolean value) {
            this.requestField("metadata", value);
            return this;
        }

        public APIRequestGet requestReportTypeField() {
            return this.requestReportTypeField(true);
        }

        public APIRequestGet requestReportTypeField(boolean value) {
            this.requestField("report_type", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUploadUrlsField() {
            return this.requestUploadUrlsField(true);
        }

        public APIRequestGet requestUploadUrlsField(boolean value) {
            this.requestField("upload_urls", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

