/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.FundingSourceDetailsCoupon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FundingSourceDetails
extends APINode {
    @SerializedName(value="coupon")
    private FundingSourceDetailsCoupon mCoupon = null;
    @SerializedName(value="display_string")
    private String mDisplayString = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="type")
    private Long mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FundingSourceDetails loadJSON(String json, APIContext context) {
        FundingSourceDetails fundingSourceDetails = (FundingSourceDetails)FundingSourceDetails.getGson().fromJson(json, FundingSourceDetails.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(fundingSourceDetails.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        fundingSourceDetails.context = context;
        fundingSourceDetails.rawValue = json;
        return fundingSourceDetails;
    }

    public static APINodeList<FundingSourceDetails> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<FundingSourceDetails> fundingSourceDetailss = new APINodeList<FundingSourceDetails>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        fundingSourceDetailss.add(FundingSourceDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return fundingSourceDetailss;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            fundingSourceDetailss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        fundingSourceDetailss.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            fundingSourceDetailss.add(FundingSourceDetails.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                fundingSourceDetailss.add(FundingSourceDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            fundingSourceDetailss.add(FundingSourceDetails.loadJSON(obj.toString(), context));
                        }
                    }
                    return fundingSourceDetailss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        fundingSourceDetailss.add(FundingSourceDetails.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return fundingSourceDetailss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        fundingSourceDetailss.add(FundingSourceDetails.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return fundingSourceDetailss;
                }
                fundingSourceDetailss.clear();
                fundingSourceDetailss.add(FundingSourceDetails.loadJSON(json, context));
                return fundingSourceDetailss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FundingSourceDetails.getGson().toJson((Object)this);
    }

    public FundingSourceDetailsCoupon getFieldCoupon() {
        return this.mCoupon;
    }

    public FundingSourceDetails setFieldCoupon(FundingSourceDetailsCoupon value) {
        this.mCoupon = value;
        return this;
    }

    public FundingSourceDetails setFieldCoupon(String value) {
        Type type = new TypeToken<FundingSourceDetailsCoupon>(){}.getType();
        this.mCoupon = (FundingSourceDetailsCoupon)FundingSourceDetailsCoupon.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldDisplayString() {
        return this.mDisplayString;
    }

    public FundingSourceDetails setFieldDisplayString(String value) {
        this.mDisplayString = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public FundingSourceDetails setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Long getFieldType() {
        return this.mType;
    }

    public FundingSourceDetails setFieldType(Long value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FundingSourceDetails copyFrom(FundingSourceDetails instance) {
        this.mCoupon = instance.mCoupon;
        this.mDisplayString = instance.mDisplayString;
        this.mId = instance.mId;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FundingSourceDetails> getParser() {
        return new APIRequest.ResponseParser<FundingSourceDetails>(){

            @Override
            public APINodeList<FundingSourceDetails> parseResponse(String response, APIContext context, APIRequest<FundingSourceDetails> request) throws APIException.MalformedResponseException {
                return FundingSourceDetails.parseResponse(response, context, request);
            }
        };
    }
}

