/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionActionQuery
extends APINode {
    @SerializedName(value="action.type")
    private List<Object> mActionType = null;
    @SerializedName(value="application")
    private List<Object> mApplication = null;
    @SerializedName(value="conversion_id")
    private List<String> mConversionId = null;
    @SerializedName(value="creative")
    private List<Object> mCreative = null;
    @SerializedName(value="dataset")
    private List<String> mDataset = null;
    @SerializedName(value="event")
    private List<String> mEvent = null;
    @SerializedName(value="event.creator")
    private List<String> mEventCreator = null;
    @SerializedName(value="event_type")
    private List<String> mEventType = null;
    @SerializedName(value="fb_pixel")
    private List<String> mFbPixel = null;
    @SerializedName(value="fb_pixel_event")
    private List<String> mFbPixelEvent = null;
    @SerializedName(value="leadgen")
    private List<String> mLeadgen = null;
    @SerializedName(value="object")
    private List<String> mObject = null;
    @SerializedName(value="object.domain")
    private List<String> mObjectDomain = null;
    @SerializedName(value="offer")
    private List<String> mOffer = null;
    @SerializedName(value="offer.creator")
    private List<String> mOfferCreator = null;
    @SerializedName(value="offsite_pixel")
    private List<String> mOffsitePixel = null;
    @SerializedName(value="page")
    private List<String> mPage = null;
    @SerializedName(value="page.parent")
    private List<String> mPageParent = null;
    @SerializedName(value="post")
    private List<String> mPost = null;
    @SerializedName(value="post.object")
    private List<String> mPostObject = null;
    @SerializedName(value="post.object.wall")
    private List<String> mPostObjectWall = null;
    @SerializedName(value="post.wall")
    private List<String> mPostWall = null;
    @SerializedName(value="question")
    private List<String> mQuestion = null;
    @SerializedName(value="question.creator")
    private List<String> mQuestionCreator = null;
    @SerializedName(value="response")
    private List<String> mResponse = null;
    @SerializedName(value="subtype")
    private List<String> mSubtype = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ConversionActionQuery loadJSON(String json, APIContext context) {
        ConversionActionQuery conversionActionQuery = (ConversionActionQuery)ConversionActionQuery.getGson().fromJson(json, ConversionActionQuery.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(conversionActionQuery.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        conversionActionQuery.context = context;
        conversionActionQuery.rawValue = json;
        return conversionActionQuery;
    }

    public static APINodeList<ConversionActionQuery> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<ConversionActionQuery> conversionActionQuerys = new APINodeList<ConversionActionQuery>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        conversionActionQuerys.add(ConversionActionQuery.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return conversionActionQuerys;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            conversionActionQuerys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        conversionActionQuerys.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            conversionActionQuerys.add(ConversionActionQuery.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                conversionActionQuerys.add(ConversionActionQuery.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            conversionActionQuerys.add(ConversionActionQuery.loadJSON(obj.toString(), context));
                        }
                    }
                    return conversionActionQuerys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        conversionActionQuerys.add(ConversionActionQuery.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return conversionActionQuerys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        conversionActionQuerys.add(ConversionActionQuery.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return conversionActionQuerys;
                }
                conversionActionQuerys.clear();
                conversionActionQuerys.add(ConversionActionQuery.loadJSON(json, context));
                return conversionActionQuerys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ConversionActionQuery.getGson().toJson((Object)this);
    }

    public List<Object> getFieldActionType() {
        return this.mActionType;
    }

    public ConversionActionQuery setFieldActionType(List<Object> value) {
        this.mActionType = value;
        return this;
    }

    public List<Object> getFieldApplication() {
        return this.mApplication;
    }

    public ConversionActionQuery setFieldApplication(List<Object> value) {
        this.mApplication = value;
        return this;
    }

    public List<String> getFieldConversionId() {
        return this.mConversionId;
    }

    public ConversionActionQuery setFieldConversionId(List<String> value) {
        this.mConversionId = value;
        return this;
    }

    public List<Object> getFieldCreative() {
        return this.mCreative;
    }

    public ConversionActionQuery setFieldCreative(List<Object> value) {
        this.mCreative = value;
        return this;
    }

    public List<String> getFieldDataset() {
        return this.mDataset;
    }

    public ConversionActionQuery setFieldDataset(List<String> value) {
        this.mDataset = value;
        return this;
    }

    public List<String> getFieldEvent() {
        return this.mEvent;
    }

    public ConversionActionQuery setFieldEvent(List<String> value) {
        this.mEvent = value;
        return this;
    }

    public List<String> getFieldEventCreator() {
        return this.mEventCreator;
    }

    public ConversionActionQuery setFieldEventCreator(List<String> value) {
        this.mEventCreator = value;
        return this;
    }

    public List<String> getFieldEventType() {
        return this.mEventType;
    }

    public ConversionActionQuery setFieldEventType(List<String> value) {
        this.mEventType = value;
        return this;
    }

    public List<String> getFieldFbPixel() {
        return this.mFbPixel;
    }

    public ConversionActionQuery setFieldFbPixel(List<String> value) {
        this.mFbPixel = value;
        return this;
    }

    public List<String> getFieldFbPixelEvent() {
        return this.mFbPixelEvent;
    }

    public ConversionActionQuery setFieldFbPixelEvent(List<String> value) {
        this.mFbPixelEvent = value;
        return this;
    }

    public List<String> getFieldLeadgen() {
        return this.mLeadgen;
    }

    public ConversionActionQuery setFieldLeadgen(List<String> value) {
        this.mLeadgen = value;
        return this;
    }

    public List<String> getFieldObject() {
        return this.mObject;
    }

    public ConversionActionQuery setFieldObject(List<String> value) {
        this.mObject = value;
        return this;
    }

    public List<String> getFieldObjectDomain() {
        return this.mObjectDomain;
    }

    public ConversionActionQuery setFieldObjectDomain(List<String> value) {
        this.mObjectDomain = value;
        return this;
    }

    public List<String> getFieldOffer() {
        return this.mOffer;
    }

    public ConversionActionQuery setFieldOffer(List<String> value) {
        this.mOffer = value;
        return this;
    }

    public List<String> getFieldOfferCreator() {
        return this.mOfferCreator;
    }

    public ConversionActionQuery setFieldOfferCreator(List<String> value) {
        this.mOfferCreator = value;
        return this;
    }

    public List<String> getFieldOffsitePixel() {
        return this.mOffsitePixel;
    }

    public ConversionActionQuery setFieldOffsitePixel(List<String> value) {
        this.mOffsitePixel = value;
        return this;
    }

    public List<String> getFieldPage() {
        return this.mPage;
    }

    public ConversionActionQuery setFieldPage(List<String> value) {
        this.mPage = value;
        return this;
    }

    public List<String> getFieldPageParent() {
        return this.mPageParent;
    }

    public ConversionActionQuery setFieldPageParent(List<String> value) {
        this.mPageParent = value;
        return this;
    }

    public List<String> getFieldPost() {
        return this.mPost;
    }

    public ConversionActionQuery setFieldPost(List<String> value) {
        this.mPost = value;
        return this;
    }

    public List<String> getFieldPostObject() {
        return this.mPostObject;
    }

    public ConversionActionQuery setFieldPostObject(List<String> value) {
        this.mPostObject = value;
        return this;
    }

    public List<String> getFieldPostObjectWall() {
        return this.mPostObjectWall;
    }

    public ConversionActionQuery setFieldPostObjectWall(List<String> value) {
        this.mPostObjectWall = value;
        return this;
    }

    public List<String> getFieldPostWall() {
        return this.mPostWall;
    }

    public ConversionActionQuery setFieldPostWall(List<String> value) {
        this.mPostWall = value;
        return this;
    }

    public List<String> getFieldQuestion() {
        return this.mQuestion;
    }

    public ConversionActionQuery setFieldQuestion(List<String> value) {
        this.mQuestion = value;
        return this;
    }

    public List<String> getFieldQuestionCreator() {
        return this.mQuestionCreator;
    }

    public ConversionActionQuery setFieldQuestionCreator(List<String> value) {
        this.mQuestionCreator = value;
        return this;
    }

    public List<String> getFieldResponse() {
        return this.mResponse;
    }

    public ConversionActionQuery setFieldResponse(List<String> value) {
        this.mResponse = value;
        return this;
    }

    public List<String> getFieldSubtype() {
        return this.mSubtype;
    }

    public ConversionActionQuery setFieldSubtype(List<String> value) {
        this.mSubtype = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ConversionActionQuery copyFrom(ConversionActionQuery instance) {
        this.mActionType = instance.mActionType;
        this.mApplication = instance.mApplication;
        this.mConversionId = instance.mConversionId;
        this.mCreative = instance.mCreative;
        this.mDataset = instance.mDataset;
        this.mEvent = instance.mEvent;
        this.mEventCreator = instance.mEventCreator;
        this.mEventType = instance.mEventType;
        this.mFbPixel = instance.mFbPixel;
        this.mFbPixelEvent = instance.mFbPixelEvent;
        this.mLeadgen = instance.mLeadgen;
        this.mObject = instance.mObject;
        this.mObjectDomain = instance.mObjectDomain;
        this.mOffer = instance.mOffer;
        this.mOfferCreator = instance.mOfferCreator;
        this.mOffsitePixel = instance.mOffsitePixel;
        this.mPage = instance.mPage;
        this.mPageParent = instance.mPageParent;
        this.mPost = instance.mPost;
        this.mPostObject = instance.mPostObject;
        this.mPostObjectWall = instance.mPostObjectWall;
        this.mPostWall = instance.mPostWall;
        this.mQuestion = instance.mQuestion;
        this.mQuestionCreator = instance.mQuestionCreator;
        this.mResponse = instance.mResponse;
        this.mSubtype = instance.mSubtype;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ConversionActionQuery> getParser() {
        return new APIRequest.ResponseParser<ConversionActionQuery>(){

            @Override
            public APINodeList<ConversionActionQuery> parseResponse(String response, APIContext context, APIRequest<ConversionActionQuery> request) throws APIException.MalformedResponseException {
                return ConversionActionQuery.parseResponse(response, context, request);
            }
        };
    }
}

