/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessUser
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="first_name")
    private String mFirstName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_name")
    private String mLastName = null;
    @SerializedName(value="marked_for_removal")
    private Boolean mMarkedForRemoval = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="pending_email")
    private String mPendingEmail = null;
    @SerializedName(value="role")
    private String mRole = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="two_fac_status")
    private String mTwoFacStatus = null;
    protected static Gson gson = null;

    BusinessUser() {
    }

    public BusinessUser(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessUser(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessUser fetch() throws APIException {
        BusinessUser newInstance = BusinessUser.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessUser fetchById(Long id, APIContext context) throws APIException {
        return BusinessUser.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessUser> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessUser.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessUser fetchById(String id, APIContext context) throws APIException {
        BusinessUser businessUser = new APIRequestGet(id, context).requestAllFields().execute();
        return businessUser;
    }

    public static ListenableFuture<BusinessUser> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<BusinessUser> businessUser = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return businessUser;
    }

    public static APINodeList<BusinessUser> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessUser>(context, "", "/", "GET", BusinessUser.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessUser>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> businessUser = new APIRequest<BusinessUser>(context, "", "/", "GET", BusinessUser.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return businessUser;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessUser loadJSON(String json, APIContext context) {
        BusinessUser businessUser = (BusinessUser)BusinessUser.getGson().fromJson(json, BusinessUser.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessUser.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessUser.context = context;
        businessUser.rawValue = json;
        return businessUser;
    }

    public static APINodeList<BusinessUser> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<BusinessUser> businessUsers = new APINodeList<BusinessUser>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessUsers.add(BusinessUser.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return businessUsers;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessUsers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessUsers.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessUsers.add(BusinessUser.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessUsers.add(BusinessUser.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessUsers.add(BusinessUser.loadJSON(obj.toString(), context));
                        }
                    }
                    return businessUsers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessUsers.add(BusinessUser.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return businessUsers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessUsers.add(BusinessUser.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessUsers;
                }
                businessUsers.clear();
                businessUsers.add(BusinessUser.loadJSON(json, context));
                return businessUsers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessUser.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldFirstName() {
        return this.mFirstName;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastName() {
        return this.mLastName;
    }

    public Boolean getFieldMarkedForRemoval() {
        return this.mMarkedForRemoval;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPendingEmail() {
        return this.mPendingEmail;
    }

    public String getFieldRole() {
        return this.mRole;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldTwoFacStatus() {
        return this.mTwoFacStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessUser copyFrom(BusinessUser instance) {
        this.mBusiness = instance.mBusiness;
        this.mEmail = instance.mEmail;
        this.mFirstName = instance.mFirstName;
        this.mId = instance.mId;
        this.mLastName = instance.mLastName;
        this.mMarkedForRemoval = instance.mMarkedForRemoval;
        this.mName = instance.mName;
        this.mPendingEmail = instance.mPendingEmail;
        this.mRole = instance.mRole;
        this.mTitle = instance.mTitle;
        this.mTwoFacStatus = instance.mTwoFacStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessUser> getParser() {
        return new APIRequest.ResponseParser<BusinessUser>(){

            @Override
            public APINodeList<BusinessUser> parseResponse(String response, APIContext context, APIRequest<BusinessUser> request) throws APIException.MalformedResponseException {
                return BusinessUser.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumRole {
        VALUE_FINANCE_EDITOR("FINANCE_EDITOR"),
        VALUE_FINANCE_ANALYST("FINANCE_ANALYST"),
        VALUE_ADS_RIGHTS_REVIEWER("ADS_RIGHTS_REVIEWER"),
        VALUE_ADMIN("ADMIN"),
        VALUE_EMPLOYEE("EMPLOYEE"),
        VALUE_FB_EMPLOYEE_SALES_REP("FB_EMPLOYEE_SALES_REP"),
        NULL(null);

        private String value;

        private EnumRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<BusinessUser> {
        BusinessUser lastResponse = null;
        public static final String[] PARAMS = new String[]{"clear_pending_email", "email", "first_name", "last_name", "role", "title"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessUser getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessUser parseResponse(String response) throws APIException {
            return BusinessUser.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BusinessUser execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessUser execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BusinessUser> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessUser> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BusinessUser>(){

                public BusinessUser apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setClearPendingEmail(Boolean clearPendingEmail) {
            this.setParam("clear_pending_email", clearPendingEmail);
            return this;
        }

        public APIRequestUpdate setClearPendingEmail(String clearPendingEmail) {
            this.setParam("clear_pending_email", clearPendingEmail);
            return this;
        }

        public APIRequestUpdate setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestUpdate setFirstName(String firstName) {
            this.setParam("first_name", firstName);
            return this;
        }

        public APIRequestUpdate setLastName(String lastName) {
            this.setParam("last_name", lastName);
            return this;
        }

        public APIRequestUpdate setRole(EnumRole role) {
            this.setParam("role", (Object)role);
            return this;
        }

        public APIRequestUpdate setRole(String role) {
            this.setParam("role", role);
            return this;
        }

        public APIRequestUpdate setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessUser> {
        BusinessUser lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "email", "first_name", "id", "last_name", "marked_for_removal", "name", "pending_email", "role", "title", "two_fac_status"};

        @Override
        public BusinessUser getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessUser parseResponse(String response) throws APIException {
            return BusinessUser.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BusinessUser execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessUser execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BusinessUser> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessUser> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BusinessUser>(){

                public BusinessUser apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGet requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGet requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGet requestMarkedForRemovalField() {
            return this.requestMarkedForRemovalField(true);
        }

        public APIRequestGet requestMarkedForRemovalField(boolean value) {
            this.requestField("marked_for_removal", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPendingEmailField() {
            return this.requestPendingEmailField(true);
        }

        public APIRequestGet requestPendingEmailField(boolean value) {
            this.requestField("pending_email", value);
            return this;
        }

        public APIRequestGet requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGet requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTwoFacStatusField() {
            return this.requestTwoFacStatusField(true);
        }

        public APIRequestGet requestTwoFacStatusField(boolean value) {
            this.requestField("two_fac_status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

