/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.AndroidAppLink;
import com.facebook.ads.sdk.IosAppLink;
import com.facebook.ads.sdk.WebAppLink;
import com.facebook.ads.sdk.WindowsAppLink;
import com.facebook.ads.sdk.WindowsPhoneAppLink;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppLinks
extends APINode {
    @SerializedName(value="android")
    private List<AndroidAppLink> mAndroid = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ios")
    private List<IosAppLink> mIos = null;
    @SerializedName(value="ipad")
    private List<IosAppLink> mIpad = null;
    @SerializedName(value="iphone")
    private List<IosAppLink> mIphone = null;
    @SerializedName(value="web")
    private WebAppLink mWeb = null;
    @SerializedName(value="windows")
    private List<WindowsAppLink> mWindows = null;
    @SerializedName(value="windows_phone")
    private List<WindowsPhoneAppLink> mWindowsPhone = null;
    @SerializedName(value="windows_universal")
    private List<WindowsAppLink> mWindowsUniversal = null;
    protected static Gson gson = null;

    AppLinks() {
    }

    public AppLinks(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AppLinks(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AppLinks fetch() throws APIException {
        AppLinks newInstance = AppLinks.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AppLinks fetchById(Long id, APIContext context) throws APIException {
        return AppLinks.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AppLinks> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AppLinks.fetchByIdAsync(id.toString(), context);
    }

    public static AppLinks fetchById(String id, APIContext context) throws APIException {
        AppLinks appLinks = new APIRequestGet(id, context).requestAllFields().execute();
        return appLinks;
    }

    public static ListenableFuture<AppLinks> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<AppLinks> appLinks = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return appLinks;
    }

    public static APINodeList<AppLinks> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AppLinks>(context, "", "/", "GET", AppLinks.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AppLinks>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> appLinks = new APIRequest<AppLinks>(context, "", "/", "GET", AppLinks.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return appLinks;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AppLinks loadJSON(String json, APIContext context) {
        AppLinks appLinks = (AppLinks)AppLinks.getGson().fromJson(json, AppLinks.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(appLinks.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        appLinks.context = context;
        appLinks.rawValue = json;
        return appLinks;
    }

    public static APINodeList<AppLinks> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<AppLinks> appLinkss = new APINodeList<AppLinks>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        appLinkss.add(AppLinks.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return appLinkss;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            appLinkss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        appLinkss.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            appLinkss.add(AppLinks.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                appLinkss.add(AppLinks.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            appLinkss.add(AppLinks.loadJSON(obj.toString(), context));
                        }
                    }
                    return appLinkss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        appLinkss.add(AppLinks.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return appLinkss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        appLinkss.add(AppLinks.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return appLinkss;
                }
                appLinkss.clear();
                appLinkss.add(AppLinks.loadJSON(json, context));
                return appLinkss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AppLinks.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<AndroidAppLink> getFieldAndroid() {
        return this.mAndroid;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<IosAppLink> getFieldIos() {
        return this.mIos;
    }

    public List<IosAppLink> getFieldIpad() {
        return this.mIpad;
    }

    public List<IosAppLink> getFieldIphone() {
        return this.mIphone;
    }

    public WebAppLink getFieldWeb() {
        return this.mWeb;
    }

    public List<WindowsAppLink> getFieldWindows() {
        return this.mWindows;
    }

    public List<WindowsPhoneAppLink> getFieldWindowsPhone() {
        return this.mWindowsPhone;
    }

    public List<WindowsAppLink> getFieldWindowsUniversal() {
        return this.mWindowsUniversal;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AppLinks copyFrom(AppLinks instance) {
        this.mAndroid = instance.mAndroid;
        this.mId = instance.mId;
        this.mIos = instance.mIos;
        this.mIpad = instance.mIpad;
        this.mIphone = instance.mIphone;
        this.mWeb = instance.mWeb;
        this.mWindows = instance.mWindows;
        this.mWindowsPhone = instance.mWindowsPhone;
        this.mWindowsUniversal = instance.mWindowsUniversal;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AppLinks> getParser() {
        return new APIRequest.ResponseParser<AppLinks>(){

            @Override
            public APINodeList<AppLinks> parseResponse(String response, APIContext context, APIRequest<AppLinks> request) throws APIException.MalformedResponseException {
                return AppLinks.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AppLinks> {
        AppLinks lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"android", "id", "ios", "ipad", "iphone", "web", "windows", "windows_phone", "windows_universal"};

        @Override
        public AppLinks getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AppLinks parseResponse(String response) throws APIException {
            return AppLinks.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AppLinks execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AppLinks execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AppLinks> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AppLinks> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AppLinks>(){

                public AppLinks apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAndroidField() {
            return this.requestAndroidField(true);
        }

        public APIRequestGet requestAndroidField(boolean value) {
            this.requestField("android", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIosField() {
            return this.requestIosField(true);
        }

        public APIRequestGet requestIosField(boolean value) {
            this.requestField("ios", value);
            return this;
        }

        public APIRequestGet requestIpadField() {
            return this.requestIpadField(true);
        }

        public APIRequestGet requestIpadField(boolean value) {
            this.requestField("ipad", value);
            return this;
        }

        public APIRequestGet requestIphoneField() {
            return this.requestIphoneField(true);
        }

        public APIRequestGet requestIphoneField(boolean value) {
            this.requestField("iphone", value);
            return this;
        }

        public APIRequestGet requestWebField() {
            return this.requestWebField(true);
        }

        public APIRequestGet requestWebField(boolean value) {
            this.requestField("web", value);
            return this;
        }

        public APIRequestGet requestWindowsField() {
            return this.requestWindowsField(true);
        }

        public APIRequestGet requestWindowsField(boolean value) {
            this.requestField("windows", value);
            return this;
        }

        public APIRequestGet requestWindowsPhoneField() {
            return this.requestWindowsPhoneField(true);
        }

        public APIRequestGet requestWindowsPhoneField(boolean value) {
            this.requestField("windows_phone", value);
            return this;
        }

        public APIRequestGet requestWindowsUniversalField() {
            return this.requestWindowsUniversalField(true);
        }

        public APIRequestGet requestWindowsUniversalField(boolean value) {
            this.requestField("windows_universal", value);
            return this;
        }
    }
}

