/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudyCell
extends APINode {
    @SerializedName(value="ad_entities_count")
    private Long mAdEntitiesCount = null;
    @SerializedName(value="control_percentage")
    private Double mControlPercentage = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="treatment_percentage")
    private Double mTreatmentPercentage = null;
    protected static Gson gson = null;

    AdStudyCell() {
    }

    public AdStudyCell(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudyCell(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudyCell fetch() throws APIException {
        AdStudyCell newInstance = AdStudyCell.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudyCell fetchById(Long id, APIContext context) throws APIException {
        return AdStudyCell.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdStudyCell> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdStudyCell.fetchByIdAsync(id.toString(), context);
    }

    public static AdStudyCell fetchById(String id, APIContext context) throws APIException {
        AdStudyCell adStudyCell = new APIRequestGet(id, context).requestAllFields().execute();
        return adStudyCell;
    }

    public static ListenableFuture<AdStudyCell> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<AdStudyCell> adStudyCell = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return adStudyCell;
    }

    public static APINodeList<AdStudyCell> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudyCell>(context, "", "/", "GET", AdStudyCell.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdStudyCell>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> adStudyCell = new APIRequest<AdStudyCell>(context, "", "/", "GET", AdStudyCell.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return adStudyCell;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudyCell loadJSON(String json, APIContext context) {
        AdStudyCell adStudyCell = (AdStudyCell)AdStudyCell.getGson().fromJson(json, AdStudyCell.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudyCell.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudyCell.context = context;
        adStudyCell.rawValue = json;
        return adStudyCell;
    }

    public static APINodeList<AdStudyCell> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<AdStudyCell> adStudyCells = new APINodeList<AdStudyCell>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudyCells.add(AdStudyCell.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adStudyCells;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adStudyCells.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adStudyCells.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudyCells.add(AdStudyCell.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudyCells.add(AdStudyCell.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudyCells.add(AdStudyCell.loadJSON(obj.toString(), context));
                        }
                    }
                    return adStudyCells;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudyCells.add(AdStudyCell.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adStudyCells;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudyCells.add(AdStudyCell.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudyCells;
                }
                adStudyCells.clear();
                adStudyCells.add(AdStudyCell.loadJSON(json, context));
                return adStudyCells;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudyCell.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAdEntitiesCount() {
        return this.mAdEntitiesCount;
    }

    public Double getFieldControlPercentage() {
        return this.mControlPercentage;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Double getFieldTreatmentPercentage() {
        return this.mTreatmentPercentage;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudyCell copyFrom(AdStudyCell instance) {
        this.mAdEntitiesCount = instance.mAdEntitiesCount;
        this.mControlPercentage = instance.mControlPercentage;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mTreatmentPercentage = instance.mTreatmentPercentage;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudyCell> getParser() {
        return new APIRequest.ResponseParser<AdStudyCell>(){

            @Override
            public APINodeList<AdStudyCell> parseResponse(String response, APIContext context, APIRequest<AdStudyCell> request) throws APIException.MalformedResponseException {
                return AdStudyCell.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCreationTemplate {
        VALUE_AUTOMATIC_PLACEMENTS("AUTOMATIC_PLACEMENTS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_FACEBOOK("FACEBOOK"),
        VALUE_FACEBOOK_AUDIENCE_NETWORK("FACEBOOK_AUDIENCE_NETWORK"),
        VALUE_FACEBOOK_INSTAGRAM("FACEBOOK_INSTAGRAM"),
        VALUE_FACEBOOK_NEWS_FEED("FACEBOOK_NEWS_FEED"),
        VALUE_FACEBOOK_NEWS_FEED_IN_STREAM_VIDEO("FACEBOOK_NEWS_FEED_IN_STREAM_VIDEO"),
        VALUE_IN_STREAM_VIDEO("IN_STREAM_VIDEO"),
        VALUE_INSTAGRAM("INSTAGRAM"),
        VALUE_MOBILE_OPTIMIZED_VIDEO("MOBILE_OPTIMIZED_VIDEO"),
        VALUE_PAGE_POST_ENGAGEMENT("PAGE_POST_ENGAGEMENT"),
        VALUE_REACH("REACH"),
        VALUE_TV_COMMERCIAL("TV_COMMERCIAL"),
        VALUE_TV_FACEBOOK("TV_FACEBOOK"),
        VALUE_VIDEO_VIEW_OPTIMIZATION("VIDEO_VIEW_OPTIMIZATION"),
        VALUE_LOW_FREQUENCY("LOW_FREQUENCY"),
        VALUE_MEDIUM_FREQUENCY("MEDIUM_FREQUENCY"),
        VALUE_HIGH_FREQUENCY("HIGH_FREQUENCY"),
        NULL(null);

        private String value;

        private EnumCreationTemplate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdStudyCell> {
        AdStudyCell lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaccounts", "adsets", "campaigns", "creation_template", "description", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyCell getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyCell parseResponse(String response) throws APIException {
            return AdStudyCell.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyCell execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyCell execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyCell> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyCell> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudyCell>(){

                public AdStudyCell apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdaccounts(List<Long> adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestUpdate setAdaccounts(String adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestUpdate setAdsets(List<String> adsets) {
            this.setParam("adsets", adsets);
            return this;
        }

        public APIRequestUpdate setAdsets(String adsets) {
            this.setParam("adsets", adsets);
            return this;
        }

        public APIRequestUpdate setCampaigns(List<String> campaigns) {
            this.setParam("campaigns", campaigns);
            return this;
        }

        public APIRequestUpdate setCampaigns(String campaigns) {
            this.setParam("campaigns", campaigns);
            return this;
        }

        public APIRequestUpdate setCreationTemplate(EnumCreationTemplate creationTemplate) {
            this.setParam("creation_template", (Object)creationTemplate);
            return this;
        }

        public APIRequestUpdate setCreationTemplate(String creationTemplate) {
            this.setParam("creation_template", creationTemplate);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudyCell> {
        AdStudyCell lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_entities_count", "control_percentage", "id", "name", "treatment_percentage"};

        @Override
        public AdStudyCell getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyCell parseResponse(String response) throws APIException {
            return AdStudyCell.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyCell execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyCell execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyCell> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyCell> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudyCell>(){

                public AdStudyCell apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdEntitiesCountField() {
            return this.requestAdEntitiesCountField(true);
        }

        public APIRequestGet requestAdEntitiesCountField(boolean value) {
            this.requestField("ad_entities_count", value);
            return this;
        }

        public APIRequestGet requestControlPercentageField() {
            return this.requestControlPercentageField(true);
        }

        public APIRequestGet requestControlPercentageField(boolean value) {
            this.requestField("control_percentage", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestTreatmentPercentageField() {
            return this.requestTreatmentPercentageField(true);
        }

        public APIRequestGet requestTreatmentPercentageField(boolean value) {
            this.requestField("treatment_percentage", value);
            return this;
        }
    }
}

