/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.AdAsyncRequest;
import com.facebook.ads.sdk.AdAsyncRequestSetNotificationResult;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAsyncRequestSet
extends APINode {
    @SerializedName(value="canceled_count")
    private Long mCanceledCount = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="error_count")
    private Long mErrorCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="in_progress_count")
    private Long mInProgressCount = null;
    @SerializedName(value="initial_count")
    private Long mInitialCount = null;
    @SerializedName(value="is_completed")
    private Boolean mIsCompleted = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="notification_mode")
    private EnumNotificationMode mNotificationMode = null;
    @SerializedName(value="notification_result")
    private AdAsyncRequestSetNotificationResult mNotificationResult = null;
    @SerializedName(value="notification_status")
    private EnumNotificationStatus mNotificationStatus = null;
    @SerializedName(value="notification_uri")
    private String mNotificationUri = null;
    @SerializedName(value="owner_id")
    private String mOwnerId = null;
    @SerializedName(value="success_count")
    private Long mSuccessCount = null;
    @SerializedName(value="total_count")
    private Long mTotalCount = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdAsyncRequestSet() {
    }

    public AdAsyncRequestSet(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAsyncRequestSet(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAsyncRequestSet fetch() throws APIException {
        AdAsyncRequestSet newInstance = AdAsyncRequestSet.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAsyncRequestSet fetchById(Long id, APIContext context) throws APIException {
        return AdAsyncRequestSet.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAsyncRequestSet> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAsyncRequestSet.fetchByIdAsync(id.toString(), context);
    }

    public static AdAsyncRequestSet fetchById(String id, APIContext context) throws APIException {
        AdAsyncRequestSet adAsyncRequestSet = new APIRequestGet(id, context).requestAllFields().execute();
        return adAsyncRequestSet;
    }

    public static ListenableFuture<AdAsyncRequestSet> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<AdAsyncRequestSet> adAsyncRequestSet = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return adAsyncRequestSet;
    }

    public static APINodeList<AdAsyncRequestSet> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAsyncRequestSet>(context, "", "/", "GET", AdAsyncRequestSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAsyncRequestSet>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> adAsyncRequestSet = new APIRequest<AdAsyncRequestSet>(context, "", "/", "GET", AdAsyncRequestSet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return adAsyncRequestSet;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAsyncRequestSet loadJSON(String json, APIContext context) {
        AdAsyncRequestSet adAsyncRequestSet = (AdAsyncRequestSet)AdAsyncRequestSet.getGson().fromJson(json, AdAsyncRequestSet.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAsyncRequestSet.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAsyncRequestSet.context = context;
        adAsyncRequestSet.rawValue = json;
        return adAsyncRequestSet;
    }

    public static APINodeList<AdAsyncRequestSet> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<AdAsyncRequestSet> adAsyncRequestSets = new APINodeList<AdAsyncRequestSet>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAsyncRequestSets;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAsyncRequestSets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAsyncRequestSets.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAsyncRequestSets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAsyncRequestSets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAsyncRequestSets;
                }
                adAsyncRequestSets.clear();
                adAsyncRequestSets.add(AdAsyncRequestSet.loadJSON(json, context));
                return adAsyncRequestSets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAsyncRequestSet.getGson().toJson((Object)this);
    }

    public APIRequestGetRequests getRequests() {
        return new APIRequestGetRequests(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldCanceledCount() {
        return this.mCanceledCount;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Long getFieldErrorCount() {
        return this.mErrorCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldInProgressCount() {
        return this.mInProgressCount;
    }

    public Long getFieldInitialCount() {
        return this.mInitialCount;
    }

    public Boolean getFieldIsCompleted() {
        return this.mIsCompleted;
    }

    public String getFieldName() {
        return this.mName;
    }

    public EnumNotificationMode getFieldNotificationMode() {
        return this.mNotificationMode;
    }

    public AdAsyncRequestSetNotificationResult getFieldNotificationResult() {
        return this.mNotificationResult;
    }

    public EnumNotificationStatus getFieldNotificationStatus() {
        return this.mNotificationStatus;
    }

    public String getFieldNotificationUri() {
        return this.mNotificationUri;
    }

    public String getFieldOwnerId() {
        return this.mOwnerId;
    }

    public Long getFieldSuccessCount() {
        return this.mSuccessCount;
    }

    public Long getFieldTotalCount() {
        return this.mTotalCount;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAsyncRequestSet copyFrom(AdAsyncRequestSet instance) {
        this.mCanceledCount = instance.mCanceledCount;
        this.mCreatedTime = instance.mCreatedTime;
        this.mErrorCount = instance.mErrorCount;
        this.mId = instance.mId;
        this.mInProgressCount = instance.mInProgressCount;
        this.mInitialCount = instance.mInitialCount;
        this.mIsCompleted = instance.mIsCompleted;
        this.mName = instance.mName;
        this.mNotificationMode = instance.mNotificationMode;
        this.mNotificationResult = instance.mNotificationResult;
        this.mNotificationStatus = instance.mNotificationStatus;
        this.mNotificationUri = instance.mNotificationUri;
        this.mOwnerId = instance.mOwnerId;
        this.mSuccessCount = instance.mSuccessCount;
        this.mTotalCount = instance.mTotalCount;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAsyncRequestSet> getParser() {
        return new APIRequest.ResponseParser<AdAsyncRequestSet>(){

            @Override
            public APINodeList<AdAsyncRequestSet> parseResponse(String response, APIContext context, APIRequest<AdAsyncRequestSet> request) throws APIException.MalformedResponseException {
                return AdAsyncRequestSet.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumNotificationStatus {
        VALUE_NOT_SENT("NOT_SENT"),
        VALUE_SENDING("SENDING"),
        VALUE_SENT("SENT"),
        NULL(null);

        private String value;

        private EnumNotificationStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumNotificationMode {
        VALUE_OFF("OFF"),
        VALUE_ON_COMPLETE("ON_COMPLETE"),
        NULL(null);

        private String value;

        private EnumNotificationMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAsyncRequestSet> {
        AdAsyncRequestSet lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"canceled_count", "created_time", "error_count", "id", "in_progress_count", "initial_count", "is_completed", "name", "notification_mode", "notification_result", "notification_status", "notification_uri", "owner_id", "success_count", "total_count", "updated_time"};

        @Override
        public AdAsyncRequestSet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAsyncRequestSet parseResponse(String response) throws APIException {
            return AdAsyncRequestSet.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAsyncRequestSet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAsyncRequestSet execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAsyncRequestSet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAsyncRequestSet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAsyncRequestSet>(){

                public AdAsyncRequestSet apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanceledCountField() {
            return this.requestCanceledCountField(true);
        }

        public APIRequestGet requestCanceledCountField(boolean value) {
            this.requestField("canceled_count", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestErrorCountField() {
            return this.requestErrorCountField(true);
        }

        public APIRequestGet requestErrorCountField(boolean value) {
            this.requestField("error_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInProgressCountField() {
            return this.requestInProgressCountField(true);
        }

        public APIRequestGet requestInProgressCountField(boolean value) {
            this.requestField("in_progress_count", value);
            return this;
        }

        public APIRequestGet requestInitialCountField() {
            return this.requestInitialCountField(true);
        }

        public APIRequestGet requestInitialCountField(boolean value) {
            this.requestField("initial_count", value);
            return this;
        }

        public APIRequestGet requestIsCompletedField() {
            return this.requestIsCompletedField(true);
        }

        public APIRequestGet requestIsCompletedField(boolean value) {
            this.requestField("is_completed", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNotificationModeField() {
            return this.requestNotificationModeField(true);
        }

        public APIRequestGet requestNotificationModeField(boolean value) {
            this.requestField("notification_mode", value);
            return this;
        }

        public APIRequestGet requestNotificationResultField() {
            return this.requestNotificationResultField(true);
        }

        public APIRequestGet requestNotificationResultField(boolean value) {
            this.requestField("notification_result", value);
            return this;
        }

        public APIRequestGet requestNotificationStatusField() {
            return this.requestNotificationStatusField(true);
        }

        public APIRequestGet requestNotificationStatusField(boolean value) {
            this.requestField("notification_status", value);
            return this;
        }

        public APIRequestGet requestNotificationUriField() {
            return this.requestNotificationUriField(true);
        }

        public APIRequestGet requestNotificationUriField(boolean value) {
            this.requestField("notification_uri", value);
            return this;
        }

        public APIRequestGet requestOwnerIdField() {
            return this.requestOwnerIdField(true);
        }

        public APIRequestGet requestOwnerIdField(boolean value) {
            this.requestField("owner_id", value);
            return this;
        }

        public APIRequestGet requestSuccessCountField() {
            return this.requestSuccessCountField(true);
        }

        public APIRequestGet requestSuccessCountField(boolean value) {
            this.requestField("success_count", value);
            return this;
        }

        public APIRequestGet requestTotalCountField() {
            return this.requestTotalCountField(true);
        }

        public APIRequestGet requestTotalCountField(boolean value) {
            this.requestField("total_count", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetRequests
    extends APIRequest<AdAsyncRequest> {
        APINodeList<AdAsyncRequest> lastResponse = null;
        public static final String[] PARAMS = new String[]{"statuses"};
        public static final String[] FIELDS = new String[]{"async_request_set", "created_time", "id", "input", "result", "scope_object_id", "status", "type", "updated_time"};

        @Override
        public APINodeList<AdAsyncRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAsyncRequest> parseResponse(String response) throws APIException {
            return AdAsyncRequest.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAsyncRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAsyncRequest> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAsyncRequest>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAsyncRequest>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAsyncRequest>>(){

                public APINodeList<AdAsyncRequest> apply(String result) {
                    try {
                        return APIRequestGetRequests.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRequests(String nodeId, APIContext context) {
            super(context, nodeId, "/requests", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRequests setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRequests setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRequests setStatuses(List<AdAsyncRequest.EnumStatuses> statuses) {
            this.setParam("statuses", statuses);
            return this;
        }

        public APIRequestGetRequests setStatuses(String statuses) {
            this.setParam("statuses", statuses);
            return this;
        }

        public APIRequestGetRequests requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRequests requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRequests requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRequests requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRequests requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRequests requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetRequests requestAsyncRequestSetField() {
            return this.requestAsyncRequestSetField(true);
        }

        public APIRequestGetRequests requestAsyncRequestSetField(boolean value) {
            this.requestField("async_request_set", value);
            return this;
        }

        public APIRequestGetRequests requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetRequests requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetRequests requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetRequests requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetRequests requestInputField() {
            return this.requestInputField(true);
        }

        public APIRequestGetRequests requestInputField(boolean value) {
            this.requestField("input", value);
            return this;
        }

        public APIRequestGetRequests requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGetRequests requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGetRequests requestScopeObjectIdField() {
            return this.requestScopeObjectIdField(true);
        }

        public APIRequestGetRequests requestScopeObjectIdField(boolean value) {
            this.requestField("scope_object_id", value);
            return this;
        }

        public APIRequestGetRequests requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetRequests requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetRequests requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetRequests requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetRequests requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetRequests requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }
}

