/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleSchedule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdRuleScheduleSpec
extends APINode {
    @SerializedName(value="schedule")
    private List<AdRuleSchedule> mSchedule = null;
    @SerializedName(value="schedule_type")
    private String mScheduleType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRuleScheduleSpec loadJSON(String json, APIContext context, String header) {
        AdRuleScheduleSpec adRuleScheduleSpec = (AdRuleScheduleSpec)AdRuleScheduleSpec.getGson().fromJson(json, AdRuleScheduleSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleScheduleSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleScheduleSpec.context = context;
        adRuleScheduleSpec.rawValue = json;
        adRuleScheduleSpec.header = header;
        return adRuleScheduleSpec;
    }

    public static APINodeList<AdRuleScheduleSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleScheduleSpec> adRuleScheduleSpecs = new APINodeList<AdRuleScheduleSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adRuleScheduleSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleScheduleSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleScheduleSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleScheduleSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adRuleScheduleSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adRuleScheduleSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleScheduleSpecs;
                }
                adRuleScheduleSpecs.clear();
                adRuleScheduleSpecs.add(AdRuleScheduleSpec.loadJSON(json, context, header));
                return adRuleScheduleSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleScheduleSpec.getGson().toJson((Object)this);
    }

    public List<AdRuleSchedule> getFieldSchedule() {
        return this.mSchedule;
    }

    public AdRuleScheduleSpec setFieldSchedule(List<AdRuleSchedule> value) {
        this.mSchedule = value;
        return this;
    }

    public AdRuleScheduleSpec setFieldSchedule(String value) {
        Type type = new TypeToken<List<AdRuleSchedule>>(){}.getType();
        this.mSchedule = (List)AdRuleSchedule.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldScheduleType() {
        return this.mScheduleType;
    }

    public AdRuleScheduleSpec setFieldScheduleType(String value) {
        this.mScheduleType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleScheduleSpec copyFrom(AdRuleScheduleSpec instance) {
        this.mSchedule = instance.mSchedule;
        this.mScheduleType = instance.mScheduleType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleScheduleSpec> getParser() {
        return new APIRequest.ResponseParser<AdRuleScheduleSpec>(){

            @Override
            public APINodeList<AdRuleScheduleSpec> parseResponse(String response, APIContext context, APIRequest<AdRuleScheduleSpec> request, String header) throws APIException.MalformedResponseException {
                return AdRuleScheduleSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

