/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdCustomDerivedMetrics
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private Profile mCreator = null;
    @SerializedName(value="custom_derived_metric_type")
    private String mCustomDerivedMetricType = null;
    @SerializedName(value="deletion_time")
    private String mDeletionTime = null;
    @SerializedName(value="deletor")
    private Profile mDeletor = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="format_type")
    private String mFormatType = null;
    @SerializedName(value="formula")
    private String mFormula = null;
    @SerializedName(value="has_attribution_windows")
    private Boolean mHasAttributionWindows = null;
    @SerializedName(value="has_inline_attribution_window")
    private Boolean mHasInlineAttributionWindow = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="permission")
    private String mPermission = null;
    @SerializedName(value="saved_report_id")
    private String mSavedReportId = null;
    @SerializedName(value="scope")
    private String mScope = null;
    protected static Gson gson = null;

    AdCustomDerivedMetrics() {
    }

    public AdCustomDerivedMetrics(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCustomDerivedMetrics(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCustomDerivedMetrics fetch() throws APIException {
        AdCustomDerivedMetrics newInstance = AdCustomDerivedMetrics.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCustomDerivedMetrics fetchById(Long id, APIContext context) throws APIException {
        return AdCustomDerivedMetrics.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCustomDerivedMetrics> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCustomDerivedMetrics.fetchByIdAsync(id.toString(), context);
    }

    public static AdCustomDerivedMetrics fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCustomDerivedMetrics> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCustomDerivedMetrics> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCustomDerivedMetrics>(context, "", "/", "GET", AdCustomDerivedMetrics.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCustomDerivedMetrics>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCustomDerivedMetrics>(context, "", "/", "GET", AdCustomDerivedMetrics.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCustomDerivedMetrics loadJSON(String json, APIContext context, String header) {
        AdCustomDerivedMetrics adCustomDerivedMetrics = (AdCustomDerivedMetrics)AdCustomDerivedMetrics.getGson().fromJson(json, AdCustomDerivedMetrics.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCustomDerivedMetrics.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCustomDerivedMetrics.context = context;
        adCustomDerivedMetrics.rawValue = json;
        adCustomDerivedMetrics.header = header;
        return adCustomDerivedMetrics;
    }

    public static APINodeList<AdCustomDerivedMetrics> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCustomDerivedMetrics> adCustomDerivedMetricss = new APINodeList<AdCustomDerivedMetrics>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCustomDerivedMetricss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCustomDerivedMetricss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCustomDerivedMetricss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCustomDerivedMetricss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCustomDerivedMetricss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCustomDerivedMetricss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCustomDerivedMetricss;
                }
                adCustomDerivedMetricss.clear();
                adCustomDerivedMetricss.add(AdCustomDerivedMetrics.loadJSON(json, context, header));
                return adCustomDerivedMetricss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCustomDerivedMetrics.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Profile getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldCustomDerivedMetricType() {
        return this.mCustomDerivedMetricType;
    }

    public String getFieldDeletionTime() {
        return this.mDeletionTime;
    }

    public Profile getFieldDeletor() {
        if (this.mDeletor != null) {
            this.mDeletor.context = this.getContext();
        }
        return this.mDeletor;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldFormatType() {
        return this.mFormatType;
    }

    public String getFieldFormula() {
        return this.mFormula;
    }

    public Boolean getFieldHasAttributionWindows() {
        return this.mHasAttributionWindows;
    }

    public Boolean getFieldHasInlineAttributionWindow() {
        return this.mHasInlineAttributionWindow;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPermission() {
        return this.mPermission;
    }

    public String getFieldSavedReportId() {
        return this.mSavedReportId;
    }

    public String getFieldScope() {
        return this.mScope;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCustomDerivedMetrics copyFrom(AdCustomDerivedMetrics instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mBusiness = instance.mBusiness;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mCustomDerivedMetricType = instance.mCustomDerivedMetricType;
        this.mDeletionTime = instance.mDeletionTime;
        this.mDeletor = instance.mDeletor;
        this.mDescription = instance.mDescription;
        this.mFormatType = instance.mFormatType;
        this.mFormula = instance.mFormula;
        this.mHasAttributionWindows = instance.mHasAttributionWindows;
        this.mHasInlineAttributionWindow = instance.mHasInlineAttributionWindow;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPermission = instance.mPermission;
        this.mSavedReportId = instance.mSavedReportId;
        this.mScope = instance.mScope;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCustomDerivedMetrics> getParser() {
        return new APIRequest.ResponseParser<AdCustomDerivedMetrics>(){

            @Override
            public APINodeList<AdCustomDerivedMetrics> parseResponse(String response, APIContext context, APIRequest<AdCustomDerivedMetrics> request, String header) throws APIException.MalformedResponseException {
                return AdCustomDerivedMetrics.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumScope {
        VALUE_ACCOUNT("ACCOUNT"),
        VALUE_BUSINESS("BUSINESS"),
        VALUE_BUSINESS_ASSET_GROUP("BUSINESS_ASSET_GROUP");

        private String value;

        private EnumScope(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdCustomDerivedMetrics> {
        AdCustomDerivedMetrics lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "business", "creation_time", "creator", "custom_derived_metric_type", "deletion_time", "deletor", "description", "format_type", "formula", "has_attribution_windows", "has_inline_attribution_window", "id", "name", "permission", "saved_report_id", "scope"};

        @Override
        public AdCustomDerivedMetrics getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCustomDerivedMetrics parseResponse(String response, String header) throws APIException {
            return AdCustomDerivedMetrics.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdCustomDerivedMetrics execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCustomDerivedMetrics execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdCustomDerivedMetrics> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCustomDerivedMetrics> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdCustomDerivedMetrics>(){

                public AdCustomDerivedMetrics apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestCustomDerivedMetricTypeField() {
            return this.requestCustomDerivedMetricTypeField(true);
        }

        public APIRequestGet requestCustomDerivedMetricTypeField(boolean value) {
            this.requestField("custom_derived_metric_type", value);
            return this;
        }

        public APIRequestGet requestDeletionTimeField() {
            return this.requestDeletionTimeField(true);
        }

        public APIRequestGet requestDeletionTimeField(boolean value) {
            this.requestField("deletion_time", value);
            return this;
        }

        public APIRequestGet requestDeletorField() {
            return this.requestDeletorField(true);
        }

        public APIRequestGet requestDeletorField(boolean value) {
            this.requestField("deletor", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestFormatTypeField() {
            return this.requestFormatTypeField(true);
        }

        public APIRequestGet requestFormatTypeField(boolean value) {
            this.requestField("format_type", value);
            return this;
        }

        public APIRequestGet requestFormulaField() {
            return this.requestFormulaField(true);
        }

        public APIRequestGet requestFormulaField(boolean value) {
            this.requestField("formula", value);
            return this;
        }

        public APIRequestGet requestHasAttributionWindowsField() {
            return this.requestHasAttributionWindowsField(true);
        }

        public APIRequestGet requestHasAttributionWindowsField(boolean value) {
            this.requestField("has_attribution_windows", value);
            return this;
        }

        public APIRequestGet requestHasInlineAttributionWindowField() {
            return this.requestHasInlineAttributionWindowField(true);
        }

        public APIRequestGet requestHasInlineAttributionWindowField(boolean value) {
            this.requestField("has_inline_attribution_window", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPermissionField() {
            return this.requestPermissionField(true);
        }

        public APIRequestGet requestPermissionField(boolean value) {
            this.requestField("permission", value);
            return this;
        }

        public APIRequestGet requestSavedReportIdField() {
            return this.requestSavedReportIdField(true);
        }

        public APIRequestGet requestSavedReportIdField(boolean value) {
            this.requestField("saved_report_id", value);
            return this;
        }

        public APIRequestGet requestScopeField() {
            return this.requestScopeField(true);
        }

        public APIRequestGet requestScopeField(boolean value) {
            this.requestField("scope", value);
            return this;
        }
    }
}

