/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ManagementSiteLink
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="link_domain")
    private String mLinkDomain = null;
    @SerializedName(value="link_hash")
    private String mLinkHash = null;
    @SerializedName(value="link_image_hash")
    private String mLinkImageHash = null;
    @SerializedName(value="link_image_url")
    private String mLinkImageUrl = null;
    @SerializedName(value="link_title")
    private String mLinkTitle = null;
    @SerializedName(value="link_type")
    private String mLinkType = null;
    @SerializedName(value="link_url")
    private String mLinkUrl = null;
    protected static Gson gson = null;

    ManagementSiteLink() {
    }

    public ManagementSiteLink(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ManagementSiteLink(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ManagementSiteLink fetch() throws APIException {
        ManagementSiteLink newInstance = ManagementSiteLink.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ManagementSiteLink fetchById(Long id, APIContext context) throws APIException {
        return ManagementSiteLink.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ManagementSiteLink> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ManagementSiteLink.fetchByIdAsync(id.toString(), context);
    }

    public static ManagementSiteLink fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ManagementSiteLink> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ManagementSiteLink> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ManagementSiteLink>(context, "", "/", "GET", ManagementSiteLink.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ManagementSiteLink>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ManagementSiteLink>(context, "", "/", "GET", ManagementSiteLink.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ManagementSiteLink loadJSON(String json, APIContext context, String header) {
        ManagementSiteLink managementSiteLink = (ManagementSiteLink)ManagementSiteLink.getGson().fromJson(json, ManagementSiteLink.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(managementSiteLink.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        managementSiteLink.context = context;
        managementSiteLink.rawValue = json;
        managementSiteLink.header = header;
        return managementSiteLink;
    }

    public static APINodeList<ManagementSiteLink> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ManagementSiteLink> managementSiteLinks = new APINodeList<ManagementSiteLink>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        managementSiteLinks.add(ManagementSiteLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return managementSiteLinks;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            managementSiteLinks.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        managementSiteLinks.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            managementSiteLinks.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            managementSiteLinks.add(ManagementSiteLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                managementSiteLinks.add(ManagementSiteLink.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            managementSiteLinks.add(ManagementSiteLink.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return managementSiteLinks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        managementSiteLinks.add(ManagementSiteLink.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return managementSiteLinks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        managementSiteLinks.add(ManagementSiteLink.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return managementSiteLinks;
                }
                managementSiteLinks.clear();
                managementSiteLinks.add(ManagementSiteLink.loadJSON(json, context, header));
                return managementSiteLinks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ManagementSiteLink.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLinkDomain() {
        return this.mLinkDomain;
    }

    public String getFieldLinkHash() {
        return this.mLinkHash;
    }

    public String getFieldLinkImageHash() {
        return this.mLinkImageHash;
    }

    public String getFieldLinkImageUrl() {
        return this.mLinkImageUrl;
    }

    public String getFieldLinkTitle() {
        return this.mLinkTitle;
    }

    public String getFieldLinkType() {
        return this.mLinkType;
    }

    public String getFieldLinkUrl() {
        return this.mLinkUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ManagementSiteLink copyFrom(ManagementSiteLink instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mId = instance.mId;
        this.mLinkDomain = instance.mLinkDomain;
        this.mLinkHash = instance.mLinkHash;
        this.mLinkImageHash = instance.mLinkImageHash;
        this.mLinkImageUrl = instance.mLinkImageUrl;
        this.mLinkTitle = instance.mLinkTitle;
        this.mLinkType = instance.mLinkType;
        this.mLinkUrl = instance.mLinkUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ManagementSiteLink> getParser() {
        return new APIRequest.ResponseParser<ManagementSiteLink>(){

            @Override
            public APINodeList<ManagementSiteLink> parseResponse(String response, APIContext context, APIRequest<ManagementSiteLink> request, String header) throws APIException.MalformedResponseException {
                return ManagementSiteLink.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ManagementSiteLink> {
        ManagementSiteLink lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "id", "link_domain", "link_hash", "link_image_hash", "link_image_url", "link_title", "link_type", "link_url"};

        @Override
        public ManagementSiteLink getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ManagementSiteLink parseResponse(String response, String header) throws APIException {
            return ManagementSiteLink.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ManagementSiteLink execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ManagementSiteLink execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ManagementSiteLink> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ManagementSiteLink> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ManagementSiteLink>(){

                public ManagementSiteLink apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLinkDomainField() {
            return this.requestLinkDomainField(true);
        }

        public APIRequestGet requestLinkDomainField(boolean value) {
            this.requestField("link_domain", value);
            return this;
        }

        public APIRequestGet requestLinkHashField() {
            return this.requestLinkHashField(true);
        }

        public APIRequestGet requestLinkHashField(boolean value) {
            this.requestField("link_hash", value);
            return this;
        }

        public APIRequestGet requestLinkImageHashField() {
            return this.requestLinkImageHashField(true);
        }

        public APIRequestGet requestLinkImageHashField(boolean value) {
            this.requestField("link_image_hash", value);
            return this;
        }

        public APIRequestGet requestLinkImageUrlField() {
            return this.requestLinkImageUrlField(true);
        }

        public APIRequestGet requestLinkImageUrlField(boolean value) {
            this.requestField("link_image_url", value);
            return this;
        }

        public APIRequestGet requestLinkTitleField() {
            return this.requestLinkTitleField(true);
        }

        public APIRequestGet requestLinkTitleField(boolean value) {
            this.requestField("link_title", value);
            return this;
        }

        public APIRequestGet requestLinkTypeField() {
            return this.requestLinkTypeField(true);
        }

        public APIRequestGet requestLinkTypeField(boolean value) {
            this.requestField("link_type", value);
            return this;
        }

        public APIRequestGet requestLinkUrlField() {
            return this.requestLinkUrlField(true);
        }

        public APIRequestGet requestLinkUrlField(boolean value) {
            this.requestField("link_url", value);
            return this;
        }
    }
}

