/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AnalyticsPlatformMetricsConfig
extends APINode {
    @SerializedName(value="has_a2u")
    private Boolean mHasA2u = null;
    @SerializedName(value="has_api_calls")
    private Boolean mHasApiCalls = null;
    @SerializedName(value="has_app_invites")
    private Boolean mHasAppInvites = null;
    @SerializedName(value="has_fb_login")
    private Boolean mHasFbLogin = null;
    @SerializedName(value="has_game_requests")
    private Boolean mHasGameRequests = null;
    @SerializedName(value="has_payments")
    private Boolean mHasPayments = null;
    @SerializedName(value="has_referrals")
    private Boolean mHasReferrals = null;
    @SerializedName(value="has_stories")
    private Boolean mHasStories = null;
    @SerializedName(value="has_structured_requests")
    private Boolean mHasStructuredRequests = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AnalyticsPlatformMetricsConfig loadJSON(String json, APIContext context, String header) {
        AnalyticsPlatformMetricsConfig analyticsPlatformMetricsConfig = (AnalyticsPlatformMetricsConfig)AnalyticsPlatformMetricsConfig.getGson().fromJson(json, AnalyticsPlatformMetricsConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsPlatformMetricsConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsPlatformMetricsConfig.context = context;
        analyticsPlatformMetricsConfig.rawValue = json;
        analyticsPlatformMetricsConfig.header = header;
        return analyticsPlatformMetricsConfig;
    }

    public static APINodeList<AnalyticsPlatformMetricsConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsPlatformMetricsConfig> analyticsPlatformMetricsConfigs = new APINodeList<AnalyticsPlatformMetricsConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return analyticsPlatformMetricsConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsPlatformMetricsConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsPlatformMetricsConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsPlatformMetricsConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return analyticsPlatformMetricsConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return analyticsPlatformMetricsConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsPlatformMetricsConfigs;
                }
                analyticsPlatformMetricsConfigs.clear();
                analyticsPlatformMetricsConfigs.add(AnalyticsPlatformMetricsConfig.loadJSON(json, context, header));
                return analyticsPlatformMetricsConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsPlatformMetricsConfig.getGson().toJson((Object)this);
    }

    public Boolean getFieldHasA2u() {
        return this.mHasA2u;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasA2u(Boolean value) {
        this.mHasA2u = value;
        return this;
    }

    public Boolean getFieldHasApiCalls() {
        return this.mHasApiCalls;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasApiCalls(Boolean value) {
        this.mHasApiCalls = value;
        return this;
    }

    public Boolean getFieldHasAppInvites() {
        return this.mHasAppInvites;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasAppInvites(Boolean value) {
        this.mHasAppInvites = value;
        return this;
    }

    public Boolean getFieldHasFbLogin() {
        return this.mHasFbLogin;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasFbLogin(Boolean value) {
        this.mHasFbLogin = value;
        return this;
    }

    public Boolean getFieldHasGameRequests() {
        return this.mHasGameRequests;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasGameRequests(Boolean value) {
        this.mHasGameRequests = value;
        return this;
    }

    public Boolean getFieldHasPayments() {
        return this.mHasPayments;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasPayments(Boolean value) {
        this.mHasPayments = value;
        return this;
    }

    public Boolean getFieldHasReferrals() {
        return this.mHasReferrals;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasReferrals(Boolean value) {
        this.mHasReferrals = value;
        return this;
    }

    public Boolean getFieldHasStories() {
        return this.mHasStories;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasStories(Boolean value) {
        this.mHasStories = value;
        return this;
    }

    public Boolean getFieldHasStructuredRequests() {
        return this.mHasStructuredRequests;
    }

    public AnalyticsPlatformMetricsConfig setFieldHasStructuredRequests(Boolean value) {
        this.mHasStructuredRequests = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsPlatformMetricsConfig copyFrom(AnalyticsPlatformMetricsConfig instance) {
        this.mHasA2u = instance.mHasA2u;
        this.mHasApiCalls = instance.mHasApiCalls;
        this.mHasAppInvites = instance.mHasAppInvites;
        this.mHasFbLogin = instance.mHasFbLogin;
        this.mHasGameRequests = instance.mHasGameRequests;
        this.mHasPayments = instance.mHasPayments;
        this.mHasReferrals = instance.mHasReferrals;
        this.mHasStories = instance.mHasStories;
        this.mHasStructuredRequests = instance.mHasStructuredRequests;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsPlatformMetricsConfig> getParser() {
        return new APIRequest.ResponseParser<AnalyticsPlatformMetricsConfig>(){

            @Override
            public APINodeList<AnalyticsPlatformMetricsConfig> parseResponse(String response, APIContext context, APIRequest<AnalyticsPlatformMetricsConfig> request, String header) throws APIException.MalformedResponseException {
                return AnalyticsPlatformMetricsConfig.parseResponse(response, context, request, header);
            }
        };
    }
}

