/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WearableDevicePublicKey
extends APINode {
    @SerializedName(value="base64_encoded_public_key")
    private String mBase64EncodedPublicKey = null;
    @SerializedName(value="creation_time_on_device")
    private String mCreationTimeOnDevice = null;
    @SerializedName(value="device_uuid")
    private String mDeviceUuid = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="key_type")
    private String mKeyType = null;
    @SerializedName(value="owner_id")
    private String mOwnerId = null;
    @SerializedName(value="product_use_case")
    private String mProductUseCase = null;
    @SerializedName(value="version")
    private String mVersion = null;
    protected static Gson gson = null;

    WearableDevicePublicKey() {
    }

    public WearableDevicePublicKey(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WearableDevicePublicKey(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WearableDevicePublicKey fetch() throws APIException {
        WearableDevicePublicKey newInstance = WearableDevicePublicKey.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WearableDevicePublicKey fetchById(Long id, APIContext context) throws APIException {
        return WearableDevicePublicKey.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WearableDevicePublicKey> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WearableDevicePublicKey.fetchByIdAsync(id.toString(), context);
    }

    public static WearableDevicePublicKey fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WearableDevicePublicKey> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WearableDevicePublicKey> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WearableDevicePublicKey>(context, "", "/", "GET", WearableDevicePublicKey.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WearableDevicePublicKey>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WearableDevicePublicKey>(context, "", "/", "GET", WearableDevicePublicKey.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WearableDevicePublicKey loadJSON(String json, APIContext context, String header) {
        WearableDevicePublicKey wearableDevicePublicKey = (WearableDevicePublicKey)WearableDevicePublicKey.getGson().fromJson(json, WearableDevicePublicKey.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(wearableDevicePublicKey.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        wearableDevicePublicKey.context = context;
        wearableDevicePublicKey.rawValue = json;
        wearableDevicePublicKey.header = header;
        return wearableDevicePublicKey;
    }

    public static APINodeList<WearableDevicePublicKey> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WearableDevicePublicKey> wearableDevicePublicKeys = new APINodeList<WearableDevicePublicKey>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return wearableDevicePublicKeys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            wearableDevicePublicKeys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        wearableDevicePublicKeys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            wearableDevicePublicKeys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return wearableDevicePublicKeys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return wearableDevicePublicKeys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return wearableDevicePublicKeys;
                }
                wearableDevicePublicKeys.clear();
                wearableDevicePublicKeys.add(WearableDevicePublicKey.loadJSON(json, context, header));
                return wearableDevicePublicKeys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WearableDevicePublicKey.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBase64EncodedPublicKey() {
        return this.mBase64EncodedPublicKey;
    }

    public String getFieldCreationTimeOnDevice() {
        return this.mCreationTimeOnDevice;
    }

    public String getFieldDeviceUuid() {
        return this.mDeviceUuid;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldKeyType() {
        return this.mKeyType;
    }

    public String getFieldOwnerId() {
        return this.mOwnerId;
    }

    public String getFieldProductUseCase() {
        return this.mProductUseCase;
    }

    public String getFieldVersion() {
        return this.mVersion;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WearableDevicePublicKey copyFrom(WearableDevicePublicKey instance) {
        this.mBase64EncodedPublicKey = instance.mBase64EncodedPublicKey;
        this.mCreationTimeOnDevice = instance.mCreationTimeOnDevice;
        this.mDeviceUuid = instance.mDeviceUuid;
        this.mId = instance.mId;
        this.mKeyType = instance.mKeyType;
        this.mOwnerId = instance.mOwnerId;
        this.mProductUseCase = instance.mProductUseCase;
        this.mVersion = instance.mVersion;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WearableDevicePublicKey> getParser() {
        return new APIRequest.ResponseParser<WearableDevicePublicKey>(){

            @Override
            public APINodeList<WearableDevicePublicKey> parseResponse(String response, APIContext context, APIRequest<WearableDevicePublicKey> request, String header) throws APIException.MalformedResponseException {
                return WearableDevicePublicKey.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<WearableDevicePublicKey> {
        WearableDevicePublicKey lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"base64_encoded_public_key", "creation_time_on_device", "device_uuid", "id", "key_type", "owner_id", "product_use_case", "version"};

        @Override
        public WearableDevicePublicKey getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WearableDevicePublicKey parseResponse(String response, String header) throws APIException {
            return WearableDevicePublicKey.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WearableDevicePublicKey execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WearableDevicePublicKey execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WearableDevicePublicKey> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WearableDevicePublicKey> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WearableDevicePublicKey>(){

                public WearableDevicePublicKey apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBase64EncodedPublicKeyField() {
            return this.requestBase64EncodedPublicKeyField(true);
        }

        public APIRequestGet requestBase64EncodedPublicKeyField(boolean value) {
            this.requestField("base64_encoded_public_key", value);
            return this;
        }

        public APIRequestGet requestCreationTimeOnDeviceField() {
            return this.requestCreationTimeOnDeviceField(true);
        }

        public APIRequestGet requestCreationTimeOnDeviceField(boolean value) {
            this.requestField("creation_time_on_device", value);
            return this;
        }

        public APIRequestGet requestDeviceUuidField() {
            return this.requestDeviceUuidField(true);
        }

        public APIRequestGet requestDeviceUuidField(boolean value) {
            this.requestField("device_uuid", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestKeyTypeField() {
            return this.requestKeyTypeField(true);
        }

        public APIRequestGet requestKeyTypeField(boolean value) {
            this.requestField("key_type", value);
            return this;
        }

        public APIRequestGet requestOwnerIdField() {
            return this.requestOwnerIdField(true);
        }

        public APIRequestGet requestOwnerIdField(boolean value) {
            this.requestField("owner_id", value);
            return this;
        }

        public APIRequestGet requestProductUseCaseField() {
            return this.requestProductUseCaseField(true);
        }

        public APIRequestGet requestProductUseCaseField(boolean value) {
            this.requestField("product_use_case", value);
            return this;
        }

        public APIRequestGet requestVersionField() {
            return this.requestVersionField(true);
        }

        public APIRequestGet requestVersionField(boolean value) {
            this.requestField("version", value);
            return this;
        }
    }
}

