/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdProposal
extends APINode {
    @SerializedName(value="ad_proposal_type_name")
    private String mAdProposalTypeName = null;
    @SerializedName(value="adaccount")
    private AdAccount mAdaccount = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="delivery_interface")
    private String mDeliveryInterface = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="has_conflict")
    private Boolean mHasConflict = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="kpi_metric")
    private String mKpiMetric = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="proposal_dts_template")
    private String mProposalDtsTemplate = null;
    @SerializedName(value="proposal_template_name")
    private String mProposalTemplateName = null;
    @SerializedName(value="recommendation")
    private String mRecommendation = null;
    @SerializedName(value="review_time")
    private String mReviewTime = null;
    @SerializedName(value="reviewed_by")
    private User mReviewedBy = null;
    @SerializedName(value="send_time")
    private String mSendTime = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="use_testing")
    private Boolean mUseTesting = null;
    protected static Gson gson = null;

    AdProposal() {
    }

    public AdProposal(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdProposal(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdProposal fetch() throws APIException {
        AdProposal newInstance = AdProposal.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdProposal fetchById(Long id, APIContext context) throws APIException {
        return AdProposal.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdProposal> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdProposal.fetchByIdAsync(id.toString(), context);
    }

    public static AdProposal fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdProposal> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdProposal> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdProposal>(context, "", "/", "GET", AdProposal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdProposal>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdProposal>(context, "", "/", "GET", AdProposal.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdProposal loadJSON(String json, APIContext context, String header) {
        AdProposal adProposal = (AdProposal)AdProposal.getGson().fromJson(json, AdProposal.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adProposal.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adProposal.context = context;
        adProposal.rawValue = json;
        adProposal.header = header;
        return adProposal;
    }

    public static APINodeList<AdProposal> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdProposal> adProposals = new APINodeList<AdProposal>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adProposals.add(AdProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adProposals;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adProposals.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adProposals.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adProposals.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adProposals.add(AdProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adProposals.add(AdProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adProposals.add(AdProposal.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adProposals;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adProposals.add(AdProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adProposals;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adProposals.add(AdProposal.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adProposals;
                }
                adProposals.clear();
                adProposals.add(AdProposal.loadJSON(json, context, header));
                return adProposals;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdProposal.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdProposalTypeName() {
        return this.mAdProposalTypeName;
    }

    public AdAccount getFieldAdaccount() {
        if (this.mAdaccount != null) {
            this.mAdaccount.context = this.getContext();
        }
        return this.mAdaccount;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldDeliveryInterface() {
        return this.mDeliveryInterface;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public Boolean getFieldHasConflict() {
        return this.mHasConflict;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldKpiMetric() {
        return this.mKpiMetric;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldProposalDtsTemplate() {
        return this.mProposalDtsTemplate;
    }

    public String getFieldProposalTemplateName() {
        return this.mProposalTemplateName;
    }

    public String getFieldRecommendation() {
        return this.mRecommendation;
    }

    public String getFieldReviewTime() {
        return this.mReviewTime;
    }

    public User getFieldReviewedBy() {
        if (this.mReviewedBy != null) {
            this.mReviewedBy.context = this.getContext();
        }
        return this.mReviewedBy;
    }

    public String getFieldSendTime() {
        return this.mSendTime;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Boolean getFieldUseTesting() {
        return this.mUseTesting;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdProposal copyFrom(AdProposal instance) {
        this.mAdProposalTypeName = instance.mAdProposalTypeName;
        this.mAdaccount = instance.mAdaccount;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mDeliveryInterface = instance.mDeliveryInterface;
        this.mExpirationTime = instance.mExpirationTime;
        this.mHasConflict = instance.mHasConflict;
        this.mId = instance.mId;
        this.mKpiMetric = instance.mKpiMetric;
        this.mMessage = instance.mMessage;
        this.mName = instance.mName;
        this.mProposalDtsTemplate = instance.mProposalDtsTemplate;
        this.mProposalTemplateName = instance.mProposalTemplateName;
        this.mRecommendation = instance.mRecommendation;
        this.mReviewTime = instance.mReviewTime;
        this.mReviewedBy = instance.mReviewedBy;
        this.mSendTime = instance.mSendTime;
        this.mStatus = instance.mStatus;
        this.mUseTesting = instance.mUseTesting;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdProposal> getParser() {
        return new APIRequest.ResponseParser<AdProposal>(){

            @Override
            public APINodeList<AdProposal> parseResponse(String response, APIContext context, APIRequest<AdProposal> request, String header) throws APIException.MalformedResponseException {
                return AdProposal.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdProposal> {
        AdProposal lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_proposal_type_name", "adaccount", "creation_time", "creator", "delivery_interface", "expiration_time", "has_conflict", "id", "kpi_metric", "message", "name", "proposal_dts_template", "proposal_template_name", "recommendation", "review_time", "reviewed_by", "send_time", "status", "use_testing"};

        @Override
        public AdProposal getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdProposal parseResponse(String response, String header) throws APIException {
            return AdProposal.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdProposal execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdProposal execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdProposal> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdProposal> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdProposal>(){

                public AdProposal apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdProposalTypeNameField() {
            return this.requestAdProposalTypeNameField(true);
        }

        public APIRequestGet requestAdProposalTypeNameField(boolean value) {
            this.requestField("ad_proposal_type_name", value);
            return this;
        }

        public APIRequestGet requestAdaccountField() {
            return this.requestAdaccountField(true);
        }

        public APIRequestGet requestAdaccountField(boolean value) {
            this.requestField("adaccount", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestDeliveryInterfaceField() {
            return this.requestDeliveryInterfaceField(true);
        }

        public APIRequestGet requestDeliveryInterfaceField(boolean value) {
            this.requestField("delivery_interface", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestHasConflictField() {
            return this.requestHasConflictField(true);
        }

        public APIRequestGet requestHasConflictField(boolean value) {
            this.requestField("has_conflict", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestKpiMetricField() {
            return this.requestKpiMetricField(true);
        }

        public APIRequestGet requestKpiMetricField(boolean value) {
            this.requestField("kpi_metric", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestProposalDtsTemplateField() {
            return this.requestProposalDtsTemplateField(true);
        }

        public APIRequestGet requestProposalDtsTemplateField(boolean value) {
            this.requestField("proposal_dts_template", value);
            return this;
        }

        public APIRequestGet requestProposalTemplateNameField() {
            return this.requestProposalTemplateNameField(true);
        }

        public APIRequestGet requestProposalTemplateNameField(boolean value) {
            this.requestField("proposal_template_name", value);
            return this;
        }

        public APIRequestGet requestRecommendationField() {
            return this.requestRecommendationField(true);
        }

        public APIRequestGet requestRecommendationField(boolean value) {
            this.requestField("recommendation", value);
            return this;
        }

        public APIRequestGet requestReviewTimeField() {
            return this.requestReviewTimeField(true);
        }

        public APIRequestGet requestReviewTimeField(boolean value) {
            this.requestField("review_time", value);
            return this;
        }

        public APIRequestGet requestReviewedByField() {
            return this.requestReviewedByField(true);
        }

        public APIRequestGet requestReviewedByField(boolean value) {
            this.requestField("reviewed_by", value);
            return this;
        }

        public APIRequestGet requestSendTimeField() {
            return this.requestSendTimeField(true);
        }

        public APIRequestGet requestSendTimeField(boolean value) {
            this.requestField("send_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUseTestingField() {
            return this.requestUseTestingField(true);
        }

        public APIRequestGet requestUseTestingField(boolean value) {
            this.requestField("use_testing", value);
            return this;
        }
    }
}

