/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class AdCreativeMediaSourcingSpec
extends APINode {
    @SerializedName(value="bodies")
    private List<Object> mBodies = null;
    @SerializedName(value="descriptions")
    private List<Object> mDescriptions = null;
    @SerializedName(value="images")
    private List<Object> mImages = null;
    @SerializedName(value="related_media")
    private Object mRelatedMedia = null;
    @SerializedName(value="titles")
    private List<Object> mTitles = null;
    @SerializedName(value="videos")
    private List<Object> mVideos = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeMediaSourcingSpec loadJSON(String json, APIContext context, String header) {
        AdCreativeMediaSourcingSpec adCreativeMediaSourcingSpec = (AdCreativeMediaSourcingSpec)AdCreativeMediaSourcingSpec.getGson().fromJson(json, AdCreativeMediaSourcingSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeMediaSourcingSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeMediaSourcingSpec.context = context;
        adCreativeMediaSourcingSpec.rawValue = json;
        adCreativeMediaSourcingSpec.header = header;
        return adCreativeMediaSourcingSpec;
    }

    public static APINodeList<AdCreativeMediaSourcingSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeMediaSourcingSpec> adCreativeMediaSourcingSpecs = new APINodeList<AdCreativeMediaSourcingSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeMediaSourcingSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeMediaSourcingSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeMediaSourcingSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeMediaSourcingSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeMediaSourcingSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeMediaSourcingSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeMediaSourcingSpecs;
                }
                adCreativeMediaSourcingSpecs.clear();
                adCreativeMediaSourcingSpecs.add(AdCreativeMediaSourcingSpec.loadJSON(json, context, header));
                return adCreativeMediaSourcingSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeMediaSourcingSpec.getGson().toJson((Object)this);
    }

    public List<Object> getFieldBodies() {
        return this.mBodies;
    }

    public AdCreativeMediaSourcingSpec setFieldBodies(List<Object> value) {
        this.mBodies = value;
        return this;
    }

    public List<Object> getFieldDescriptions() {
        return this.mDescriptions;
    }

    public AdCreativeMediaSourcingSpec setFieldDescriptions(List<Object> value) {
        this.mDescriptions = value;
        return this;
    }

    public List<Object> getFieldImages() {
        return this.mImages;
    }

    public AdCreativeMediaSourcingSpec setFieldImages(List<Object> value) {
        this.mImages = value;
        return this;
    }

    public Object getFieldRelatedMedia() {
        return this.mRelatedMedia;
    }

    public AdCreativeMediaSourcingSpec setFieldRelatedMedia(Object value) {
        this.mRelatedMedia = value;
        return this;
    }

    public List<Object> getFieldTitles() {
        return this.mTitles;
    }

    public AdCreativeMediaSourcingSpec setFieldTitles(List<Object> value) {
        this.mTitles = value;
        return this;
    }

    public List<Object> getFieldVideos() {
        return this.mVideos;
    }

    public AdCreativeMediaSourcingSpec setFieldVideos(List<Object> value) {
        this.mVideos = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeMediaSourcingSpec copyFrom(AdCreativeMediaSourcingSpec instance) {
        this.mBodies = instance.mBodies;
        this.mDescriptions = instance.mDescriptions;
        this.mImages = instance.mImages;
        this.mRelatedMedia = instance.mRelatedMedia;
        this.mTitles = instance.mTitles;
        this.mVideos = instance.mVideos;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeMediaSourcingSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeMediaSourcingSpec>(){

            @Override
            public APINodeList<AdCreativeMediaSourcingSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeMediaSourcingSpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeMediaSourcingSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

