/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TargetingGeoLocation;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdAssetTargetRuleTargeting
extends APINode {
    @SerializedName(value="age_max")
    private Long mAgeMax = null;
    @SerializedName(value="age_min")
    private Long mAgeMin = null;
    @SerializedName(value="audience_network_positions")
    private List<String> mAudienceNetworkPositions = null;
    @SerializedName(value="device_platforms")
    private List<EnumDevicePlatforms> mDevicePlatforms = null;
    @SerializedName(value="facebook_positions")
    private List<String> mFacebookPositions = null;
    @SerializedName(value="geo_locations")
    private TargetingGeoLocation mGeoLocations = null;
    @SerializedName(value="instagram_positions")
    private List<String> mInstagramPositions = null;
    @SerializedName(value="publisher_platforms")
    private List<String> mPublisherPlatforms = null;
    @SerializedName(value="threads_positions")
    private List<String> mThreadsPositions = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdAssetTargetRuleTargeting loadJSON(String json, APIContext context, String header) {
        AdAssetTargetRuleTargeting adAssetTargetRuleTargeting = (AdAssetTargetRuleTargeting)AdAssetTargetRuleTargeting.getGson().fromJson(json, AdAssetTargetRuleTargeting.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetTargetRuleTargeting.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetTargetRuleTargeting.context = context;
        adAssetTargetRuleTargeting.rawValue = json;
        adAssetTargetRuleTargeting.header = header;
        return adAssetTargetRuleTargeting;
    }

    public static APINodeList<AdAssetTargetRuleTargeting> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetTargetRuleTargeting> adAssetTargetRuleTargetings = new APINodeList<AdAssetTargetRuleTargeting>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAssetTargetRuleTargetings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetTargetRuleTargetings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetTargetRuleTargetings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetTargetRuleTargetings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAssetTargetRuleTargetings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAssetTargetRuleTargetings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetTargetRuleTargetings;
                }
                adAssetTargetRuleTargetings.clear();
                adAssetTargetRuleTargetings.add(AdAssetTargetRuleTargeting.loadJSON(json, context, header));
                return adAssetTargetRuleTargetings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetTargetRuleTargeting.getGson().toJson((Object)this);
    }

    public Long getFieldAgeMax() {
        return this.mAgeMax;
    }

    public AdAssetTargetRuleTargeting setFieldAgeMax(Long value) {
        this.mAgeMax = value;
        return this;
    }

    public Long getFieldAgeMin() {
        return this.mAgeMin;
    }

    public AdAssetTargetRuleTargeting setFieldAgeMin(Long value) {
        this.mAgeMin = value;
        return this;
    }

    public List<String> getFieldAudienceNetworkPositions() {
        return this.mAudienceNetworkPositions;
    }

    public AdAssetTargetRuleTargeting setFieldAudienceNetworkPositions(List<String> value) {
        this.mAudienceNetworkPositions = value;
        return this;
    }

    public List<EnumDevicePlatforms> getFieldDevicePlatforms() {
        return this.mDevicePlatforms;
    }

    public AdAssetTargetRuleTargeting setFieldDevicePlatforms(List<EnumDevicePlatforms> value) {
        this.mDevicePlatforms = value;
        return this;
    }

    public List<String> getFieldFacebookPositions() {
        return this.mFacebookPositions;
    }

    public AdAssetTargetRuleTargeting setFieldFacebookPositions(List<String> value) {
        this.mFacebookPositions = value;
        return this;
    }

    public TargetingGeoLocation getFieldGeoLocations() {
        return this.mGeoLocations;
    }

    public AdAssetTargetRuleTargeting setFieldGeoLocations(TargetingGeoLocation value) {
        this.mGeoLocations = value;
        return this;
    }

    public AdAssetTargetRuleTargeting setFieldGeoLocations(String value) {
        Type type = new TypeToken<TargetingGeoLocation>(){}.getType();
        this.mGeoLocations = (TargetingGeoLocation)TargetingGeoLocation.getGson().fromJson(value, type);
        return this;
    }

    public List<String> getFieldInstagramPositions() {
        return this.mInstagramPositions;
    }

    public AdAssetTargetRuleTargeting setFieldInstagramPositions(List<String> value) {
        this.mInstagramPositions = value;
        return this;
    }

    public List<String> getFieldPublisherPlatforms() {
        return this.mPublisherPlatforms;
    }

    public AdAssetTargetRuleTargeting setFieldPublisherPlatforms(List<String> value) {
        this.mPublisherPlatforms = value;
        return this;
    }

    public List<String> getFieldThreadsPositions() {
        return this.mThreadsPositions;
    }

    public AdAssetTargetRuleTargeting setFieldThreadsPositions(List<String> value) {
        this.mThreadsPositions = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetTargetRuleTargeting copyFrom(AdAssetTargetRuleTargeting instance) {
        this.mAgeMax = instance.mAgeMax;
        this.mAgeMin = instance.mAgeMin;
        this.mAudienceNetworkPositions = instance.mAudienceNetworkPositions;
        this.mDevicePlatforms = instance.mDevicePlatforms;
        this.mFacebookPositions = instance.mFacebookPositions;
        this.mGeoLocations = instance.mGeoLocations;
        this.mInstagramPositions = instance.mInstagramPositions;
        this.mPublisherPlatforms = instance.mPublisherPlatforms;
        this.mThreadsPositions = instance.mThreadsPositions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetTargetRuleTargeting> getParser() {
        return new APIRequest.ResponseParser<AdAssetTargetRuleTargeting>(){

            @Override
            public APINodeList<AdAssetTargetRuleTargeting> parseResponse(String response, APIContext context, APIRequest<AdAssetTargetRuleTargeting> request, String header) throws APIException.MalformedResponseException {
                return AdAssetTargetRuleTargeting.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumDevicePlatforms {
        VALUE_DESKTOP("desktop"),
        VALUE_MOBILE("mobile");

        private String value;

        private EnumDevicePlatforms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

