/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class BrandedContentAdError
extends APINode {
    @SerializedName(value="blame_field_spec")
    private List<String> mBlameFieldSpec = null;
    @SerializedName(value="error_code")
    private Long mErrorCode = null;
    @SerializedName(value="error_description")
    private String mErrorDescription = null;
    @SerializedName(value="error_message")
    private String mErrorMessage = null;
    @SerializedName(value="error_placement")
    private String mErrorPlacement = null;
    @SerializedName(value="error_severity")
    private String mErrorSeverity = null;
    @SerializedName(value="help_center_id")
    private Long mHelpCenterId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BrandedContentAdError loadJSON(String json, APIContext context, String header) {
        BrandedContentAdError brandedContentAdError = (BrandedContentAdError)BrandedContentAdError.getGson().fromJson(json, BrandedContentAdError.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(brandedContentAdError.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        brandedContentAdError.context = context;
        brandedContentAdError.rawValue = json;
        brandedContentAdError.header = header;
        return brandedContentAdError;
    }

    public static APINodeList<BrandedContentAdError> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BrandedContentAdError> brandedContentAdErrors = new APINodeList<BrandedContentAdError>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        brandedContentAdErrors.add(BrandedContentAdError.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return brandedContentAdErrors;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            brandedContentAdErrors.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        brandedContentAdErrors.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            brandedContentAdErrors.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            brandedContentAdErrors.add(BrandedContentAdError.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                brandedContentAdErrors.add(BrandedContentAdError.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            brandedContentAdErrors.add(BrandedContentAdError.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return brandedContentAdErrors;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        brandedContentAdErrors.add(BrandedContentAdError.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return brandedContentAdErrors;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        brandedContentAdErrors.add(BrandedContentAdError.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return brandedContentAdErrors;
                }
                brandedContentAdErrors.clear();
                brandedContentAdErrors.add(BrandedContentAdError.loadJSON(json, context, header));
                return brandedContentAdErrors;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BrandedContentAdError.getGson().toJson((Object)this);
    }

    public List<String> getFieldBlameFieldSpec() {
        return this.mBlameFieldSpec;
    }

    public BrandedContentAdError setFieldBlameFieldSpec(List<String> value) {
        this.mBlameFieldSpec = value;
        return this;
    }

    public Long getFieldErrorCode() {
        return this.mErrorCode;
    }

    public BrandedContentAdError setFieldErrorCode(Long value) {
        this.mErrorCode = value;
        return this;
    }

    public String getFieldErrorDescription() {
        return this.mErrorDescription;
    }

    public BrandedContentAdError setFieldErrorDescription(String value) {
        this.mErrorDescription = value;
        return this;
    }

    public String getFieldErrorMessage() {
        return this.mErrorMessage;
    }

    public BrandedContentAdError setFieldErrorMessage(String value) {
        this.mErrorMessage = value;
        return this;
    }

    public String getFieldErrorPlacement() {
        return this.mErrorPlacement;
    }

    public BrandedContentAdError setFieldErrorPlacement(String value) {
        this.mErrorPlacement = value;
        return this;
    }

    public String getFieldErrorSeverity() {
        return this.mErrorSeverity;
    }

    public BrandedContentAdError setFieldErrorSeverity(String value) {
        this.mErrorSeverity = value;
        return this;
    }

    public Long getFieldHelpCenterId() {
        return this.mHelpCenterId;
    }

    public BrandedContentAdError setFieldHelpCenterId(Long value) {
        this.mHelpCenterId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BrandedContentAdError copyFrom(BrandedContentAdError instance) {
        this.mBlameFieldSpec = instance.mBlameFieldSpec;
        this.mErrorCode = instance.mErrorCode;
        this.mErrorDescription = instance.mErrorDescription;
        this.mErrorMessage = instance.mErrorMessage;
        this.mErrorPlacement = instance.mErrorPlacement;
        this.mErrorSeverity = instance.mErrorSeverity;
        this.mHelpCenterId = instance.mHelpCenterId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BrandedContentAdError> getParser() {
        return new APIRequest.ResponseParser<BrandedContentAdError>(){

            @Override
            public APINodeList<BrandedContentAdError> parseResponse(String response, APIContext context, APIRequest<BrandedContentAdError> request, String header) throws APIException.MalformedResponseException {
                return BrandedContentAdError.parseResponse(response, context, request, header);
            }
        };
    }
}

