/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WebsiteCreativeAssetSource
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="source_url")
    private String mSourceUrl = null;
    protected static Gson gson = null;

    WebsiteCreativeAssetSource() {
    }

    public WebsiteCreativeAssetSource(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WebsiteCreativeAssetSource(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WebsiteCreativeAssetSource fetch() throws APIException {
        WebsiteCreativeAssetSource newInstance = WebsiteCreativeAssetSource.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WebsiteCreativeAssetSource fetchById(Long id, APIContext context) throws APIException {
        return WebsiteCreativeAssetSource.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WebsiteCreativeAssetSource> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WebsiteCreativeAssetSource.fetchByIdAsync(id.toString(), context);
    }

    public static WebsiteCreativeAssetSource fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WebsiteCreativeAssetSource> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WebsiteCreativeAssetSource> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WebsiteCreativeAssetSource>(context, "", "/", "GET", WebsiteCreativeAssetSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WebsiteCreativeAssetSource>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WebsiteCreativeAssetSource>(context, "", "/", "GET", WebsiteCreativeAssetSource.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WebsiteCreativeAssetSource loadJSON(String json, APIContext context, String header) {
        WebsiteCreativeAssetSource websiteCreativeAssetSource = (WebsiteCreativeAssetSource)WebsiteCreativeAssetSource.getGson().fromJson(json, WebsiteCreativeAssetSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(websiteCreativeAssetSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        websiteCreativeAssetSource.context = context;
        websiteCreativeAssetSource.rawValue = json;
        websiteCreativeAssetSource.header = header;
        return websiteCreativeAssetSource;
    }

    public static APINodeList<WebsiteCreativeAssetSource> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WebsiteCreativeAssetSource> websiteCreativeAssetSources = new APINodeList<WebsiteCreativeAssetSource>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return websiteCreativeAssetSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            websiteCreativeAssetSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        websiteCreativeAssetSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            websiteCreativeAssetSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return websiteCreativeAssetSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return websiteCreativeAssetSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return websiteCreativeAssetSources;
                }
                websiteCreativeAssetSources.clear();
                websiteCreativeAssetSources.add(WebsiteCreativeAssetSource.loadJSON(json, context, header));
                return websiteCreativeAssetSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WebsiteCreativeAssetSource.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldSourceUrl() {
        return this.mSourceUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WebsiteCreativeAssetSource copyFrom(WebsiteCreativeAssetSource instance) {
        this.mId = instance.mId;
        this.mSourceUrl = instance.mSourceUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WebsiteCreativeAssetSource> getParser() {
        return new APIRequest.ResponseParser<WebsiteCreativeAssetSource>(){

            @Override
            public APINodeList<WebsiteCreativeAssetSource> parseResponse(String response, APIContext context, APIRequest<WebsiteCreativeAssetSource> request, String header) throws APIException.MalformedResponseException {
                return WebsiteCreativeAssetSource.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<WebsiteCreativeAssetSource> {
        WebsiteCreativeAssetSource lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "source_url"};

        @Override
        public WebsiteCreativeAssetSource getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WebsiteCreativeAssetSource parseResponse(String response, String header) throws APIException {
            return WebsiteCreativeAssetSource.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WebsiteCreativeAssetSource execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WebsiteCreativeAssetSource execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WebsiteCreativeAssetSource> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WebsiteCreativeAssetSource> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WebsiteCreativeAssetSource>(){

                public WebsiteCreativeAssetSource apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestSourceUrlField() {
            return this.requestSourceUrlField(true);
        }

        public APIRequestGet requestSourceUrlField(boolean value) {
            this.requestField("source_url", value);
            return this;
        }
    }
}

