/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.utils;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerSideApiUtil {
    private static Pattern emailPattern = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
    private static Pattern SHA256RegEx = Pattern.compile("^[a-zA-Z0-9]{64}");
    private static Pattern MD5RegEx = Pattern.compile("^[a-zA-Z0-9]{32}");
    private static final Set<String> ISO_COUNTRY_LIST = ServerSideApiUtil.GetISOCountryCodeList();
    private static final Set<String> ISO_CURRENCY_LIST = ServerSideApiUtil.GetISOCurrencyCodeList();

    public static String hash(String input) {
        return Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
    }

    public static boolean isAlreadyHashed(String input) {
        Matcher md5Matcher = MD5RegEx.matcher(input);
        Matcher shaMatcher = SHA256RegEx.matcher(input);
        return md5Matcher.matches() || shaMatcher.matches();
    }

    public static String normalize(String token, String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required for normalizing a particular type");
        }
        if ("".equals(token = token.trim().toLowerCase())) {
            return null;
        }
        String result = token;
        if ("em".equals(fieldName)) {
            result = ServerSideApiUtil.validateEmail(token);
        } else if ("ph".equals(fieldName)) {
            result = ServerSideApiUtil.normalizePhoneNumber(token);
        } else if ("zp".equals(fieldName)) {
            result = ServerSideApiUtil.normalizePostalCode(token);
        } else if ("ct".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeCity(token);
        } else if ("country".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeCountry(token);
        } else if ("st".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeState(token);
        } else if ("currency".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeCurrency(token);
        } else if ("f5first".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeF5name(token);
        } else if ("f5last".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeF5name(token);
        } else if ("fi".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeFi(token);
        } else if ("dobd".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeDobd(token);
        } else if ("dobm".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeDobm(token);
        } else if ("doby".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeDoby(token);
        }
        return result;
    }

    private static String normalizeCity(String city) {
        city = city.replaceAll("[0-9]", "");
        city = city.replaceAll(" ", "");
        city = city.replaceAll("[\\-\\+\\.\\^:,\\{\\}\\(\\)\\$]", "");
        return city;
    }

    private static String normalizeCountry(String country) {
        if (!ISO_COUNTRY_LIST.contains(country = country.replaceAll("[^a-z]", ""))) {
            throw new IllegalArgumentException("Invalid format for country:'" + country + "'. Please follow 2-letter ISO 3166-1 standard for representing country. eg: us");
        }
        return country;
    }

    private static String normalizeCurrency(String currency) {
        if (!ISO_CURRENCY_LIST.contains(currency = currency.replaceAll("[^a-z]", ""))) {
            throw new IllegalArgumentException("Invalid format for currency:'" + currency + "'. Please follow 3-letter ISO 4217 standard for representing currency. Eg: usd");
        }
        return currency;
    }

    private static String normalizePhoneNumber(String phoneNumber) {
        if ((phoneNumber = phoneNumber.replaceAll("[\\-\\s\\(\\)]+", "")).length() < 6 || phoneNumber.length() > 16) {
            throw new IllegalArgumentException("Invalid phone number format for the passed phone number:" + phoneNumber + ". Please check the passed phone number format.");
        }
        return phoneNumber;
    }

    private static String validateEmail(String email) {
        if (!ServerSideApiUtil.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid email format for the passed email:" + email + ". Please check the passed email format.");
        }
        return email;
    }

    private static String normalizePostalCode(String postalCode) {
        String[] postalCodeArray = (postalCode = postalCode.replaceAll("[\\s]+", "")).split("-");
        if (postalCodeArray.length == 0) {
            throw new IllegalArgumentException("Invalid postalcode for the passed postalCode: '" + postalCode + "'.");
        }
        postalCode = postalCodeArray[0];
        if (postalCode.length() < 2) {
            throw new IllegalArgumentException("Invalid postalcode format for the passed postalCode:" + postalCode + ". Please check the passed postalcode.");
        }
        return postalCode;
    }

    private static String normalizeState(String state) {
        state = state.replaceAll("[^a-z]", "");
        return state;
    }

    private static String normalizeF5name(String name) {
        return name.substring(0, Math.min(5, name.length()));
    }

    private static String normalizeFi(String token) {
        if (token.length() > 1) {
            token = token.substring(0, 1);
        }
        return token;
    }

    private static String normalizeDobd(String input) {
        int dobdInt;
        String dobd = input;
        if (dobd.length() == 1) {
            dobd = "0" + dobd;
        }
        try {
            dobdInt = Integer.parseInt(dobd);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid dobd: '" + input + "'. Please specify the day in 'DD' format.");
        }
        if (dobd.length() > 2 || dobdInt < 1 || dobdInt > 31) {
            throw new IllegalArgumentException("Invalid dobd: '" + input + "'. Please specify the day in 'DD' format.");
        }
        return dobd;
    }

    private static String normalizeDobm(String input) {
        int dobmInt;
        String dobm = input;
        if (dobm.length() == 1) {
            dobm = "0" + dobm;
        }
        try {
            dobmInt = Integer.parseInt(dobm);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid dobm: '" + input + "'. Please specify the month in 'MM' format.");
        }
        if (dobm.length() > 2 || dobmInt < 1 || dobmInt > 12) {
            throw new IllegalArgumentException("Invalid dobm: '" + input + "'. Please specify the month in 'MM' format.");
        }
        return dobm;
    }

    private static String normalizeDoby(String doby) {
        if (!doby.matches("^[0-9]{4}$")) {
            throw new IllegalArgumentException("Invalid doby: '" + doby + "'. Please specify the year in 'YYYY' format.");
        }
        return doby;
    }

    private static boolean isValidEmail(String email) {
        Matcher m = emailPattern.matcher(email);
        return m.matches();
    }

    private static HashSet<String> GetISOCurrencyCodeList() {
        Set<Currency> availableCurrencies = Currency.getAvailableCurrencies();
        HashSet<String> currencyCodeList = new HashSet<String>();
        for (Currency currency : availableCurrencies) {
            currencyCodeList.add(currency.getCurrencyCode().toLowerCase());
        }
        return currencyCodeList;
    }

    private static HashSet<String> GetISOCountryCodeList() {
        List<String> availableCountries = Arrays.asList(Locale.getISOCountries());
        HashSet<String> countryCodeList = new HashSet<String>();
        for (String country : availableCountries) {
            countryCodeList.add(country.toLowerCase());
        }
        return countryCodeList;
    }
}

