/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class OrderIDAttributions
extends APINode {
    @SerializedName(value="app_id")
    private String mAppId = null;
    @SerializedName(value="attribution_type")
    private String mAttributionType = null;
    @SerializedName(value="attributions")
    private List<Object> mAttributions = null;
    @SerializedName(value="conversion_device")
    private String mConversionDevice = null;
    @SerializedName(value="dataset_id")
    private String mDatasetId = null;
    @SerializedName(value="holdout_status")
    private List<Object> mHoldoutStatus = null;
    @SerializedName(value="order_id")
    private String mOrderId = null;
    @SerializedName(value="order_timestamp")
    private String mOrderTimestamp = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static OrderIDAttributions loadJSON(String json, APIContext context, String header) {
        OrderIDAttributions orderIDAttributions = (OrderIDAttributions)OrderIDAttributions.getGson().fromJson(json, OrderIDAttributions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(orderIDAttributions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        orderIDAttributions.context = context;
        orderIDAttributions.rawValue = json;
        orderIDAttributions.header = header;
        return orderIDAttributions;
    }

    public static APINodeList<OrderIDAttributions> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OrderIDAttributions> orderIDAttributionss = new APINodeList<OrderIDAttributions>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return orderIDAttributionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            orderIDAttributionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        orderIDAttributionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            orderIDAttributionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            orderIDAttributionss.add(OrderIDAttributions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                orderIDAttributionss.add(OrderIDAttributions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            orderIDAttributionss.add(OrderIDAttributions.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return orderIDAttributionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return orderIDAttributionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return orderIDAttributionss;
                }
                orderIDAttributionss.clear();
                orderIDAttributionss.add(OrderIDAttributions.loadJSON(json, context, header));
                return orderIDAttributionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OrderIDAttributions.getGson().toJson((Object)this);
    }

    public String getFieldAppId() {
        return this.mAppId;
    }

    public OrderIDAttributions setFieldAppId(String value) {
        this.mAppId = value;
        return this;
    }

    public String getFieldAttributionType() {
        return this.mAttributionType;
    }

    public OrderIDAttributions setFieldAttributionType(String value) {
        this.mAttributionType = value;
        return this;
    }

    public List<Object> getFieldAttributions() {
        return this.mAttributions;
    }

    public OrderIDAttributions setFieldAttributions(List<Object> value) {
        this.mAttributions = value;
        return this;
    }

    public String getFieldConversionDevice() {
        return this.mConversionDevice;
    }

    public OrderIDAttributions setFieldConversionDevice(String value) {
        this.mConversionDevice = value;
        return this;
    }

    public String getFieldDatasetId() {
        return this.mDatasetId;
    }

    public OrderIDAttributions setFieldDatasetId(String value) {
        this.mDatasetId = value;
        return this;
    }

    public List<Object> getFieldHoldoutStatus() {
        return this.mHoldoutStatus;
    }

    public OrderIDAttributions setFieldHoldoutStatus(List<Object> value) {
        this.mHoldoutStatus = value;
        return this;
    }

    public String getFieldOrderId() {
        return this.mOrderId;
    }

    public OrderIDAttributions setFieldOrderId(String value) {
        this.mOrderId = value;
        return this;
    }

    public String getFieldOrderTimestamp() {
        return this.mOrderTimestamp;
    }

    public OrderIDAttributions setFieldOrderTimestamp(String value) {
        this.mOrderTimestamp = value;
        return this;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public OrderIDAttributions setFieldPixelId(String value) {
        this.mPixelId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OrderIDAttributions copyFrom(OrderIDAttributions instance) {
        this.mAppId = instance.mAppId;
        this.mAttributionType = instance.mAttributionType;
        this.mAttributions = instance.mAttributions;
        this.mConversionDevice = instance.mConversionDevice;
        this.mDatasetId = instance.mDatasetId;
        this.mHoldoutStatus = instance.mHoldoutStatus;
        this.mOrderId = instance.mOrderId;
        this.mOrderTimestamp = instance.mOrderTimestamp;
        this.mPixelId = instance.mPixelId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OrderIDAttributions> getParser() {
        return new APIRequest.ResponseParser<OrderIDAttributions>(){

            @Override
            public APINodeList<OrderIDAttributions> parseResponse(String response, APIContext context, APIRequest<OrderIDAttributions> request, String header) throws APIException.MalformedResponseException {
                return OrderIDAttributions.parseResponse(response, context, request, header);
            }
        };
    }
}

