/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PanelAPIReport
extends APINode {
    @SerializedName(value="checksum")
    private String mChecksum = null;
    @SerializedName(value="download_url")
    private String mDownloadUrl = null;
    @SerializedName(value="end_date")
    private String mEndDate = null;
    @SerializedName(value="export_file_type")
    private String mExportFileType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="index")
    private Long mIndex = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="number_of_chunks")
    private Long mNumberOfChunks = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    @SerializedName(value="upload_date")
    private String mUploadDate = null;
    protected static Gson gson = null;

    PanelAPIReport() {
    }

    public PanelAPIReport(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PanelAPIReport(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PanelAPIReport fetch() throws APIException {
        PanelAPIReport newInstance = PanelAPIReport.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PanelAPIReport fetchById(Long id, APIContext context) throws APIException {
        return PanelAPIReport.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PanelAPIReport> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PanelAPIReport.fetchByIdAsync(id.toString(), context);
    }

    public static PanelAPIReport fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PanelAPIReport> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PanelAPIReport> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PanelAPIReport>(context, "", "/", "GET", PanelAPIReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PanelAPIReport>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PanelAPIReport>(context, "", "/", "GET", PanelAPIReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PanelAPIReport loadJSON(String json, APIContext context, String header) {
        PanelAPIReport panelAPIReport = (PanelAPIReport)PanelAPIReport.getGson().fromJson(json, PanelAPIReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(panelAPIReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        panelAPIReport.context = context;
        panelAPIReport.rawValue = json;
        panelAPIReport.header = header;
        return panelAPIReport;
    }

    public static APINodeList<PanelAPIReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PanelAPIReport> panelAPIReports = new APINodeList<PanelAPIReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        panelAPIReports.add(PanelAPIReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return panelAPIReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            panelAPIReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        panelAPIReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            panelAPIReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            panelAPIReports.add(PanelAPIReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                panelAPIReports.add(PanelAPIReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            panelAPIReports.add(PanelAPIReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return panelAPIReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        panelAPIReports.add(PanelAPIReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return panelAPIReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        panelAPIReports.add(PanelAPIReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return panelAPIReports;
                }
                panelAPIReports.clear();
                panelAPIReports.add(PanelAPIReport.loadJSON(json, context, header));
                return panelAPIReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PanelAPIReport.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldChecksum() {
        return this.mChecksum;
    }

    public String getFieldDownloadUrl() {
        return this.mDownloadUrl;
    }

    public String getFieldEndDate() {
        return this.mEndDate;
    }

    public String getFieldExportFileType() {
        return this.mExportFileType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldIndex() {
        return this.mIndex;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldNumberOfChunks() {
        return this.mNumberOfChunks;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    public String getFieldUploadDate() {
        return this.mUploadDate;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PanelAPIReport copyFrom(PanelAPIReport instance) {
        this.mChecksum = instance.mChecksum;
        this.mDownloadUrl = instance.mDownloadUrl;
        this.mEndDate = instance.mEndDate;
        this.mExportFileType = instance.mExportFileType;
        this.mId = instance.mId;
        this.mIndex = instance.mIndex;
        this.mName = instance.mName;
        this.mNumberOfChunks = instance.mNumberOfChunks;
        this.mStartDate = instance.mStartDate;
        this.mUploadDate = instance.mUploadDate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PanelAPIReport> getParser() {
        return new APIRequest.ResponseParser<PanelAPIReport>(){

            @Override
            public APINodeList<PanelAPIReport> parseResponse(String response, APIContext context, APIRequest<PanelAPIReport> request, String header) throws APIException.MalformedResponseException {
                return PanelAPIReport.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PanelAPIReport> {
        PanelAPIReport lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"checksum", "download_url", "end_date", "export_file_type", "id", "index", "name", "number_of_chunks", "start_date", "upload_date"};

        @Override
        public PanelAPIReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PanelAPIReport parseResponse(String response, String header) throws APIException {
            return PanelAPIReport.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PanelAPIReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PanelAPIReport execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PanelAPIReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PanelAPIReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PanelAPIReport>(){

                public PanelAPIReport apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestChecksumField() {
            return this.requestChecksumField(true);
        }

        public APIRequestGet requestChecksumField(boolean value) {
            this.requestField("checksum", value);
            return this;
        }

        public APIRequestGet requestDownloadUrlField() {
            return this.requestDownloadUrlField(true);
        }

        public APIRequestGet requestDownloadUrlField(boolean value) {
            this.requestField("download_url", value);
            return this;
        }

        public APIRequestGet requestEndDateField() {
            return this.requestEndDateField(true);
        }

        public APIRequestGet requestEndDateField(boolean value) {
            this.requestField("end_date", value);
            return this;
        }

        public APIRequestGet requestExportFileTypeField() {
            return this.requestExportFileTypeField(true);
        }

        public APIRequestGet requestExportFileTypeField(boolean value) {
            this.requestField("export_file_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIndexField() {
            return this.requestIndexField(true);
        }

        public APIRequestGet requestIndexField(boolean value) {
            this.requestField("index", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNumberOfChunksField() {
            return this.requestNumberOfChunksField(true);
        }

        public APIRequestGet requestNumberOfChunksField(boolean value) {
            this.requestField("number_of_chunks", value);
            return this;
        }

        public APIRequestGet requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGet requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }

        public APIRequestGet requestUploadDateField() {
            return this.requestUploadDateField(true);
        }

        public APIRequestGet requestUploadDateField(boolean value) {
            this.requestField("upload_date", value);
            return this;
        }
    }
}

