/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.ProductCatalog;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CatalogSmartPixelSettings
extends APINode {
    @SerializedName(value="allowed_domains")
    private List<String> mAllowedDomains = null;
    @SerializedName(value="available_property_filters")
    private List<String> mAvailablePropertyFilters = null;
    @SerializedName(value="catalog")
    private ProductCatalog mCatalog = null;
    @SerializedName(value="cbb_custom_override_filters")
    private List<Object> mCbbCustomOverrideFilters = null;
    @SerializedName(value="cbb_default_filter")
    private List<Map<String, List<String>>> mCbbDefaultFilter = null;
    @SerializedName(value="defaults")
    private List<Map<String, String>> mDefaults = null;
    @SerializedName(value="filters")
    private List<Map<String, List<String>>> mFilters = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_cbb_enabled")
    private Boolean mIsCbbEnabled = null;
    @SerializedName(value="is_create_enabled")
    private Boolean mIsCreateEnabled = null;
    @SerializedName(value="is_delete_enabled")
    private Boolean mIsDeleteEnabled = null;
    @SerializedName(value="is_update_enabled")
    private Boolean mIsUpdateEnabled = null;
    @SerializedName(value="microdata_format_precedence")
    private List<String> mMicrodataFormatPrecedence = null;
    @SerializedName(value="pixel")
    private AdsPixel mPixel = null;
    @SerializedName(value="property_filter")
    private List<String> mPropertyFilter = null;
    @SerializedName(value="trusted_domains")
    private List<String> mTrustedDomains = null;
    protected static Gson gson = null;

    CatalogSmartPixelSettings() {
    }

    public CatalogSmartPixelSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CatalogSmartPixelSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CatalogSmartPixelSettings fetch() throws APIException {
        CatalogSmartPixelSettings newInstance = CatalogSmartPixelSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CatalogSmartPixelSettings fetchById(Long id, APIContext context) throws APIException {
        return CatalogSmartPixelSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CatalogSmartPixelSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CatalogSmartPixelSettings.fetchByIdAsync(id.toString(), context);
    }

    public static CatalogSmartPixelSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CatalogSmartPixelSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CatalogSmartPixelSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CatalogSmartPixelSettings>(context, "", "/", "GET", CatalogSmartPixelSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CatalogSmartPixelSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CatalogSmartPixelSettings>(context, "", "/", "GET", CatalogSmartPixelSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CatalogSmartPixelSettings loadJSON(String json, APIContext context, String header) {
        CatalogSmartPixelSettings catalogSmartPixelSettings = (CatalogSmartPixelSettings)CatalogSmartPixelSettings.getGson().fromJson(json, CatalogSmartPixelSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(catalogSmartPixelSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        catalogSmartPixelSettings.context = context;
        catalogSmartPixelSettings.rawValue = json;
        catalogSmartPixelSettings.header = header;
        return catalogSmartPixelSettings;
    }

    public static APINodeList<CatalogSmartPixelSettings> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CatalogSmartPixelSettings> catalogSmartPixelSettingss = new APINodeList<CatalogSmartPixelSettings>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return catalogSmartPixelSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            catalogSmartPixelSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        catalogSmartPixelSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            catalogSmartPixelSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return catalogSmartPixelSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return catalogSmartPixelSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return catalogSmartPixelSettingss;
                }
                catalogSmartPixelSettingss.clear();
                catalogSmartPixelSettingss.add(CatalogSmartPixelSettings.loadJSON(json, context, header));
                return catalogSmartPixelSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CatalogSmartPixelSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAllowedDomains() {
        return this.mAllowedDomains;
    }

    public List<String> getFieldAvailablePropertyFilters() {
        return this.mAvailablePropertyFilters;
    }

    public ProductCatalog getFieldCatalog() {
        if (this.mCatalog != null) {
            this.mCatalog.context = this.getContext();
        }
        return this.mCatalog;
    }

    public List<Object> getFieldCbbCustomOverrideFilters() {
        return this.mCbbCustomOverrideFilters;
    }

    public List<Map<String, List<String>>> getFieldCbbDefaultFilter() {
        return this.mCbbDefaultFilter;
    }

    public List<Map<String, String>> getFieldDefaults() {
        return this.mDefaults;
    }

    public List<Map<String, List<String>>> getFieldFilters() {
        return this.mFilters;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsCbbEnabled() {
        return this.mIsCbbEnabled;
    }

    public Boolean getFieldIsCreateEnabled() {
        return this.mIsCreateEnabled;
    }

    public Boolean getFieldIsDeleteEnabled() {
        return this.mIsDeleteEnabled;
    }

    public Boolean getFieldIsUpdateEnabled() {
        return this.mIsUpdateEnabled;
    }

    public List<String> getFieldMicrodataFormatPrecedence() {
        return this.mMicrodataFormatPrecedence;
    }

    public AdsPixel getFieldPixel() {
        if (this.mPixel != null) {
            this.mPixel.context = this.getContext();
        }
        return this.mPixel;
    }

    public List<String> getFieldPropertyFilter() {
        return this.mPropertyFilter;
    }

    public List<String> getFieldTrustedDomains() {
        return this.mTrustedDomains;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CatalogSmartPixelSettings copyFrom(CatalogSmartPixelSettings instance) {
        this.mAllowedDomains = instance.mAllowedDomains;
        this.mAvailablePropertyFilters = instance.mAvailablePropertyFilters;
        this.mCatalog = instance.mCatalog;
        this.mCbbCustomOverrideFilters = instance.mCbbCustomOverrideFilters;
        this.mCbbDefaultFilter = instance.mCbbDefaultFilter;
        this.mDefaults = instance.mDefaults;
        this.mFilters = instance.mFilters;
        this.mId = instance.mId;
        this.mIsCbbEnabled = instance.mIsCbbEnabled;
        this.mIsCreateEnabled = instance.mIsCreateEnabled;
        this.mIsDeleteEnabled = instance.mIsDeleteEnabled;
        this.mIsUpdateEnabled = instance.mIsUpdateEnabled;
        this.mMicrodataFormatPrecedence = instance.mMicrodataFormatPrecedence;
        this.mPixel = instance.mPixel;
        this.mPropertyFilter = instance.mPropertyFilter;
        this.mTrustedDomains = instance.mTrustedDomains;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CatalogSmartPixelSettings> getParser() {
        return new APIRequest.ResponseParser<CatalogSmartPixelSettings>(){

            @Override
            public APINodeList<CatalogSmartPixelSettings> parseResponse(String response, APIContext context, APIRequest<CatalogSmartPixelSettings> request, String header) throws APIException.MalformedResponseException {
                return CatalogSmartPixelSettings.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CatalogSmartPixelSettings> {
        CatalogSmartPixelSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"allowed_domains", "available_property_filters", "catalog", "cbb_custom_override_filters", "cbb_default_filter", "defaults", "filters", "id", "is_cbb_enabled", "is_create_enabled", "is_delete_enabled", "is_update_enabled", "microdata_format_precedence", "pixel", "property_filter", "trusted_domains"};

        @Override
        public CatalogSmartPixelSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CatalogSmartPixelSettings parseResponse(String response, String header) throws APIException {
            return CatalogSmartPixelSettings.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CatalogSmartPixelSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CatalogSmartPixelSettings execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CatalogSmartPixelSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CatalogSmartPixelSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CatalogSmartPixelSettings>(){

                public CatalogSmartPixelSettings apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAllowedDomainsField() {
            return this.requestAllowedDomainsField(true);
        }

        public APIRequestGet requestAllowedDomainsField(boolean value) {
            this.requestField("allowed_domains", value);
            return this;
        }

        public APIRequestGet requestAvailablePropertyFiltersField() {
            return this.requestAvailablePropertyFiltersField(true);
        }

        public APIRequestGet requestAvailablePropertyFiltersField(boolean value) {
            this.requestField("available_property_filters", value);
            return this;
        }

        public APIRequestGet requestCatalogField() {
            return this.requestCatalogField(true);
        }

        public APIRequestGet requestCatalogField(boolean value) {
            this.requestField("catalog", value);
            return this;
        }

        public APIRequestGet requestCbbCustomOverrideFiltersField() {
            return this.requestCbbCustomOverrideFiltersField(true);
        }

        public APIRequestGet requestCbbCustomOverrideFiltersField(boolean value) {
            this.requestField("cbb_custom_override_filters", value);
            return this;
        }

        public APIRequestGet requestCbbDefaultFilterField() {
            return this.requestCbbDefaultFilterField(true);
        }

        public APIRequestGet requestCbbDefaultFilterField(boolean value) {
            this.requestField("cbb_default_filter", value);
            return this;
        }

        public APIRequestGet requestDefaultsField() {
            return this.requestDefaultsField(true);
        }

        public APIRequestGet requestDefaultsField(boolean value) {
            this.requestField("defaults", value);
            return this;
        }

        public APIRequestGet requestFiltersField() {
            return this.requestFiltersField(true);
        }

        public APIRequestGet requestFiltersField(boolean value) {
            this.requestField("filters", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsCbbEnabledField() {
            return this.requestIsCbbEnabledField(true);
        }

        public APIRequestGet requestIsCbbEnabledField(boolean value) {
            this.requestField("is_cbb_enabled", value);
            return this;
        }

        public APIRequestGet requestIsCreateEnabledField() {
            return this.requestIsCreateEnabledField(true);
        }

        public APIRequestGet requestIsCreateEnabledField(boolean value) {
            this.requestField("is_create_enabled", value);
            return this;
        }

        public APIRequestGet requestIsDeleteEnabledField() {
            return this.requestIsDeleteEnabledField(true);
        }

        public APIRequestGet requestIsDeleteEnabledField(boolean value) {
            this.requestField("is_delete_enabled", value);
            return this;
        }

        public APIRequestGet requestIsUpdateEnabledField() {
            return this.requestIsUpdateEnabledField(true);
        }

        public APIRequestGet requestIsUpdateEnabledField(boolean value) {
            this.requestField("is_update_enabled", value);
            return this;
        }

        public APIRequestGet requestMicrodataFormatPrecedenceField() {
            return this.requestMicrodataFormatPrecedenceField(true);
        }

        public APIRequestGet requestMicrodataFormatPrecedenceField(boolean value) {
            this.requestField("microdata_format_precedence", value);
            return this;
        }

        public APIRequestGet requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGet requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }

        public APIRequestGet requestPropertyFilterField() {
            return this.requestPropertyFilterField(true);
        }

        public APIRequestGet requestPropertyFilterField(boolean value) {
            this.requestField("property_filter", value);
            return this;
        }

        public APIRequestGet requestTrustedDomainsField() {
            return this.requestTrustedDomainsField(true);
        }

        public APIRequestGet requestTrustedDomainsField(boolean value) {
            this.requestField("trusted_domains", value);
            return this;
        }
    }
}

