/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdsUserSettings
extends APINode {
    @SerializedName(value="a_plus_c_survey_seen")
    private Boolean mAPlusCSurveySeen = null;
    @SerializedName(value="adgroup_name_template")
    private Object mAdgroupNameTemplate = null;
    @SerializedName(value="ads_cs_catalog_opt_out_timestamp")
    private List<Map<String, Long>> mAdsCsCatalogOptOutTimestamp = null;
    @SerializedName(value="ads_tool_visits")
    private List<Object> mAdsToolVisits = null;
    @SerializedName(value="aplusc_carousel_cda_opt_in_status")
    private String mApluscCarouselCdaOptInStatus = null;
    @SerializedName(value="aplusc_carousel_inline_comment_opt_in_status")
    private String mApluscCarouselInlineCommentOptInStatus = null;
    @SerializedName(value="aplusc_epa_opt_in_status")
    private String mApluscEpaOptInStatus = null;
    @SerializedName(value="aplusc_opt_out_friction")
    private List<String> mApluscOptOutFriction = null;
    @SerializedName(value="autoflow_lite_opt_in_status")
    private String mAutoflowLiteOptInStatus = null;
    @SerializedName(value="autoflow_lite_should_opt_in")
    private Boolean mAutoflowLiteShouldOptIn = null;
    @SerializedName(value="blended_ads_creation_defaulting_opt_in_status")
    private String mBlendedAdsCreationDefaultingOptInStatus = null;
    @SerializedName(value="blended_ads_creation_defaulting_opt_out_campaign_group_ids")
    private List<Long> mBlendedAdsCreationDefaultingOptOutCampaignGroupIds = null;
    @SerializedName(value="bookmarked_pages")
    private List<Page> mBookmarkedPages = null;
    @SerializedName(value="campaign_group_name_template")
    private Object mCampaignGroupNameTemplate = null;
    @SerializedName(value="campaign_name_template")
    private Object mCampaignNameTemplate = null;
    @SerializedName(value="carousel_to_video_opt_in_status")
    private String mCarouselToVideoOptInStatus = null;
    @SerializedName(value="connected_sources_catalog_opt_in_status")
    private String mConnectedSourcesCatalogOptInStatus = null;
    @SerializedName(value="default_creation_mode")
    private String mDefaultCreationMode = null;
    @SerializedName(value="export_format_default")
    private String mExportFormatDefault = null;
    @SerializedName(value="focus_mode_default")
    private String mFocusModeDefault = null;
    @SerializedName(value="gen_ai_alpha_test_status")
    private Long mGenAiAlphaTestStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_expansion_opt_in_status")
    private String mImageExpansionOptInStatus = null;
    @SerializedName(value="is_ads_ai_consented")
    private Boolean mIsAdsAiConsented = null;
    @SerializedName(value="is_cbo_default_on")
    private Boolean mIsCboDefaultOn = null;
    @SerializedName(value="is_se_removal_guidance_dismissed")
    private Boolean mIsSeRemovalGuidanceDismissed = null;
    @SerializedName(value="last_used_post_format")
    private String mLastUsedPostFormat = null;
    @SerializedName(value="last_visited_time")
    private String mLastVisitedTime = null;
    @SerializedName(value="music_on_reels_opt_in")
    private List<Map<String, String>> mMusicOnReelsOptIn = null;
    @SerializedName(value="muted_cbo_midflight_education_messages")
    private List<String> mMutedCboMidflightEducationMessages = null;
    @SerializedName(value="onsite_destination_optimization_opt_in")
    private String mOnsiteDestinationOptimizationOptIn = null;
    @SerializedName(value="open_tabs")
    private List<String> mOpenTabs = null;
    @SerializedName(value="previously_seen_recommendations")
    private List<String> mPreviouslySeenRecommendations = null;
    @SerializedName(value="product_extensions_opt_in")
    private String mProductExtensionsOptIn = null;
    @SerializedName(value="selected_ad_account")
    private AdAccount mSelectedAdAccount = null;
    @SerializedName(value="selected_comparison_timerange")
    private Object mSelectedComparisonTimerange = null;
    @SerializedName(value="selected_metric_cic")
    private String mSelectedMetricCic = null;
    @SerializedName(value="selected_metrics_cic")
    private List<String> mSelectedMetricsCic = null;
    @SerializedName(value="selected_page")
    private Page mSelectedPage = null;
    @SerializedName(value="selected_page_section")
    private String mSelectedPageSection = null;
    @SerializedName(value="selected_power_editor_pane")
    private String mSelectedPowerEditorPane = null;
    @SerializedName(value="selected_stat_range")
    private Object mSelectedStatRange = null;
    @SerializedName(value="should_export_filter_empty_cols")
    private String mShouldExportFilterEmptyCols = null;
    @SerializedName(value="should_export_rows_without_unsupported_feature")
    private String mShouldExportRowsWithoutUnsupportedFeature = null;
    @SerializedName(value="should_not_auto_expand_tree_table")
    private Boolean mShouldNotAutoExpandTreeTable = null;
    @SerializedName(value="should_not_show_cbo_campaign_toggle_off_confirmation_message")
    private Boolean mShouldNotShowCboCampaignToggleOffConfirmationMessage = null;
    @SerializedName(value="should_not_show_publish_message_on_editor_close")
    private Boolean mShouldNotShowPublishMessageOnEditorClose = null;
    @SerializedName(value="show_original_videos_opt_in")
    private String mShowOriginalVideosOptIn = null;
    @SerializedName(value="static_ad_product_extensions_opt_in")
    private String mStaticAdProductExtensionsOptIn = null;
    @SerializedName(value="sticky_setting_after_default_on")
    private String mStickySettingAfterDefaultOn = null;
    @SerializedName(value="syd_campaign_trends_metric")
    private String mSydCampaignTrendsMetric = null;
    @SerializedName(value="total_coupon_syd_dismissals")
    private Long mTotalCouponSydDismissals = null;
    @SerializedName(value="total_coupon_upsell_dismissals")
    private Long mTotalCouponUpsellDismissals = null;
    @SerializedName(value="url_prefill_removal_timestamp")
    private Long mUrlPrefillRemovalTimestamp = null;
    @SerializedName(value="use_pe_create_flow")
    private Boolean mUsePeCreateFlow = null;
    @SerializedName(value="use_stepper_primary_entry")
    private Boolean mUseStepperPrimaryEntry = null;
    @SerializedName(value="user")
    private User mUser = null;
    protected static Gson gson = null;

    AdsUserSettings() {
    }

    public AdsUserSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsUserSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsUserSettings fetch() throws APIException {
        AdsUserSettings newInstance = AdsUserSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsUserSettings fetchById(Long id, APIContext context) throws APIException {
        return AdsUserSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsUserSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsUserSettings.fetchByIdAsync(id.toString(), context);
    }

    public static AdsUserSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsUserSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsUserSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsUserSettings>(context, "", "/", "GET", AdsUserSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsUserSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsUserSettings>(context, "", "/", "GET", AdsUserSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsUserSettings loadJSON(String json, APIContext context, String header) {
        AdsUserSettings adsUserSettings = (AdsUserSettings)AdsUserSettings.getGson().fromJson(json, AdsUserSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsUserSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsUserSettings.context = context;
        adsUserSettings.rawValue = json;
        adsUserSettings.header = header;
        return adsUserSettings;
    }

    public static APINodeList<AdsUserSettings> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsUserSettings> adsUserSettingss = new APINodeList<AdsUserSettings>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsUserSettingss.add(AdsUserSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsUserSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsUserSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsUserSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsUserSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsUserSettingss.add(AdsUserSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsUserSettingss.add(AdsUserSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsUserSettingss.add(AdsUserSettings.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsUserSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsUserSettingss.add(AdsUserSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsUserSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsUserSettingss.add(AdsUserSettings.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsUserSettingss;
                }
                adsUserSettingss.clear();
                adsUserSettingss.add(AdsUserSettings.loadJSON(json, context, header));
                return adsUserSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsUserSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldAPlusCSurveySeen() {
        return this.mAPlusCSurveySeen;
    }

    public Object getFieldAdgroupNameTemplate() {
        return this.mAdgroupNameTemplate;
    }

    public List<Map<String, Long>> getFieldAdsCsCatalogOptOutTimestamp() {
        return this.mAdsCsCatalogOptOutTimestamp;
    }

    public List<Object> getFieldAdsToolVisits() {
        return this.mAdsToolVisits;
    }

    public String getFieldApluscCarouselCdaOptInStatus() {
        return this.mApluscCarouselCdaOptInStatus;
    }

    public String getFieldApluscCarouselInlineCommentOptInStatus() {
        return this.mApluscCarouselInlineCommentOptInStatus;
    }

    public String getFieldApluscEpaOptInStatus() {
        return this.mApluscEpaOptInStatus;
    }

    public List<String> getFieldApluscOptOutFriction() {
        return this.mApluscOptOutFriction;
    }

    public String getFieldAutoflowLiteOptInStatus() {
        return this.mAutoflowLiteOptInStatus;
    }

    public Boolean getFieldAutoflowLiteShouldOptIn() {
        return this.mAutoflowLiteShouldOptIn;
    }

    public String getFieldBlendedAdsCreationDefaultingOptInStatus() {
        return this.mBlendedAdsCreationDefaultingOptInStatus;
    }

    public List<Long> getFieldBlendedAdsCreationDefaultingOptOutCampaignGroupIds() {
        return this.mBlendedAdsCreationDefaultingOptOutCampaignGroupIds;
    }

    public List<Page> getFieldBookmarkedPages() {
        return this.mBookmarkedPages;
    }

    public Object getFieldCampaignGroupNameTemplate() {
        return this.mCampaignGroupNameTemplate;
    }

    public Object getFieldCampaignNameTemplate() {
        return this.mCampaignNameTemplate;
    }

    public String getFieldCarouselToVideoOptInStatus() {
        return this.mCarouselToVideoOptInStatus;
    }

    public String getFieldConnectedSourcesCatalogOptInStatus() {
        return this.mConnectedSourcesCatalogOptInStatus;
    }

    public String getFieldDefaultCreationMode() {
        return this.mDefaultCreationMode;
    }

    public String getFieldExportFormatDefault() {
        return this.mExportFormatDefault;
    }

    public String getFieldFocusModeDefault() {
        return this.mFocusModeDefault;
    }

    public Long getFieldGenAiAlphaTestStatus() {
        return this.mGenAiAlphaTestStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldImageExpansionOptInStatus() {
        return this.mImageExpansionOptInStatus;
    }

    public Boolean getFieldIsAdsAiConsented() {
        return this.mIsAdsAiConsented;
    }

    public Boolean getFieldIsCboDefaultOn() {
        return this.mIsCboDefaultOn;
    }

    public Boolean getFieldIsSeRemovalGuidanceDismissed() {
        return this.mIsSeRemovalGuidanceDismissed;
    }

    public String getFieldLastUsedPostFormat() {
        return this.mLastUsedPostFormat;
    }

    public String getFieldLastVisitedTime() {
        return this.mLastVisitedTime;
    }

    public List<Map<String, String>> getFieldMusicOnReelsOptIn() {
        return this.mMusicOnReelsOptIn;
    }

    public List<String> getFieldMutedCboMidflightEducationMessages() {
        return this.mMutedCboMidflightEducationMessages;
    }

    public String getFieldOnsiteDestinationOptimizationOptIn() {
        return this.mOnsiteDestinationOptimizationOptIn;
    }

    public List<String> getFieldOpenTabs() {
        return this.mOpenTabs;
    }

    public List<String> getFieldPreviouslySeenRecommendations() {
        return this.mPreviouslySeenRecommendations;
    }

    public String getFieldProductExtensionsOptIn() {
        return this.mProductExtensionsOptIn;
    }

    public AdAccount getFieldSelectedAdAccount() {
        if (this.mSelectedAdAccount != null) {
            this.mSelectedAdAccount.context = this.getContext();
        }
        return this.mSelectedAdAccount;
    }

    public Object getFieldSelectedComparisonTimerange() {
        return this.mSelectedComparisonTimerange;
    }

    public String getFieldSelectedMetricCic() {
        return this.mSelectedMetricCic;
    }

    public List<String> getFieldSelectedMetricsCic() {
        return this.mSelectedMetricsCic;
    }

    public Page getFieldSelectedPage() {
        if (this.mSelectedPage != null) {
            this.mSelectedPage.context = this.getContext();
        }
        return this.mSelectedPage;
    }

    public String getFieldSelectedPageSection() {
        return this.mSelectedPageSection;
    }

    public String getFieldSelectedPowerEditorPane() {
        return this.mSelectedPowerEditorPane;
    }

    public Object getFieldSelectedStatRange() {
        return this.mSelectedStatRange;
    }

    public String getFieldShouldExportFilterEmptyCols() {
        return this.mShouldExportFilterEmptyCols;
    }

    public String getFieldShouldExportRowsWithoutUnsupportedFeature() {
        return this.mShouldExportRowsWithoutUnsupportedFeature;
    }

    public Boolean getFieldShouldNotAutoExpandTreeTable() {
        return this.mShouldNotAutoExpandTreeTable;
    }

    public Boolean getFieldShouldNotShowCboCampaignToggleOffConfirmationMessage() {
        return this.mShouldNotShowCboCampaignToggleOffConfirmationMessage;
    }

    public Boolean getFieldShouldNotShowPublishMessageOnEditorClose() {
        return this.mShouldNotShowPublishMessageOnEditorClose;
    }

    public String getFieldShowOriginalVideosOptIn() {
        return this.mShowOriginalVideosOptIn;
    }

    public String getFieldStaticAdProductExtensionsOptIn() {
        return this.mStaticAdProductExtensionsOptIn;
    }

    public String getFieldStickySettingAfterDefaultOn() {
        return this.mStickySettingAfterDefaultOn;
    }

    public String getFieldSydCampaignTrendsMetric() {
        return this.mSydCampaignTrendsMetric;
    }

    public Long getFieldTotalCouponSydDismissals() {
        return this.mTotalCouponSydDismissals;
    }

    public Long getFieldTotalCouponUpsellDismissals() {
        return this.mTotalCouponUpsellDismissals;
    }

    public Long getFieldUrlPrefillRemovalTimestamp() {
        return this.mUrlPrefillRemovalTimestamp;
    }

    public Boolean getFieldUsePeCreateFlow() {
        return this.mUsePeCreateFlow;
    }

    public Boolean getFieldUseStepperPrimaryEntry() {
        return this.mUseStepperPrimaryEntry;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsUserSettings copyFrom(AdsUserSettings instance) {
        this.mAPlusCSurveySeen = instance.mAPlusCSurveySeen;
        this.mAdgroupNameTemplate = instance.mAdgroupNameTemplate;
        this.mAdsCsCatalogOptOutTimestamp = instance.mAdsCsCatalogOptOutTimestamp;
        this.mAdsToolVisits = instance.mAdsToolVisits;
        this.mApluscCarouselCdaOptInStatus = instance.mApluscCarouselCdaOptInStatus;
        this.mApluscCarouselInlineCommentOptInStatus = instance.mApluscCarouselInlineCommentOptInStatus;
        this.mApluscEpaOptInStatus = instance.mApluscEpaOptInStatus;
        this.mApluscOptOutFriction = instance.mApluscOptOutFriction;
        this.mAutoflowLiteOptInStatus = instance.mAutoflowLiteOptInStatus;
        this.mAutoflowLiteShouldOptIn = instance.mAutoflowLiteShouldOptIn;
        this.mBlendedAdsCreationDefaultingOptInStatus = instance.mBlendedAdsCreationDefaultingOptInStatus;
        this.mBlendedAdsCreationDefaultingOptOutCampaignGroupIds = instance.mBlendedAdsCreationDefaultingOptOutCampaignGroupIds;
        this.mBookmarkedPages = instance.mBookmarkedPages;
        this.mCampaignGroupNameTemplate = instance.mCampaignGroupNameTemplate;
        this.mCampaignNameTemplate = instance.mCampaignNameTemplate;
        this.mCarouselToVideoOptInStatus = instance.mCarouselToVideoOptInStatus;
        this.mConnectedSourcesCatalogOptInStatus = instance.mConnectedSourcesCatalogOptInStatus;
        this.mDefaultCreationMode = instance.mDefaultCreationMode;
        this.mExportFormatDefault = instance.mExportFormatDefault;
        this.mFocusModeDefault = instance.mFocusModeDefault;
        this.mGenAiAlphaTestStatus = instance.mGenAiAlphaTestStatus;
        this.mId = instance.mId;
        this.mImageExpansionOptInStatus = instance.mImageExpansionOptInStatus;
        this.mIsAdsAiConsented = instance.mIsAdsAiConsented;
        this.mIsCboDefaultOn = instance.mIsCboDefaultOn;
        this.mIsSeRemovalGuidanceDismissed = instance.mIsSeRemovalGuidanceDismissed;
        this.mLastUsedPostFormat = instance.mLastUsedPostFormat;
        this.mLastVisitedTime = instance.mLastVisitedTime;
        this.mMusicOnReelsOptIn = instance.mMusicOnReelsOptIn;
        this.mMutedCboMidflightEducationMessages = instance.mMutedCboMidflightEducationMessages;
        this.mOnsiteDestinationOptimizationOptIn = instance.mOnsiteDestinationOptimizationOptIn;
        this.mOpenTabs = instance.mOpenTabs;
        this.mPreviouslySeenRecommendations = instance.mPreviouslySeenRecommendations;
        this.mProductExtensionsOptIn = instance.mProductExtensionsOptIn;
        this.mSelectedAdAccount = instance.mSelectedAdAccount;
        this.mSelectedComparisonTimerange = instance.mSelectedComparisonTimerange;
        this.mSelectedMetricCic = instance.mSelectedMetricCic;
        this.mSelectedMetricsCic = instance.mSelectedMetricsCic;
        this.mSelectedPage = instance.mSelectedPage;
        this.mSelectedPageSection = instance.mSelectedPageSection;
        this.mSelectedPowerEditorPane = instance.mSelectedPowerEditorPane;
        this.mSelectedStatRange = instance.mSelectedStatRange;
        this.mShouldExportFilterEmptyCols = instance.mShouldExportFilterEmptyCols;
        this.mShouldExportRowsWithoutUnsupportedFeature = instance.mShouldExportRowsWithoutUnsupportedFeature;
        this.mShouldNotAutoExpandTreeTable = instance.mShouldNotAutoExpandTreeTable;
        this.mShouldNotShowCboCampaignToggleOffConfirmationMessage = instance.mShouldNotShowCboCampaignToggleOffConfirmationMessage;
        this.mShouldNotShowPublishMessageOnEditorClose = instance.mShouldNotShowPublishMessageOnEditorClose;
        this.mShowOriginalVideosOptIn = instance.mShowOriginalVideosOptIn;
        this.mStaticAdProductExtensionsOptIn = instance.mStaticAdProductExtensionsOptIn;
        this.mStickySettingAfterDefaultOn = instance.mStickySettingAfterDefaultOn;
        this.mSydCampaignTrendsMetric = instance.mSydCampaignTrendsMetric;
        this.mTotalCouponSydDismissals = instance.mTotalCouponSydDismissals;
        this.mTotalCouponUpsellDismissals = instance.mTotalCouponUpsellDismissals;
        this.mUrlPrefillRemovalTimestamp = instance.mUrlPrefillRemovalTimestamp;
        this.mUsePeCreateFlow = instance.mUsePeCreateFlow;
        this.mUseStepperPrimaryEntry = instance.mUseStepperPrimaryEntry;
        this.mUser = instance.mUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsUserSettings> getParser() {
        return new APIRequest.ResponseParser<AdsUserSettings>(){

            @Override
            public APINodeList<AdsUserSettings> parseResponse(String response, APIContext context, APIRequest<AdsUserSettings> request, String header) throws APIException.MalformedResponseException {
                return AdsUserSettings.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdsUserSettings> {
        AdsUserSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"a_plus_c_survey_seen", "adgroup_name_template", "ads_cs_catalog_opt_out_timestamp", "ads_tool_visits", "aplusc_carousel_cda_opt_in_status", "aplusc_carousel_inline_comment_opt_in_status", "aplusc_epa_opt_in_status", "aplusc_opt_out_friction", "autoflow_lite_opt_in_status", "autoflow_lite_should_opt_in", "blended_ads_creation_defaulting_opt_in_status", "blended_ads_creation_defaulting_opt_out_campaign_group_ids", "bookmarked_pages", "campaign_group_name_template", "campaign_name_template", "carousel_to_video_opt_in_status", "connected_sources_catalog_opt_in_status", "default_creation_mode", "export_format_default", "focus_mode_default", "gen_ai_alpha_test_status", "id", "image_expansion_opt_in_status", "is_ads_ai_consented", "is_cbo_default_on", "is_se_removal_guidance_dismissed", "last_used_post_format", "last_visited_time", "music_on_reels_opt_in", "muted_cbo_midflight_education_messages", "onsite_destination_optimization_opt_in", "open_tabs", "previously_seen_recommendations", "product_extensions_opt_in", "selected_ad_account", "selected_comparison_timerange", "selected_metric_cic", "selected_metrics_cic", "selected_page", "selected_page_section", "selected_power_editor_pane", "selected_stat_range", "should_export_filter_empty_cols", "should_export_rows_without_unsupported_feature", "should_not_auto_expand_tree_table", "should_not_show_cbo_campaign_toggle_off_confirmation_message", "should_not_show_publish_message_on_editor_close", "show_original_videos_opt_in", "static_ad_product_extensions_opt_in", "sticky_setting_after_default_on", "syd_campaign_trends_metric", "total_coupon_syd_dismissals", "total_coupon_upsell_dismissals", "url_prefill_removal_timestamp", "use_pe_create_flow", "use_stepper_primary_entry", "user"};

        @Override
        public AdsUserSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsUserSettings parseResponse(String response, String header) throws APIException {
            return AdsUserSettings.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsUserSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsUserSettings execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsUserSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsUserSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsUserSettings>(){

                public AdsUserSettings apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAPlusCSurveySeenField() {
            return this.requestAPlusCSurveySeenField(true);
        }

        public APIRequestGet requestAPlusCSurveySeenField(boolean value) {
            this.requestField("a_plus_c_survey_seen", value);
            return this;
        }

        public APIRequestGet requestAdgroupNameTemplateField() {
            return this.requestAdgroupNameTemplateField(true);
        }

        public APIRequestGet requestAdgroupNameTemplateField(boolean value) {
            this.requestField("adgroup_name_template", value);
            return this;
        }

        public APIRequestGet requestAdsCsCatalogOptOutTimestampField() {
            return this.requestAdsCsCatalogOptOutTimestampField(true);
        }

        public APIRequestGet requestAdsCsCatalogOptOutTimestampField(boolean value) {
            this.requestField("ads_cs_catalog_opt_out_timestamp", value);
            return this;
        }

        public APIRequestGet requestAdsToolVisitsField() {
            return this.requestAdsToolVisitsField(true);
        }

        public APIRequestGet requestAdsToolVisitsField(boolean value) {
            this.requestField("ads_tool_visits", value);
            return this;
        }

        public APIRequestGet requestApluscCarouselCdaOptInStatusField() {
            return this.requestApluscCarouselCdaOptInStatusField(true);
        }

        public APIRequestGet requestApluscCarouselCdaOptInStatusField(boolean value) {
            this.requestField("aplusc_carousel_cda_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestApluscCarouselInlineCommentOptInStatusField() {
            return this.requestApluscCarouselInlineCommentOptInStatusField(true);
        }

        public APIRequestGet requestApluscCarouselInlineCommentOptInStatusField(boolean value) {
            this.requestField("aplusc_carousel_inline_comment_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestApluscEpaOptInStatusField() {
            return this.requestApluscEpaOptInStatusField(true);
        }

        public APIRequestGet requestApluscEpaOptInStatusField(boolean value) {
            this.requestField("aplusc_epa_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestApluscOptOutFrictionField() {
            return this.requestApluscOptOutFrictionField(true);
        }

        public APIRequestGet requestApluscOptOutFrictionField(boolean value) {
            this.requestField("aplusc_opt_out_friction", value);
            return this;
        }

        public APIRequestGet requestAutoflowLiteOptInStatusField() {
            return this.requestAutoflowLiteOptInStatusField(true);
        }

        public APIRequestGet requestAutoflowLiteOptInStatusField(boolean value) {
            this.requestField("autoflow_lite_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestAutoflowLiteShouldOptInField() {
            return this.requestAutoflowLiteShouldOptInField(true);
        }

        public APIRequestGet requestAutoflowLiteShouldOptInField(boolean value) {
            this.requestField("autoflow_lite_should_opt_in", value);
            return this;
        }

        public APIRequestGet requestBlendedAdsCreationDefaultingOptInStatusField() {
            return this.requestBlendedAdsCreationDefaultingOptInStatusField(true);
        }

        public APIRequestGet requestBlendedAdsCreationDefaultingOptInStatusField(boolean value) {
            this.requestField("blended_ads_creation_defaulting_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestBlendedAdsCreationDefaultingOptOutCampaignGroupIdsField() {
            return this.requestBlendedAdsCreationDefaultingOptOutCampaignGroupIdsField(true);
        }

        public APIRequestGet requestBlendedAdsCreationDefaultingOptOutCampaignGroupIdsField(boolean value) {
            this.requestField("blended_ads_creation_defaulting_opt_out_campaign_group_ids", value);
            return this;
        }

        public APIRequestGet requestBookmarkedPagesField() {
            return this.requestBookmarkedPagesField(true);
        }

        public APIRequestGet requestBookmarkedPagesField(boolean value) {
            this.requestField("bookmarked_pages", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupNameTemplateField() {
            return this.requestCampaignGroupNameTemplateField(true);
        }

        public APIRequestGet requestCampaignGroupNameTemplateField(boolean value) {
            this.requestField("campaign_group_name_template", value);
            return this;
        }

        public APIRequestGet requestCampaignNameTemplateField() {
            return this.requestCampaignNameTemplateField(true);
        }

        public APIRequestGet requestCampaignNameTemplateField(boolean value) {
            this.requestField("campaign_name_template", value);
            return this;
        }

        public APIRequestGet requestCarouselToVideoOptInStatusField() {
            return this.requestCarouselToVideoOptInStatusField(true);
        }

        public APIRequestGet requestCarouselToVideoOptInStatusField(boolean value) {
            this.requestField("carousel_to_video_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestConnectedSourcesCatalogOptInStatusField() {
            return this.requestConnectedSourcesCatalogOptInStatusField(true);
        }

        public APIRequestGet requestConnectedSourcesCatalogOptInStatusField(boolean value) {
            this.requestField("connected_sources_catalog_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestDefaultCreationModeField() {
            return this.requestDefaultCreationModeField(true);
        }

        public APIRequestGet requestDefaultCreationModeField(boolean value) {
            this.requestField("default_creation_mode", value);
            return this;
        }

        public APIRequestGet requestExportFormatDefaultField() {
            return this.requestExportFormatDefaultField(true);
        }

        public APIRequestGet requestExportFormatDefaultField(boolean value) {
            this.requestField("export_format_default", value);
            return this;
        }

        public APIRequestGet requestFocusModeDefaultField() {
            return this.requestFocusModeDefaultField(true);
        }

        public APIRequestGet requestFocusModeDefaultField(boolean value) {
            this.requestField("focus_mode_default", value);
            return this;
        }

        public APIRequestGet requestGenAiAlphaTestStatusField() {
            return this.requestGenAiAlphaTestStatusField(true);
        }

        public APIRequestGet requestGenAiAlphaTestStatusField(boolean value) {
            this.requestField("gen_ai_alpha_test_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageExpansionOptInStatusField() {
            return this.requestImageExpansionOptInStatusField(true);
        }

        public APIRequestGet requestImageExpansionOptInStatusField(boolean value) {
            this.requestField("image_expansion_opt_in_status", value);
            return this;
        }

        public APIRequestGet requestIsAdsAiConsentedField() {
            return this.requestIsAdsAiConsentedField(true);
        }

        public APIRequestGet requestIsAdsAiConsentedField(boolean value) {
            this.requestField("is_ads_ai_consented", value);
            return this;
        }

        public APIRequestGet requestIsCboDefaultOnField() {
            return this.requestIsCboDefaultOnField(true);
        }

        public APIRequestGet requestIsCboDefaultOnField(boolean value) {
            this.requestField("is_cbo_default_on", value);
            return this;
        }

        public APIRequestGet requestIsSeRemovalGuidanceDismissedField() {
            return this.requestIsSeRemovalGuidanceDismissedField(true);
        }

        public APIRequestGet requestIsSeRemovalGuidanceDismissedField(boolean value) {
            this.requestField("is_se_removal_guidance_dismissed", value);
            return this;
        }

        public APIRequestGet requestLastUsedPostFormatField() {
            return this.requestLastUsedPostFormatField(true);
        }

        public APIRequestGet requestLastUsedPostFormatField(boolean value) {
            this.requestField("last_used_post_format", value);
            return this;
        }

        public APIRequestGet requestLastVisitedTimeField() {
            return this.requestLastVisitedTimeField(true);
        }

        public APIRequestGet requestLastVisitedTimeField(boolean value) {
            this.requestField("last_visited_time", value);
            return this;
        }

        public APIRequestGet requestMusicOnReelsOptInField() {
            return this.requestMusicOnReelsOptInField(true);
        }

        public APIRequestGet requestMusicOnReelsOptInField(boolean value) {
            this.requestField("music_on_reels_opt_in", value);
            return this;
        }

        public APIRequestGet requestMutedCboMidflightEducationMessagesField() {
            return this.requestMutedCboMidflightEducationMessagesField(true);
        }

        public APIRequestGet requestMutedCboMidflightEducationMessagesField(boolean value) {
            this.requestField("muted_cbo_midflight_education_messages", value);
            return this;
        }

        public APIRequestGet requestOnsiteDestinationOptimizationOptInField() {
            return this.requestOnsiteDestinationOptimizationOptInField(true);
        }

        public APIRequestGet requestOnsiteDestinationOptimizationOptInField(boolean value) {
            this.requestField("onsite_destination_optimization_opt_in", value);
            return this;
        }

        public APIRequestGet requestOpenTabsField() {
            return this.requestOpenTabsField(true);
        }

        public APIRequestGet requestOpenTabsField(boolean value) {
            this.requestField("open_tabs", value);
            return this;
        }

        public APIRequestGet requestPreviouslySeenRecommendationsField() {
            return this.requestPreviouslySeenRecommendationsField(true);
        }

        public APIRequestGet requestPreviouslySeenRecommendationsField(boolean value) {
            this.requestField("previously_seen_recommendations", value);
            return this;
        }

        public APIRequestGet requestProductExtensionsOptInField() {
            return this.requestProductExtensionsOptInField(true);
        }

        public APIRequestGet requestProductExtensionsOptInField(boolean value) {
            this.requestField("product_extensions_opt_in", value);
            return this;
        }

        public APIRequestGet requestSelectedAdAccountField() {
            return this.requestSelectedAdAccountField(true);
        }

        public APIRequestGet requestSelectedAdAccountField(boolean value) {
            this.requestField("selected_ad_account", value);
            return this;
        }

        public APIRequestGet requestSelectedComparisonTimerangeField() {
            return this.requestSelectedComparisonTimerangeField(true);
        }

        public APIRequestGet requestSelectedComparisonTimerangeField(boolean value) {
            this.requestField("selected_comparison_timerange", value);
            return this;
        }

        public APIRequestGet requestSelectedMetricCicField() {
            return this.requestSelectedMetricCicField(true);
        }

        public APIRequestGet requestSelectedMetricCicField(boolean value) {
            this.requestField("selected_metric_cic", value);
            return this;
        }

        public APIRequestGet requestSelectedMetricsCicField() {
            return this.requestSelectedMetricsCicField(true);
        }

        public APIRequestGet requestSelectedMetricsCicField(boolean value) {
            this.requestField("selected_metrics_cic", value);
            return this;
        }

        public APIRequestGet requestSelectedPageField() {
            return this.requestSelectedPageField(true);
        }

        public APIRequestGet requestSelectedPageField(boolean value) {
            this.requestField("selected_page", value);
            return this;
        }

        public APIRequestGet requestSelectedPageSectionField() {
            return this.requestSelectedPageSectionField(true);
        }

        public APIRequestGet requestSelectedPageSectionField(boolean value) {
            this.requestField("selected_page_section", value);
            return this;
        }

        public APIRequestGet requestSelectedPowerEditorPaneField() {
            return this.requestSelectedPowerEditorPaneField(true);
        }

        public APIRequestGet requestSelectedPowerEditorPaneField(boolean value) {
            this.requestField("selected_power_editor_pane", value);
            return this;
        }

        public APIRequestGet requestSelectedStatRangeField() {
            return this.requestSelectedStatRangeField(true);
        }

        public APIRequestGet requestSelectedStatRangeField(boolean value) {
            this.requestField("selected_stat_range", value);
            return this;
        }

        public APIRequestGet requestShouldExportFilterEmptyColsField() {
            return this.requestShouldExportFilterEmptyColsField(true);
        }

        public APIRequestGet requestShouldExportFilterEmptyColsField(boolean value) {
            this.requestField("should_export_filter_empty_cols", value);
            return this;
        }

        public APIRequestGet requestShouldExportRowsWithoutUnsupportedFeatureField() {
            return this.requestShouldExportRowsWithoutUnsupportedFeatureField(true);
        }

        public APIRequestGet requestShouldExportRowsWithoutUnsupportedFeatureField(boolean value) {
            this.requestField("should_export_rows_without_unsupported_feature", value);
            return this;
        }

        public APIRequestGet requestShouldNotAutoExpandTreeTableField() {
            return this.requestShouldNotAutoExpandTreeTableField(true);
        }

        public APIRequestGet requestShouldNotAutoExpandTreeTableField(boolean value) {
            this.requestField("should_not_auto_expand_tree_table", value);
            return this;
        }

        public APIRequestGet requestShouldNotShowCboCampaignToggleOffConfirmationMessageField() {
            return this.requestShouldNotShowCboCampaignToggleOffConfirmationMessageField(true);
        }

        public APIRequestGet requestShouldNotShowCboCampaignToggleOffConfirmationMessageField(boolean value) {
            this.requestField("should_not_show_cbo_campaign_toggle_off_confirmation_message", value);
            return this;
        }

        public APIRequestGet requestShouldNotShowPublishMessageOnEditorCloseField() {
            return this.requestShouldNotShowPublishMessageOnEditorCloseField(true);
        }

        public APIRequestGet requestShouldNotShowPublishMessageOnEditorCloseField(boolean value) {
            this.requestField("should_not_show_publish_message_on_editor_close", value);
            return this;
        }

        public APIRequestGet requestShowOriginalVideosOptInField() {
            return this.requestShowOriginalVideosOptInField(true);
        }

        public APIRequestGet requestShowOriginalVideosOptInField(boolean value) {
            this.requestField("show_original_videos_opt_in", value);
            return this;
        }

        public APIRequestGet requestStaticAdProductExtensionsOptInField() {
            return this.requestStaticAdProductExtensionsOptInField(true);
        }

        public APIRequestGet requestStaticAdProductExtensionsOptInField(boolean value) {
            this.requestField("static_ad_product_extensions_opt_in", value);
            return this;
        }

        public APIRequestGet requestStickySettingAfterDefaultOnField() {
            return this.requestStickySettingAfterDefaultOnField(true);
        }

        public APIRequestGet requestStickySettingAfterDefaultOnField(boolean value) {
            this.requestField("sticky_setting_after_default_on", value);
            return this;
        }

        public APIRequestGet requestSydCampaignTrendsMetricField() {
            return this.requestSydCampaignTrendsMetricField(true);
        }

        public APIRequestGet requestSydCampaignTrendsMetricField(boolean value) {
            this.requestField("syd_campaign_trends_metric", value);
            return this;
        }

        public APIRequestGet requestTotalCouponSydDismissalsField() {
            return this.requestTotalCouponSydDismissalsField(true);
        }

        public APIRequestGet requestTotalCouponSydDismissalsField(boolean value) {
            this.requestField("total_coupon_syd_dismissals", value);
            return this;
        }

        public APIRequestGet requestTotalCouponUpsellDismissalsField() {
            return this.requestTotalCouponUpsellDismissalsField(true);
        }

        public APIRequestGet requestTotalCouponUpsellDismissalsField(boolean value) {
            this.requestField("total_coupon_upsell_dismissals", value);
            return this;
        }

        public APIRequestGet requestUrlPrefillRemovalTimestampField() {
            return this.requestUrlPrefillRemovalTimestampField(true);
        }

        public APIRequestGet requestUrlPrefillRemovalTimestampField(boolean value) {
            this.requestField("url_prefill_removal_timestamp", value);
            return this;
        }

        public APIRequestGet requestUsePeCreateFlowField() {
            return this.requestUsePeCreateFlowField(true);
        }

        public APIRequestGet requestUsePeCreateFlowField(boolean value) {
            this.requestField("use_pe_create_flow", value);
            return this;
        }

        public APIRequestGet requestUseStepperPrimaryEntryField() {
            return this.requestUseStepperPrimaryEntryField(true);
        }

        public APIRequestGet requestUseStepperPrimaryEntryField(boolean value) {
            this.requestField("use_stepper_primary_entry", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }
}

