/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class IGMediaForIGOnlyAPI
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_shared_to_feed")
    private Boolean mIsSharedToFeed = null;
    @SerializedName(value="like_count")
    private Long mLikeCount = null;
    @SerializedName(value="media_product_type")
    private String mMediaProductType = null;
    @SerializedName(value="media_type")
    private String mMediaType = null;
    @SerializedName(value="media_url")
    private String mMediaUrl = null;
    @SerializedName(value="owner")
    private User mOwner = null;
    @SerializedName(value="permalink")
    private String mPermalink = null;
    @SerializedName(value="shortcode")
    private String mShortcode = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    IGMediaForIGOnlyAPI() {
    }

    public IGMediaForIGOnlyAPI(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public IGMediaForIGOnlyAPI(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public IGMediaForIGOnlyAPI fetch() throws APIException {
        IGMediaForIGOnlyAPI newInstance = IGMediaForIGOnlyAPI.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static IGMediaForIGOnlyAPI fetchById(Long id, APIContext context) throws APIException {
        return IGMediaForIGOnlyAPI.fetchById(id.toString(), context);
    }

    public static ListenableFuture<IGMediaForIGOnlyAPI> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return IGMediaForIGOnlyAPI.fetchByIdAsync(id.toString(), context);
    }

    public static IGMediaForIGOnlyAPI fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<IGMediaForIGOnlyAPI> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<IGMediaForIGOnlyAPI> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<IGMediaForIGOnlyAPI>(context, "", "/", "GET", IGMediaForIGOnlyAPI.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<IGMediaForIGOnlyAPI>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<IGMediaForIGOnlyAPI>(context, "", "/", "GET", IGMediaForIGOnlyAPI.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static IGMediaForIGOnlyAPI loadJSON(String json, APIContext context, String header) {
        IGMediaForIGOnlyAPI igMediaForIGOnlyAPI = (IGMediaForIGOnlyAPI)IGMediaForIGOnlyAPI.getGson().fromJson(json, IGMediaForIGOnlyAPI.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(igMediaForIGOnlyAPI.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        igMediaForIGOnlyAPI.context = context;
        igMediaForIGOnlyAPI.rawValue = json;
        igMediaForIGOnlyAPI.header = header;
        return igMediaForIGOnlyAPI;
    }

    public static APINodeList<IGMediaForIGOnlyAPI> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<IGMediaForIGOnlyAPI> igMediaForIGOnlyAPIs = new APINodeList<IGMediaForIGOnlyAPI>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return igMediaForIGOnlyAPIs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            igMediaForIGOnlyAPIs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        igMediaForIGOnlyAPIs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            igMediaForIGOnlyAPIs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return igMediaForIGOnlyAPIs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return igMediaForIGOnlyAPIs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return igMediaForIGOnlyAPIs;
                }
                igMediaForIGOnlyAPIs.clear();
                igMediaForIGOnlyAPIs.add(IGMediaForIGOnlyAPI.loadJSON(json, context, header));
                return igMediaForIGOnlyAPIs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return IGMediaForIGOnlyAPI.getGson().toJson((Object)this);
    }

    public APIRequestGetChildren getChildren() {
        return new APIRequestGetChildren(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsSharedToFeed() {
        return this.mIsSharedToFeed;
    }

    public Long getFieldLikeCount() {
        return this.mLikeCount;
    }

    public String getFieldMediaProductType() {
        return this.mMediaProductType;
    }

    public String getFieldMediaType() {
        return this.mMediaType;
    }

    public String getFieldMediaUrl() {
        return this.mMediaUrl;
    }

    public User getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public String getFieldPermalink() {
        return this.mPermalink;
    }

    public String getFieldShortcode() {
        return this.mShortcode;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public IGMediaForIGOnlyAPI copyFrom(IGMediaForIGOnlyAPI instance) {
        this.mCaption = instance.mCaption;
        this.mId = instance.mId;
        this.mIsSharedToFeed = instance.mIsSharedToFeed;
        this.mLikeCount = instance.mLikeCount;
        this.mMediaProductType = instance.mMediaProductType;
        this.mMediaType = instance.mMediaType;
        this.mMediaUrl = instance.mMediaUrl;
        this.mOwner = instance.mOwner;
        this.mPermalink = instance.mPermalink;
        this.mShortcode = instance.mShortcode;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mTimestamp = instance.mTimestamp;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<IGMediaForIGOnlyAPI> getParser() {
        return new APIRequest.ResponseParser<IGMediaForIGOnlyAPI>(){

            @Override
            public APINodeList<IGMediaForIGOnlyAPI> parseResponse(String response, APIContext context, APIRequest<IGMediaForIGOnlyAPI> request, String header) throws APIException.MalformedResponseException {
                return IGMediaForIGOnlyAPI.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<IGMediaForIGOnlyAPI> {
        IGMediaForIGOnlyAPI lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "id", "is_shared_to_feed", "like_count", "media_product_type", "media_type", "media_url", "owner", "permalink", "shortcode", "thumbnail_url", "timestamp", "username"};

        @Override
        public IGMediaForIGOnlyAPI getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public IGMediaForIGOnlyAPI parseResponse(String response, String header) throws APIException {
            return IGMediaForIGOnlyAPI.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public IGMediaForIGOnlyAPI execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public IGMediaForIGOnlyAPI execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<IGMediaForIGOnlyAPI> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<IGMediaForIGOnlyAPI> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, IGMediaForIGOnlyAPI>(){

                public IGMediaForIGOnlyAPI apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsSharedToFeedField() {
            return this.requestIsSharedToFeedField(true);
        }

        public APIRequestGet requestIsSharedToFeedField(boolean value) {
            this.requestField("is_shared_to_feed", value);
            return this;
        }

        public APIRequestGet requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGet requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGet requestMediaProductTypeField() {
            return this.requestMediaProductTypeField(true);
        }

        public APIRequestGet requestMediaProductTypeField(boolean value) {
            this.requestField("media_product_type", value);
            return this;
        }

        public APIRequestGet requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGet requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGet requestMediaUrlField() {
            return this.requestMediaUrlField(true);
        }

        public APIRequestGet requestMediaUrlField(boolean value) {
            this.requestField("media_url", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGet requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGet requestShortcodeField() {
            return this.requestShortcodeField(true);
        }

        public APIRequestGet requestShortcodeField(boolean value) {
            this.requestField("shortcode", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    public static class APIRequestGetChildren
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetChildren(String nodeId, APIContext context) {
            super(context, nodeId, "/children", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChildren setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChildren setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChildren requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChildren requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChildren requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChildren requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChildren requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChildren requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

