/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdsPixelRawFiresResult
extends APINode {
    @SerializedName(value="data_json")
    private String mDataJson = null;
    @SerializedName(value="device_type")
    private String mDeviceType = null;
    @SerializedName(value="event")
    private String mEvent = null;
    @SerializedName(value="event_detection_method")
    private String mEventDetectionMethod = null;
    @SerializedName(value="event_src")
    private String mEventSrc = null;
    @SerializedName(value="placed_url")
    private String mPlacedUrl = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="user_pii_keys")
    private String mUserPiiKeys = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdsPixelRawFiresResult loadJSON(String json, APIContext context, String header) {
        AdsPixelRawFiresResult adsPixelRawFiresResult = (AdsPixelRawFiresResult)AdsPixelRawFiresResult.getGson().fromJson(json, AdsPixelRawFiresResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixelRawFiresResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixelRawFiresResult.context = context;
        adsPixelRawFiresResult.rawValue = json;
        adsPixelRawFiresResult.header = header;
        return adsPixelRawFiresResult;
    }

    public static APINodeList<AdsPixelRawFiresResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixelRawFiresResult> adsPixelRawFiresResults = new APINodeList<AdsPixelRawFiresResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsPixelRawFiresResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixelRawFiresResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixelRawFiresResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixelRawFiresResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsPixelRawFiresResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsPixelRawFiresResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixelRawFiresResults;
                }
                adsPixelRawFiresResults.clear();
                adsPixelRawFiresResults.add(AdsPixelRawFiresResult.loadJSON(json, context, header));
                return adsPixelRawFiresResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixelRawFiresResult.getGson().toJson((Object)this);
    }

    public String getFieldDataJson() {
        return this.mDataJson;
    }

    public AdsPixelRawFiresResult setFieldDataJson(String value) {
        this.mDataJson = value;
        return this;
    }

    public String getFieldDeviceType() {
        return this.mDeviceType;
    }

    public AdsPixelRawFiresResult setFieldDeviceType(String value) {
        this.mDeviceType = value;
        return this;
    }

    public String getFieldEvent() {
        return this.mEvent;
    }

    public AdsPixelRawFiresResult setFieldEvent(String value) {
        this.mEvent = value;
        return this;
    }

    public String getFieldEventDetectionMethod() {
        return this.mEventDetectionMethod;
    }

    public AdsPixelRawFiresResult setFieldEventDetectionMethod(String value) {
        this.mEventDetectionMethod = value;
        return this;
    }

    public String getFieldEventSrc() {
        return this.mEventSrc;
    }

    public AdsPixelRawFiresResult setFieldEventSrc(String value) {
        this.mEventSrc = value;
        return this;
    }

    public String getFieldPlacedUrl() {
        return this.mPlacedUrl;
    }

    public AdsPixelRawFiresResult setFieldPlacedUrl(String value) {
        this.mPlacedUrl = value;
        return this;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public AdsPixelRawFiresResult setFieldTimestamp(String value) {
        this.mTimestamp = value;
        return this;
    }

    public String getFieldUserPiiKeys() {
        return this.mUserPiiKeys;
    }

    public AdsPixelRawFiresResult setFieldUserPiiKeys(String value) {
        this.mUserPiiKeys = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixelRawFiresResult copyFrom(AdsPixelRawFiresResult instance) {
        this.mDataJson = instance.mDataJson;
        this.mDeviceType = instance.mDeviceType;
        this.mEvent = instance.mEvent;
        this.mEventDetectionMethod = instance.mEventDetectionMethod;
        this.mEventSrc = instance.mEventSrc;
        this.mPlacedUrl = instance.mPlacedUrl;
        this.mTimestamp = instance.mTimestamp;
        this.mUserPiiKeys = instance.mUserPiiKeys;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixelRawFiresResult> getParser() {
        return new APIRequest.ResponseParser<AdsPixelRawFiresResult>(){

            @Override
            public APINodeList<AdsPixelRawFiresResult> parseResponse(String response, APIContext context, APIRequest<AdsPixelRawFiresResult> request, String header) throws APIException.MalformedResponseException {
                return AdsPixelRawFiresResult.parseResponse(response, context, request, header);
            }
        };
    }
}

