/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdAccountDefaultObjective
extends APINode {
    @SerializedName(value="default_objective_for_user")
    private EnumDefaultObjectiveForUser mDefaultObjectiveForUser = null;
    @SerializedName(value="objective_for_level")
    private EnumObjectiveForLevel mObjectiveForLevel = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdAccountDefaultObjective loadJSON(String json, APIContext context, String header) {
        AdAccountDefaultObjective adAccountDefaultObjective = (AdAccountDefaultObjective)AdAccountDefaultObjective.getGson().fromJson(json, AdAccountDefaultObjective.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountDefaultObjective.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountDefaultObjective.context = context;
        adAccountDefaultObjective.rawValue = json;
        adAccountDefaultObjective.header = header;
        return adAccountDefaultObjective;
    }

    public static APINodeList<AdAccountDefaultObjective> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountDefaultObjective> adAccountDefaultObjectives = new APINodeList<AdAccountDefaultObjective>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountDefaultObjectives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountDefaultObjectives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountDefaultObjectives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountDefaultObjectives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountDefaultObjectives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountDefaultObjectives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountDefaultObjectives;
                }
                adAccountDefaultObjectives.clear();
                adAccountDefaultObjectives.add(AdAccountDefaultObjective.loadJSON(json, context, header));
                return adAccountDefaultObjectives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountDefaultObjective.getGson().toJson((Object)this);
    }

    public EnumDefaultObjectiveForUser getFieldDefaultObjectiveForUser() {
        return this.mDefaultObjectiveForUser;
    }

    public AdAccountDefaultObjective setFieldDefaultObjectiveForUser(EnumDefaultObjectiveForUser value) {
        this.mDefaultObjectiveForUser = value;
        return this;
    }

    public EnumObjectiveForLevel getFieldObjectiveForLevel() {
        return this.mObjectiveForLevel;
    }

    public AdAccountDefaultObjective setFieldObjectiveForLevel(EnumObjectiveForLevel value) {
        this.mObjectiveForLevel = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountDefaultObjective copyFrom(AdAccountDefaultObjective instance) {
        this.mDefaultObjectiveForUser = instance.mDefaultObjectiveForUser;
        this.mObjectiveForLevel = instance.mObjectiveForLevel;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountDefaultObjective> getParser() {
        return new APIRequest.ResponseParser<AdAccountDefaultObjective>(){

            @Override
            public APINodeList<AdAccountDefaultObjective> parseResponse(String response, APIContext context, APIRequest<AdAccountDefaultObjective> request, String header) throws APIException.MalformedResponseException {
                return AdAccountDefaultObjective.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumObjectiveForLevel {
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_MESSAGES("MESSAGES"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_OUTCOME_APP_PROMOTION("OUTCOME_APP_PROMOTION"),
        VALUE_OUTCOME_AWARENESS("OUTCOME_AWARENESS"),
        VALUE_OUTCOME_ENGAGEMENT("OUTCOME_ENGAGEMENT"),
        VALUE_OUTCOME_LEADS("OUTCOME_LEADS"),
        VALUE_OUTCOME_SALES("OUTCOME_SALES"),
        VALUE_OUTCOME_TRAFFIC("OUTCOME_TRAFFIC"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_REACH("REACH"),
        VALUE_STORE_VISITS("STORE_VISITS"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        VALUE_WEBSITE_CONVERSIONS("WEBSITE_CONVERSIONS");

        private String value;

        private EnumObjectiveForLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDefaultObjectiveForUser {
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_MESSAGES("MESSAGES"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_OUTCOME_APP_PROMOTION("OUTCOME_APP_PROMOTION"),
        VALUE_OUTCOME_AWARENESS("OUTCOME_AWARENESS"),
        VALUE_OUTCOME_ENGAGEMENT("OUTCOME_ENGAGEMENT"),
        VALUE_OUTCOME_LEADS("OUTCOME_LEADS"),
        VALUE_OUTCOME_SALES("OUTCOME_SALES"),
        VALUE_OUTCOME_TRAFFIC("OUTCOME_TRAFFIC"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_REACH("REACH"),
        VALUE_STORE_VISITS("STORE_VISITS"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        VALUE_WEBSITE_CONVERSIONS("WEBSITE_CONVERSIONS");

        private String value;

        private EnumDefaultObjectiveForUser(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

