/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ResellerGuidance
extends APINode {
    @SerializedName(value="ad_account_first_spend_date")
    private String mAdAccountFirstSpendDate = null;
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="adopted_guidance_l7d")
    private List<String> mAdoptedGuidanceL7d = null;
    @SerializedName(value="advertiser_name")
    private String mAdvertiserName = null;
    @SerializedName(value="attributed_to_reseller_l7d")
    private Boolean mAttributedToResellerL7d = null;
    @SerializedName(value="available_guidance")
    private List<String> mAvailableGuidance = null;
    @SerializedName(value="benchmark_report_link")
    private String mBenchmarkReportLink = null;
    @SerializedName(value="guidance_adoption_rate_l7d")
    private Double mGuidanceAdoptionRateL7d = null;
    @SerializedName(value="no_adsets_gte_benchmark")
    private Long mNoAdsetsGteBenchmark = null;
    @SerializedName(value="no_adsets_lt_benchmark")
    private Long mNoAdsetsLtBenchmark = null;
    @SerializedName(value="nurtured_by_reseller_l7d")
    private Boolean mNurturedByResellerL7d = null;
    @SerializedName(value="planning_agency_name")
    private String mPlanningAgencyName = null;
    @SerializedName(value="recommendation_time")
    private String mRecommendationTime = null;
    @SerializedName(value="reporting_ds")
    private String mReportingDs = null;
    @SerializedName(value="reseller")
    private Business mReseller = null;
    @SerializedName(value="revenue_l30d")
    private Double mRevenueL30d = null;
    @SerializedName(value="ultimate_advertiser_name")
    private String mUltimateAdvertiserName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ResellerGuidance loadJSON(String json, APIContext context, String header) {
        ResellerGuidance resellerGuidance = (ResellerGuidance)ResellerGuidance.getGson().fromJson(json, ResellerGuidance.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(resellerGuidance.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        resellerGuidance.context = context;
        resellerGuidance.rawValue = json;
        resellerGuidance.header = header;
        return resellerGuidance;
    }

    public static APINodeList<ResellerGuidance> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ResellerGuidance> resellerGuidances = new APINodeList<ResellerGuidance>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        resellerGuidances.add(ResellerGuidance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return resellerGuidances;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            resellerGuidances.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        resellerGuidances.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            resellerGuidances.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            resellerGuidances.add(ResellerGuidance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                resellerGuidances.add(ResellerGuidance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            resellerGuidances.add(ResellerGuidance.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return resellerGuidances;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        resellerGuidances.add(ResellerGuidance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return resellerGuidances;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        resellerGuidances.add(ResellerGuidance.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return resellerGuidances;
                }
                resellerGuidances.clear();
                resellerGuidances.add(ResellerGuidance.loadJSON(json, context, header));
                return resellerGuidances;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ResellerGuidance.getGson().toJson((Object)this);
    }

    public String getFieldAdAccountFirstSpendDate() {
        return this.mAdAccountFirstSpendDate;
    }

    public ResellerGuidance setFieldAdAccountFirstSpendDate(String value) {
        this.mAdAccountFirstSpendDate = value;
        return this;
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public ResellerGuidance setFieldAdAccountId(String value) {
        this.mAdAccountId = value;
        return this;
    }

    public List<String> getFieldAdoptedGuidanceL7d() {
        return this.mAdoptedGuidanceL7d;
    }

    public ResellerGuidance setFieldAdoptedGuidanceL7d(List<String> value) {
        this.mAdoptedGuidanceL7d = value;
        return this;
    }

    public String getFieldAdvertiserName() {
        return this.mAdvertiserName;
    }

    public ResellerGuidance setFieldAdvertiserName(String value) {
        this.mAdvertiserName = value;
        return this;
    }

    public Boolean getFieldAttributedToResellerL7d() {
        return this.mAttributedToResellerL7d;
    }

    public ResellerGuidance setFieldAttributedToResellerL7d(Boolean value) {
        this.mAttributedToResellerL7d = value;
        return this;
    }

    public List<String> getFieldAvailableGuidance() {
        return this.mAvailableGuidance;
    }

    public ResellerGuidance setFieldAvailableGuidance(List<String> value) {
        this.mAvailableGuidance = value;
        return this;
    }

    public String getFieldBenchmarkReportLink() {
        return this.mBenchmarkReportLink;
    }

    public ResellerGuidance setFieldBenchmarkReportLink(String value) {
        this.mBenchmarkReportLink = value;
        return this;
    }

    public Double getFieldGuidanceAdoptionRateL7d() {
        return this.mGuidanceAdoptionRateL7d;
    }

    public ResellerGuidance setFieldGuidanceAdoptionRateL7d(Double value) {
        this.mGuidanceAdoptionRateL7d = value;
        return this;
    }

    public Long getFieldNoAdsetsGteBenchmark() {
        return this.mNoAdsetsGteBenchmark;
    }

    public ResellerGuidance setFieldNoAdsetsGteBenchmark(Long value) {
        this.mNoAdsetsGteBenchmark = value;
        return this;
    }

    public Long getFieldNoAdsetsLtBenchmark() {
        return this.mNoAdsetsLtBenchmark;
    }

    public ResellerGuidance setFieldNoAdsetsLtBenchmark(Long value) {
        this.mNoAdsetsLtBenchmark = value;
        return this;
    }

    public Boolean getFieldNurturedByResellerL7d() {
        return this.mNurturedByResellerL7d;
    }

    public ResellerGuidance setFieldNurturedByResellerL7d(Boolean value) {
        this.mNurturedByResellerL7d = value;
        return this;
    }

    public String getFieldPlanningAgencyName() {
        return this.mPlanningAgencyName;
    }

    public ResellerGuidance setFieldPlanningAgencyName(String value) {
        this.mPlanningAgencyName = value;
        return this;
    }

    public String getFieldRecommendationTime() {
        return this.mRecommendationTime;
    }

    public ResellerGuidance setFieldRecommendationTime(String value) {
        this.mRecommendationTime = value;
        return this;
    }

    public String getFieldReportingDs() {
        return this.mReportingDs;
    }

    public ResellerGuidance setFieldReportingDs(String value) {
        this.mReportingDs = value;
        return this;
    }

    public Business getFieldReseller() {
        if (this.mReseller != null) {
            this.mReseller.context = this.getContext();
        }
        return this.mReseller;
    }

    public ResellerGuidance setFieldReseller(Business value) {
        this.mReseller = value;
        return this;
    }

    public ResellerGuidance setFieldReseller(String value) {
        Type type = new TypeToken<Business>(){}.getType();
        this.mReseller = (Business)Business.getGson().fromJson(value, type);
        return this;
    }

    public Double getFieldRevenueL30d() {
        return this.mRevenueL30d;
    }

    public ResellerGuidance setFieldRevenueL30d(Double value) {
        this.mRevenueL30d = value;
        return this;
    }

    public String getFieldUltimateAdvertiserName() {
        return this.mUltimateAdvertiserName;
    }

    public ResellerGuidance setFieldUltimateAdvertiserName(String value) {
        this.mUltimateAdvertiserName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ResellerGuidance copyFrom(ResellerGuidance instance) {
        this.mAdAccountFirstSpendDate = instance.mAdAccountFirstSpendDate;
        this.mAdAccountId = instance.mAdAccountId;
        this.mAdoptedGuidanceL7d = instance.mAdoptedGuidanceL7d;
        this.mAdvertiserName = instance.mAdvertiserName;
        this.mAttributedToResellerL7d = instance.mAttributedToResellerL7d;
        this.mAvailableGuidance = instance.mAvailableGuidance;
        this.mBenchmarkReportLink = instance.mBenchmarkReportLink;
        this.mGuidanceAdoptionRateL7d = instance.mGuidanceAdoptionRateL7d;
        this.mNoAdsetsGteBenchmark = instance.mNoAdsetsGteBenchmark;
        this.mNoAdsetsLtBenchmark = instance.mNoAdsetsLtBenchmark;
        this.mNurturedByResellerL7d = instance.mNurturedByResellerL7d;
        this.mPlanningAgencyName = instance.mPlanningAgencyName;
        this.mRecommendationTime = instance.mRecommendationTime;
        this.mReportingDs = instance.mReportingDs;
        this.mReseller = instance.mReseller;
        this.mRevenueL30d = instance.mRevenueL30d;
        this.mUltimateAdvertiserName = instance.mUltimateAdvertiserName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ResellerGuidance> getParser() {
        return new APIRequest.ResponseParser<ResellerGuidance>(){

            @Override
            public APINodeList<ResellerGuidance> parseResponse(String response, APIContext context, APIRequest<ResellerGuidance> request, String header) throws APIException.MalformedResponseException {
                return ResellerGuidance.parseResponse(response, context, request, header);
            }
        };
    }
}

