/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramComment;
import com.facebook.ads.sdk.InstagramUser;
import com.facebook.ads.sdk.Location;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class InstagramMedia
extends APINode {
    @SerializedName(value="caption_text")
    private String mCaptionText = null;
    @SerializedName(value="comment_count")
    private Long mCommentCount = null;
    @SerializedName(value="content_type")
    private Long mContentType = null;
    @SerializedName(value="display_url")
    private String mDisplayUrl = null;
    @SerializedName(value="filter_name")
    private String mFilterName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="latitude")
    private Double mLatitude = null;
    @SerializedName(value="like_count")
    private Long mLikeCount = null;
    @SerializedName(value="location")
    private Location mLocation = null;
    @SerializedName(value="location_name")
    private String mLocationName = null;
    @SerializedName(value="longitude")
    private Double mLongitude = null;
    @SerializedName(value="owner_instagram_user")
    private InstagramUser mOwnerInstagramUser = null;
    @SerializedName(value="permalink")
    private String mPermalink = null;
    @SerializedName(value="taken_at")
    private String mTakenAt = null;
    @SerializedName(value="video_url")
    private String mVideoUrl = null;
    protected static Gson gson = null;

    InstagramMedia() {
    }

    public InstagramMedia(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramMedia(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramMedia fetch() throws APIException {
        InstagramMedia newInstance = InstagramMedia.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramMedia fetchById(Long id, APIContext context) throws APIException {
        return InstagramMedia.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramMedia> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramMedia.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramMedia fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramMedia> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramMedia> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramMedia>(context, "", "/", "GET", InstagramMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramMedia>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramMedia>(context, "", "/", "GET", InstagramMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramMedia loadJSON(String json, APIContext context, String header) {
        InstagramMedia instagramMedia = (InstagramMedia)InstagramMedia.getGson().fromJson(json, InstagramMedia.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramMedia.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramMedia.context = context;
        instagramMedia.rawValue = json;
        instagramMedia.header = header;
        return instagramMedia;
    }

    public static APINodeList<InstagramMedia> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramMedia> instagramMedias = new APINodeList<InstagramMedia>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramMedias.add(InstagramMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instagramMedias;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramMedias.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramMedias.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramMedias.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramMedias.add(InstagramMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramMedias.add(InstagramMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramMedias.add(InstagramMedia.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instagramMedias;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramMedias.add(InstagramMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instagramMedias;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramMedias.add(InstagramMedia.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramMedias;
                }
                instagramMedias.clear();
                instagramMedias.add(InstagramMedia.loadJSON(json, context, header));
                return instagramMedias;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramMedia.getGson().toJson((Object)this);
    }

    public APIRequestGetComments getComments() {
        return new APIRequestGetComments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaptionText() {
        return this.mCaptionText;
    }

    public Long getFieldCommentCount() {
        return this.mCommentCount;
    }

    public Long getFieldContentType() {
        return this.mContentType;
    }

    public String getFieldDisplayUrl() {
        return this.mDisplayUrl;
    }

    public String getFieldFilterName() {
        return this.mFilterName;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Double getFieldLatitude() {
        return this.mLatitude;
    }

    public Long getFieldLikeCount() {
        return this.mLikeCount;
    }

    public Location getFieldLocation() {
        return this.mLocation;
    }

    public String getFieldLocationName() {
        return this.mLocationName;
    }

    public Double getFieldLongitude() {
        return this.mLongitude;
    }

    public InstagramUser getFieldOwnerInstagramUser() {
        if (this.mOwnerInstagramUser != null) {
            this.mOwnerInstagramUser.context = this.getContext();
        }
        return this.mOwnerInstagramUser;
    }

    public String getFieldPermalink() {
        return this.mPermalink;
    }

    public String getFieldTakenAt() {
        return this.mTakenAt;
    }

    public String getFieldVideoUrl() {
        return this.mVideoUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramMedia copyFrom(InstagramMedia instance) {
        this.mCaptionText = instance.mCaptionText;
        this.mCommentCount = instance.mCommentCount;
        this.mContentType = instance.mContentType;
        this.mDisplayUrl = instance.mDisplayUrl;
        this.mFilterName = instance.mFilterName;
        this.mId = instance.mId;
        this.mLatitude = instance.mLatitude;
        this.mLikeCount = instance.mLikeCount;
        this.mLocation = instance.mLocation;
        this.mLocationName = instance.mLocationName;
        this.mLongitude = instance.mLongitude;
        this.mOwnerInstagramUser = instance.mOwnerInstagramUser;
        this.mPermalink = instance.mPermalink;
        this.mTakenAt = instance.mTakenAt;
        this.mVideoUrl = instance.mVideoUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramMedia> getParser() {
        return new APIRequest.ResponseParser<InstagramMedia>(){

            @Override
            public APINodeList<InstagramMedia> parseResponse(String response, APIContext context, APIRequest<InstagramMedia> request, String header) throws APIException.MalformedResponseException {
                return InstagramMedia.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<InstagramMedia> {
        InstagramMedia lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption_text", "comment_count", "content_type", "display_url", "filter_name", "id", "latitude", "like_count", "location", "location_name", "longitude", "owner_instagram_user", "permalink", "taken_at", "video_url"};

        @Override
        public InstagramMedia getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramMedia parseResponse(String response, String header) throws APIException {
            return InstagramMedia.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramMedia execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramMedia execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramMedia> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramMedia> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramMedia>(){

                public InstagramMedia apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionTextField() {
            return this.requestCaptionTextField(true);
        }

        public APIRequestGet requestCaptionTextField(boolean value) {
            this.requestField("caption_text", value);
            return this;
        }

        public APIRequestGet requestCommentCountField() {
            return this.requestCommentCountField(true);
        }

        public APIRequestGet requestCommentCountField(boolean value) {
            this.requestField("comment_count", value);
            return this;
        }

        public APIRequestGet requestContentTypeField() {
            return this.requestContentTypeField(true);
        }

        public APIRequestGet requestContentTypeField(boolean value) {
            this.requestField("content_type", value);
            return this;
        }

        public APIRequestGet requestDisplayUrlField() {
            return this.requestDisplayUrlField(true);
        }

        public APIRequestGet requestDisplayUrlField(boolean value) {
            this.requestField("display_url", value);
            return this;
        }

        public APIRequestGet requestFilterNameField() {
            return this.requestFilterNameField(true);
        }

        public APIRequestGet requestFilterNameField(boolean value) {
            this.requestField("filter_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLatitudeField() {
            return this.requestLatitudeField(true);
        }

        public APIRequestGet requestLatitudeField(boolean value) {
            this.requestField("latitude", value);
            return this;
        }

        public APIRequestGet requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGet requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestLocationNameField() {
            return this.requestLocationNameField(true);
        }

        public APIRequestGet requestLocationNameField(boolean value) {
            this.requestField("location_name", value);
            return this;
        }

        public APIRequestGet requestLongitudeField() {
            return this.requestLongitudeField(true);
        }

        public APIRequestGet requestLongitudeField(boolean value) {
            this.requestField("longitude", value);
            return this;
        }

        public APIRequestGet requestOwnerInstagramUserField() {
            return this.requestOwnerInstagramUserField(true);
        }

        public APIRequestGet requestOwnerInstagramUserField(boolean value) {
            this.requestField("owner_instagram_user", value);
            return this;
        }

        public APIRequestGet requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGet requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGet requestTakenAtField() {
            return this.requestTakenAtField(true);
        }

        public APIRequestGet requestTakenAtField(boolean value) {
            this.requestField("taken_at", value);
            return this;
        }

        public APIRequestGet requestVideoUrlField() {
            return this.requestVideoUrlField(true);
        }

        public APIRequestGet requestVideoUrlField(boolean value) {
            this.requestField("video_url", value);
            return this;
        }
    }

    public static class APIRequestCreateComment
    extends APIRequest<InstagramComment> {
        InstagramComment lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_id", "message"};
        public static final String[] FIELDS = new String[0];

        @Override
        public InstagramComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramComment parseResponse(String response, String header) throws APIException {
            return InstagramComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramComment>(){

                public InstagramComment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setAdId(String adId) {
            this.setParam("ad_id", adId);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetComments
    extends APIRequest<InstagramComment> {
        APINodeList<InstagramComment> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"comment_type", "created_at", "id", "instagram_comment_id", "instagram_user", "mentioned_instagram_users", "message", "username"};

        @Override
        public APINodeList<InstagramComment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InstagramComment> parseResponse(String response, String header) throws APIException {
            return InstagramComment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InstagramComment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InstagramComment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InstagramComment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InstagramComment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InstagramComment>>(){

                public APINodeList<InstagramComment> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetComments(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetComments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetComments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetComments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetComments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetComments requestCommentTypeField() {
            return this.requestCommentTypeField(true);
        }

        public APIRequestGetComments requestCommentTypeField(boolean value) {
            this.requestField("comment_type", value);
            return this;
        }

        public APIRequestGetComments requestCreatedAtField() {
            return this.requestCreatedAtField(true);
        }

        public APIRequestGetComments requestCreatedAtField(boolean value) {
            this.requestField("created_at", value);
            return this;
        }

        public APIRequestGetComments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetComments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetComments requestInstagramCommentIdField() {
            return this.requestInstagramCommentIdField(true);
        }

        public APIRequestGetComments requestInstagramCommentIdField(boolean value) {
            this.requestField("instagram_comment_id", value);
            return this;
        }

        public APIRequestGetComments requestInstagramUserField() {
            return this.requestInstagramUserField(true);
        }

        public APIRequestGetComments requestInstagramUserField(boolean value) {
            this.requestField("instagram_user", value);
            return this;
        }

        public APIRequestGetComments requestMentionedInstagramUsersField() {
            return this.requestMentionedInstagramUsersField(true);
        }

        public APIRequestGetComments requestMentionedInstagramUsersField(boolean value) {
            this.requestField("mentioned_instagram_users", value);
            return this;
        }

        public APIRequestGetComments requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetComments requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetComments requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetComments requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }
}

