/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IosAppLink
extends APINode {
    @SerializedName(value="app_name")
    private String mAppName = null;
    @SerializedName(value="app_store_id")
    private String mAppStoreId = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static IosAppLink loadJSON(String json, APIContext context) {
        IosAppLink iosAppLink = (IosAppLink)IosAppLink.getGson().fromJson(json, IosAppLink.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(iosAppLink.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        iosAppLink.context = context;
        iosAppLink.rawValue = json;
        return iosAppLink;
    }

    public static APINodeList<IosAppLink> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<IosAppLink> iosAppLinks = new APINodeList<IosAppLink>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        iosAppLinks.add(IosAppLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return iosAppLinks;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        iosAppLinks.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            iosAppLinks.add(IosAppLink.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                iosAppLinks.add(IosAppLink.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            iosAppLinks.add(IosAppLink.loadJSON(obj.toString(), context));
                        }
                    }
                    return iosAppLinks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        iosAppLinks.add(IosAppLink.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return iosAppLinks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        iosAppLinks.add(IosAppLink.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return iosAppLinks;
                }
                iosAppLinks.clear();
                iosAppLinks.add(IosAppLink.loadJSON(json, context));
                return iosAppLinks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return IosAppLink.getGson().toJson((Object)this);
    }

    public String getFieldAppName() {
        return this.mAppName;
    }

    public IosAppLink setFieldAppName(String value) {
        this.mAppName = value;
        return this;
    }

    public String getFieldAppStoreId() {
        return this.mAppStoreId;
    }

    public IosAppLink setFieldAppStoreId(String value) {
        this.mAppStoreId = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public IosAppLink setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public IosAppLink copyFrom(IosAppLink instance) {
        this.mAppName = instance.mAppName;
        this.mAppStoreId = instance.mAppStoreId;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<IosAppLink> getParser() {
        return new APIRequest.ResponseParser<IosAppLink>(){

            @Override
            public APINodeList<IosAppLink> parseResponse(String response, APIContext context, APIRequest<IosAppLink> request) throws APIException.MalformedResponseException {
                return IosAppLink.parseResponse(response, context, request);
            }
        };
    }
}

