/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudyCell
extends APINode {
    @SerializedName(value="ad_entities_count")
    private Long mAdEntitiesCount = null;
    @SerializedName(value="control_percentage")
    private Double mControlPercentage = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="treatment_percentage")
    private Double mTreatmentPercentage = null;
    protected static Gson gson = null;

    AdStudyCell() {
    }

    public AdStudyCell(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudyCell(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudyCell fetch() throws APIException {
        AdStudyCell newInstance = AdStudyCell.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudyCell fetchById(Long id, APIContext context) throws APIException {
        return AdStudyCell.fetchById(id.toString(), context);
    }

    public static AdStudyCell fetchById(String id, APIContext context) throws APIException {
        AdStudyCell adStudyCell = new APIRequestGet(id, context).requestAllFields().execute();
        return adStudyCell;
    }

    public static APINodeList<AdStudyCell> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudyCell>(context, "", "/", "GET", AdStudyCell.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudyCell loadJSON(String json, APIContext context) {
        AdStudyCell adStudyCell = (AdStudyCell)AdStudyCell.getGson().fromJson(json, AdStudyCell.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudyCell.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudyCell.context = context;
        adStudyCell.rawValue = json;
        return adStudyCell;
    }

    public static APINodeList<AdStudyCell> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdStudyCell> adStudyCells = new APINodeList<AdStudyCell>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudyCells.add(AdStudyCell.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adStudyCells;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adStudyCells.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudyCells.add(AdStudyCell.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudyCells.add(AdStudyCell.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudyCells.add(AdStudyCell.loadJSON(obj.toString(), context));
                        }
                    }
                    return adStudyCells;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudyCells.add(AdStudyCell.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adStudyCells;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudyCells.add(AdStudyCell.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudyCells;
                }
                adStudyCells.clear();
                adStudyCells.add(AdStudyCell.loadJSON(json, context));
                return adStudyCells;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudyCell.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAdEntitiesCount() {
        return this.mAdEntitiesCount;
    }

    public Double getFieldControlPercentage() {
        return this.mControlPercentage;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Double getFieldTreatmentPercentage() {
        return this.mTreatmentPercentage;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudyCell copyFrom(AdStudyCell instance) {
        this.mAdEntitiesCount = instance.mAdEntitiesCount;
        this.mControlPercentage = instance.mControlPercentage;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mTreatmentPercentage = instance.mTreatmentPercentage;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudyCell> getParser() {
        return new APIRequest.ResponseParser<AdStudyCell>(){

            @Override
            public APINodeList<AdStudyCell> parseResponse(String response, APIContext context, APIRequest<AdStudyCell> request) throws APIException.MalformedResponseException {
                return AdStudyCell.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudyCell> {
        AdStudyCell lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_entities_count", "control_percentage", "id", "name", "treatment_percentage"};

        @Override
        public AdStudyCell getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyCell parseResponse(String response) throws APIException {
            return AdStudyCell.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyCell execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyCell execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdEntitiesCountField() {
            return this.requestAdEntitiesCountField(true);
        }

        public APIRequestGet requestAdEntitiesCountField(boolean value) {
            this.requestField("ad_entities_count", value);
            return this;
        }

        public APIRequestGet requestControlPercentageField() {
            return this.requestControlPercentageField(true);
        }

        public APIRequestGet requestControlPercentageField(boolean value) {
            this.requestField("control_percentage", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestTreatmentPercentageField() {
            return this.requestTreatmentPercentageField(true);
        }

        public APIRequestGet requestTreatmentPercentageField(boolean value) {
            this.requestField("treatment_percentage", value);
            return this;
        }
    }
}

