/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpec;
import com.facebook.ads.sdk.AdCreativeObjectStorySpec;
import com.facebook.ads.sdk.AdLabel;
import com.facebook.ads.sdk.AdPreview;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreative
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="actor_id")
    private String mActorId = null;
    @SerializedName(value="adlabels")
    private List<AdLabel> mAdlabels = null;
    @SerializedName(value="applink_treatment")
    private EnumApplinkTreatment mApplinkTreatment = null;
    @SerializedName(value="asset_feed_spec")
    private AdAssetFeedSpec mAssetFeedSpec = null;
    @SerializedName(value="body")
    private String mBody = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="call_to_action_type")
    private EnumCallToActionType mCallToActionType = null;
    @SerializedName(value="effective_instagram_story_id")
    private String mEffectiveInstagramStoryId = null;
    @SerializedName(value="effective_object_story_id")
    private String mEffectiveObjectStoryId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="instagram_actor_id")
    private String mInstagramActorId = null;
    @SerializedName(value="instagram_permalink_url")
    private String mInstagramPermalinkUrl = null;
    @SerializedName(value="instagram_story_id")
    private String mInstagramStoryId = null;
    @SerializedName(value="link_og_id")
    private String mLinkOgId = null;
    @SerializedName(value="link_url")
    private String mLinkUrl = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="object_story_id")
    private String mObjectStoryId = null;
    @SerializedName(value="object_story_spec")
    private AdCreativeObjectStorySpec mObjectStorySpec = null;
    @SerializedName(value="object_type")
    private EnumObjectType mObjectType = null;
    @SerializedName(value="object_url")
    private String mObjectUrl = null;
    @SerializedName(value="platform_customizations")
    private Object mPlatformCustomizations = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    @SerializedName(value="recommender_settings")
    private Object mRecommenderSettings = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="template_url")
    private String mTemplateUrl = null;
    @SerializedName(value="template_url_spec")
    private Object mTemplateUrlSpec = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="use_page_actor_override")
    private Boolean mUsePageActorOverride = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="creative_id")
    private String mCreativeId = null;
    protected static Gson gson = null;

    public AdCreative() {
    }

    public AdCreative(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreative(String id, APIContext context) {
        this.mId = id;
        this.mCreativeId = this.mId.toString();
        this.context = context;
    }

    public AdCreative fetch() throws APIException {
        AdCreative newInstance = AdCreative.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        this.mCreativeId = this.mId.toString();
        return this;
    }

    public static AdCreative fetchById(Long id, APIContext context) throws APIException {
        return AdCreative.fetchById(id.toString(), context);
    }

    public static AdCreative fetchById(String id, APIContext context) throws APIException {
        AdCreative adCreative = new APIRequestGet(id, context).requestAllFields().execute();
        return adCreative;
    }

    public static APINodeList<AdCreative> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreative>(context, "", "/", "GET", AdCreative.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreative loadJSON(String json, APIContext context) {
        AdCreative adCreative = (AdCreative)AdCreative.getGson().fromJson(json, AdCreative.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreative.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreative.context = context;
        adCreative.rawValue = json;
        adCreative.mCreativeId = adCreative.mId;
        return adCreative;
    }

    public static APINodeList<AdCreative> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdCreative> adCreatives = new APINodeList<AdCreative>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreatives.add(AdCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreatives;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adCreatives.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreatives.add(AdCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreatives.add(AdCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreatives.add(AdCreative.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreatives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreatives.add(AdCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreatives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreatives.add(AdCreative.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreatives;
                }
                adCreatives.clear();
                adCreatives.add(AdCreative.loadJSON(json, context));
                return adCreatives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreative.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAdLabels deleteAdLabels() {
        return new APIRequestDeleteAdLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdLabel createAdLabel() {
        return new APIRequestCreateAdLabel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPreviews getPreviews() {
        return new APIRequestGetPreviews(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public AdCreative setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public String getFieldActorId() {
        return this.mActorId;
    }

    public AdCreative setFieldActorId(String value) {
        this.mActorId = value;
        return this;
    }

    public List<AdLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public AdCreative setFieldAdlabels(List<AdLabel> value) {
        this.mAdlabels = value;
        return this;
    }

    public AdCreative setFieldAdlabels(String value) {
        Type type = new TypeToken<List<AdLabel>>(){}.getType();
        this.mAdlabels = (List)AdLabel.getGson().fromJson(value, type);
        return this;
    }

    public EnumApplinkTreatment getFieldApplinkTreatment() {
        return this.mApplinkTreatment;
    }

    public AdCreative setFieldApplinkTreatment(EnumApplinkTreatment value) {
        this.mApplinkTreatment = value;
        return this;
    }

    public AdAssetFeedSpec getFieldAssetFeedSpec() {
        return this.mAssetFeedSpec;
    }

    public AdCreative setFieldAssetFeedSpec(AdAssetFeedSpec value) {
        this.mAssetFeedSpec = value;
        return this;
    }

    public AdCreative setFieldAssetFeedSpec(String value) {
        Type type = new TypeToken<AdAssetFeedSpec>(){}.getType();
        this.mAssetFeedSpec = (AdAssetFeedSpec)AdAssetFeedSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldBody() {
        return this.mBody;
    }

    public AdCreative setFieldBody(String value) {
        this.mBody = value;
        return this;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public AdCreative setFieldBrandedContentSponsorPageId(String value) {
        this.mBrandedContentSponsorPageId = value;
        return this;
    }

    public EnumCallToActionType getFieldCallToActionType() {
        return this.mCallToActionType;
    }

    public AdCreative setFieldCallToActionType(EnumCallToActionType value) {
        this.mCallToActionType = value;
        return this;
    }

    public String getFieldEffectiveInstagramStoryId() {
        return this.mEffectiveInstagramStoryId;
    }

    public AdCreative setFieldEffectiveInstagramStoryId(String value) {
        this.mEffectiveInstagramStoryId = value;
        return this;
    }

    public String getFieldEffectiveObjectStoryId() {
        return this.mEffectiveObjectStoryId;
    }

    public AdCreative setFieldEffectiveObjectStoryId(String value) {
        this.mEffectiveObjectStoryId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdCreative setFieldId(String value) {
        this.mCreativeId = this.mId = value;
        return this;
    }

    public AdsImageCrops getFieldImageCrops() {
        return this.mImageCrops;
    }

    public AdCreative setFieldImageCrops(AdsImageCrops value) {
        this.mImageCrops = value;
        return this;
    }

    public AdCreative setFieldImageCrops(String value) {
        Type type = new TypeToken<AdsImageCrops>(){}.getType();
        this.mImageCrops = (AdsImageCrops)AdsImageCrops.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCreative setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public AdCreative setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public String getFieldInstagramActorId() {
        return this.mInstagramActorId;
    }

    public AdCreative setFieldInstagramActorId(String value) {
        this.mInstagramActorId = value;
        return this;
    }

    public String getFieldInstagramPermalinkUrl() {
        return this.mInstagramPermalinkUrl;
    }

    public AdCreative setFieldInstagramPermalinkUrl(String value) {
        this.mInstagramPermalinkUrl = value;
        return this;
    }

    public String getFieldInstagramStoryId() {
        return this.mInstagramStoryId;
    }

    public AdCreative setFieldInstagramStoryId(String value) {
        this.mInstagramStoryId = value;
        return this;
    }

    public String getFieldLinkOgId() {
        return this.mLinkOgId;
    }

    public AdCreative setFieldLinkOgId(String value) {
        this.mLinkOgId = value;
        return this;
    }

    public String getFieldLinkUrl() {
        return this.mLinkUrl;
    }

    public AdCreative setFieldLinkUrl(String value) {
        this.mLinkUrl = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdCreative setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public AdCreative setFieldObjectId(String value) {
        this.mObjectId = value;
        return this;
    }

    public String getFieldObjectStoryId() {
        return this.mObjectStoryId;
    }

    public AdCreative setFieldObjectStoryId(String value) {
        this.mObjectStoryId = value;
        return this;
    }

    public AdCreativeObjectStorySpec getFieldObjectStorySpec() {
        return this.mObjectStorySpec;
    }

    public AdCreative setFieldObjectStorySpec(AdCreativeObjectStorySpec value) {
        this.mObjectStorySpec = value;
        return this;
    }

    public AdCreative setFieldObjectStorySpec(String value) {
        Type type = new TypeToken<AdCreativeObjectStorySpec>(){}.getType();
        this.mObjectStorySpec = (AdCreativeObjectStorySpec)AdCreativeObjectStorySpec.getGson().fromJson(value, type);
        return this;
    }

    public EnumObjectType getFieldObjectType() {
        return this.mObjectType;
    }

    public AdCreative setFieldObjectType(EnumObjectType value) {
        this.mObjectType = value;
        return this;
    }

    public String getFieldObjectUrl() {
        return this.mObjectUrl;
    }

    public AdCreative setFieldObjectUrl(String value) {
        this.mObjectUrl = value;
        return this;
    }

    public Object getFieldPlatformCustomizations() {
        return this.mPlatformCustomizations;
    }

    public AdCreative setFieldPlatformCustomizations(Object value) {
        this.mPlatformCustomizations = value;
        return this;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public AdCreative setFieldProductSetId(String value) {
        this.mProductSetId = value;
        return this;
    }

    public Object getFieldRecommenderSettings() {
        return this.mRecommenderSettings;
    }

    public AdCreative setFieldRecommenderSettings(Object value) {
        this.mRecommenderSettings = value;
        return this;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public AdCreative setFieldStatus(EnumStatus value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldTemplateUrl() {
        return this.mTemplateUrl;
    }

    public AdCreative setFieldTemplateUrl(String value) {
        this.mTemplateUrl = value;
        return this;
    }

    public Object getFieldTemplateUrlSpec() {
        return this.mTemplateUrlSpec;
    }

    public AdCreative setFieldTemplateUrlSpec(Object value) {
        this.mTemplateUrlSpec = value;
        return this;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public AdCreative setFieldThumbnailUrl(String value) {
        this.mThumbnailUrl = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public AdCreative setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdCreative setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    public Boolean getFieldUsePageActorOverride() {
        return this.mUsePageActorOverride;
    }

    public AdCreative setFieldUsePageActorOverride(Boolean value) {
        this.mUsePageActorOverride = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public AdCreative setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreative copyFrom(AdCreative instance) {
        this.mAccountId = instance.mAccountId;
        this.mActorId = instance.mActorId;
        this.mAdlabels = instance.mAdlabels;
        this.mApplinkTreatment = instance.mApplinkTreatment;
        this.mAssetFeedSpec = instance.mAssetFeedSpec;
        this.mBody = instance.mBody;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mCallToActionType = instance.mCallToActionType;
        this.mEffectiveInstagramStoryId = instance.mEffectiveInstagramStoryId;
        this.mEffectiveObjectStoryId = instance.mEffectiveObjectStoryId;
        this.mId = instance.mId;
        this.mImageCrops = instance.mImageCrops;
        this.mImageHash = instance.mImageHash;
        this.mImageUrl = instance.mImageUrl;
        this.mInstagramActorId = instance.mInstagramActorId;
        this.mInstagramPermalinkUrl = instance.mInstagramPermalinkUrl;
        this.mInstagramStoryId = instance.mInstagramStoryId;
        this.mLinkOgId = instance.mLinkOgId;
        this.mLinkUrl = instance.mLinkUrl;
        this.mName = instance.mName;
        this.mObjectId = instance.mObjectId;
        this.mObjectStoryId = instance.mObjectStoryId;
        this.mObjectStorySpec = instance.mObjectStorySpec;
        this.mObjectType = instance.mObjectType;
        this.mObjectUrl = instance.mObjectUrl;
        this.mPlatformCustomizations = instance.mPlatformCustomizations;
        this.mProductSetId = instance.mProductSetId;
        this.mRecommenderSettings = instance.mRecommenderSettings;
        this.mStatus = instance.mStatus;
        this.mTemplateUrl = instance.mTemplateUrl;
        this.mTemplateUrlSpec = instance.mTemplateUrlSpec;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mTitle = instance.mTitle;
        this.mUrlTags = instance.mUrlTags;
        this.mUsePageActorOverride = instance.mUsePageActorOverride;
        this.mVideoId = instance.mVideoId;
        this.mCreativeId = this.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreative> getParser() {
        return new APIRequest.ResponseParser<AdCreative>(){

            @Override
            public APINodeList<AdCreative> parseResponse(String response, APIContext context, APIRequest<AdCreative> request) throws APIException.MalformedResponseException {
                return AdCreative.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOperator {
        VALUE_ALL("ALL"),
        VALUE_ANY("ANY"),
        NULL(null);

        private String value;

        private EnumOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDynamicAdVoice {
        VALUE_DYNAMIC("DYNAMIC"),
        VALUE_STORY_OWNER("STORY_OWNER"),
        NULL(null);

        private String value;

        private EnumDynamicAdVoice(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_DELETED("DELETED"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumObjectType {
        VALUE_APPLICATION("APPLICATION"),
        VALUE_DOMAIN("DOMAIN"),
        VALUE_EVENT("EVENT"),
        VALUE_OFFER("OFFER"),
        VALUE_PAGE("PAGE"),
        VALUE_PHOTO("PHOTO"),
        VALUE_SHARE("SHARE"),
        VALUE_STATUS("STATUS"),
        VALUE_STORE_ITEM("STORE_ITEM"),
        VALUE_VIDEO("VIDEO"),
        VALUE_INVALID("INVALID"),
        NULL(null);

        private String value;

        private EnumObjectType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCallToActionType {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_CALL_NOW("CALL_NOW"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_MESSAGE_USER("MESSAGE_USER"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_START_ORDER("START_ORDER"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_VOTE_NOW("VOTE_NOW"),
        VALUE_REGISTER_NOW("REGISTER_NOW"),
        VALUE_REQUEST_TIME("REQUEST_TIME"),
        VALUE_SEE_MENU("SEE_MENU"),
        VALUE_EMAIL_NOW("EMAIL_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_TRY_IT("TRY_IT"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_OPEN_MOVIES("OPEN_MOVIES"),
        NULL(null);

        private String value;

        private EnumCallToActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumApplinkTreatment {
        VALUE_DEEPLINK_WITH_WEB_FALLBACK("deeplink_with_web_fallback"),
        VALUE_DEEPLINK_WITH_APPSTORE_FALLBACK("deeplink_with_appstore_fallback"),
        VALUE_WEB_ONLY("web_only"),
        NULL(null);

        private String value;

        private EnumApplinkTreatment(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdCreative> {
        AdCreative lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "adlabels", "name", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdCreative getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreative parseResponse(String response) throws APIException {
            return AdCreative.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreative execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreative execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestUpdate setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreative> {
        AdCreative lastResponse = null;
        public static final String[] PARAMS = new String[]{"thumbnail_height", "thumbnail_width"};
        public static final String[] FIELDS = new String[]{"account_id", "actor_id", "adlabels", "applink_treatment", "asset_feed_spec", "body", "branded_content_sponsor_page_id", "call_to_action_type", "effective_instagram_story_id", "effective_object_story_id", "id", "image_crops", "image_hash", "image_url", "instagram_actor_id", "instagram_permalink_url", "instagram_story_id", "link_og_id", "link_url", "name", "object_id", "object_story_id", "object_story_spec", "object_type", "object_url", "platform_customizations", "product_set_id", "recommender_settings", "status", "template_url", "template_url_spec", "thumbnail_url", "title", "url_tags", "use_page_actor_override", "video_id"};

        @Override
        public AdCreative getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreative parseResponse(String response) throws APIException {
            return AdCreative.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreative execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreative execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setThumbnailHeight(Long thumbnailHeight) {
            this.setParam("thumbnail_height", thumbnailHeight);
            return this;
        }

        public APIRequestGet setThumbnailHeight(String thumbnailHeight) {
            this.setParam("thumbnail_height", thumbnailHeight);
            return this;
        }

        public APIRequestGet setThumbnailWidth(Long thumbnailWidth) {
            this.setParam("thumbnail_width", thumbnailWidth);
            return this;
        }

        public APIRequestGet setThumbnailWidth(String thumbnailWidth) {
            this.setParam("thumbnail_width", thumbnailWidth);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestActorIdField() {
            return this.requestActorIdField(true);
        }

        public APIRequestGet requestActorIdField(boolean value) {
            this.requestField("actor_id", value);
            return this;
        }

        public APIRequestGet requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGet requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGet requestApplinkTreatmentField() {
            return this.requestApplinkTreatmentField(true);
        }

        public APIRequestGet requestApplinkTreatmentField(boolean value) {
            this.requestField("applink_treatment", value);
            return this;
        }

        public APIRequestGet requestAssetFeedSpecField() {
            return this.requestAssetFeedSpecField(true);
        }

        public APIRequestGet requestAssetFeedSpecField(boolean value) {
            this.requestField("asset_feed_spec", value);
            return this;
        }

        public APIRequestGet requestBodyField() {
            return this.requestBodyField(true);
        }

        public APIRequestGet requestBodyField(boolean value) {
            this.requestField("body", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField() {
            return this.requestBrandedContentSponsorPageIdField(true);
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField(boolean value) {
            this.requestField("branded_content_sponsor_page_id", value);
            return this;
        }

        public APIRequestGet requestCallToActionTypeField() {
            return this.requestCallToActionTypeField(true);
        }

        public APIRequestGet requestCallToActionTypeField(boolean value) {
            this.requestField("call_to_action_type", value);
            return this;
        }

        public APIRequestGet requestEffectiveInstagramStoryIdField() {
            return this.requestEffectiveInstagramStoryIdField(true);
        }

        public APIRequestGet requestEffectiveInstagramStoryIdField(boolean value) {
            this.requestField("effective_instagram_story_id", value);
            return this;
        }

        public APIRequestGet requestEffectiveObjectStoryIdField() {
            return this.requestEffectiveObjectStoryIdField(true);
        }

        public APIRequestGet requestEffectiveObjectStoryIdField(boolean value) {
            this.requestField("effective_object_story_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageCropsField() {
            return this.requestImageCropsField(true);
        }

        public APIRequestGet requestImageCropsField(boolean value) {
            this.requestField("image_crops", value);
            return this;
        }

        public APIRequestGet requestImageHashField() {
            return this.requestImageHashField(true);
        }

        public APIRequestGet requestImageHashField(boolean value) {
            this.requestField("image_hash", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGet requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGet requestInstagramPermalinkUrlField() {
            return this.requestInstagramPermalinkUrlField(true);
        }

        public APIRequestGet requestInstagramPermalinkUrlField(boolean value) {
            this.requestField("instagram_permalink_url", value);
            return this;
        }

        public APIRequestGet requestInstagramStoryIdField() {
            return this.requestInstagramStoryIdField(true);
        }

        public APIRequestGet requestInstagramStoryIdField(boolean value) {
            this.requestField("instagram_story_id", value);
            return this;
        }

        public APIRequestGet requestLinkOgIdField() {
            return this.requestLinkOgIdField(true);
        }

        public APIRequestGet requestLinkOgIdField(boolean value) {
            this.requestField("link_og_id", value);
            return this;
        }

        public APIRequestGet requestLinkUrlField() {
            return this.requestLinkUrlField(true);
        }

        public APIRequestGet requestLinkUrlField(boolean value) {
            this.requestField("link_url", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGet requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGet requestObjectStoryIdField() {
            return this.requestObjectStoryIdField(true);
        }

        public APIRequestGet requestObjectStoryIdField(boolean value) {
            this.requestField("object_story_id", value);
            return this;
        }

        public APIRequestGet requestObjectStorySpecField() {
            return this.requestObjectStorySpecField(true);
        }

        public APIRequestGet requestObjectStorySpecField(boolean value) {
            this.requestField("object_story_spec", value);
            return this;
        }

        public APIRequestGet requestObjectTypeField() {
            return this.requestObjectTypeField(true);
        }

        public APIRequestGet requestObjectTypeField(boolean value) {
            this.requestField("object_type", value);
            return this;
        }

        public APIRequestGet requestObjectUrlField() {
            return this.requestObjectUrlField(true);
        }

        public APIRequestGet requestObjectUrlField(boolean value) {
            this.requestField("object_url", value);
            return this;
        }

        public APIRequestGet requestPlatformCustomizationsField() {
            return this.requestPlatformCustomizationsField(true);
        }

        public APIRequestGet requestPlatformCustomizationsField(boolean value) {
            this.requestField("platform_customizations", value);
            return this;
        }

        public APIRequestGet requestProductSetIdField() {
            return this.requestProductSetIdField(true);
        }

        public APIRequestGet requestProductSetIdField(boolean value) {
            this.requestField("product_set_id", value);
            return this;
        }

        public APIRequestGet requestRecommenderSettingsField() {
            return this.requestRecommenderSettingsField(true);
        }

        public APIRequestGet requestRecommenderSettingsField(boolean value) {
            this.requestField("recommender_settings", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTemplateUrlField() {
            return this.requestTemplateUrlField(true);
        }

        public APIRequestGet requestTemplateUrlField(boolean value) {
            this.requestField("template_url", value);
            return this;
        }

        public APIRequestGet requestTemplateUrlSpecField() {
            return this.requestTemplateUrlSpecField(true);
        }

        public APIRequestGet requestTemplateUrlSpecField(boolean value) {
            this.requestField("template_url_spec", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestUrlTagsField() {
            return this.requestUrlTagsField(true);
        }

        public APIRequestGet requestUrlTagsField(boolean value) {
            this.requestField("url_tags", value);
            return this;
        }

        public APIRequestGet requestUsePageActorOverrideField() {
            return this.requestUsePageActorOverrideField(true);
        }

        public APIRequestGet requestUsePageActorOverrideField(boolean value) {
            this.requestField("use_page_actor_override", value);
            return this;
        }

        public APIRequestGet requestVideoIdField() {
            return this.requestVideoIdField(true);
        }

        public APIRequestGet requestVideoIdField(boolean value) {
            this.requestField("video_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "adlabels", "name", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestDelete setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDelete setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDelete setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestDelete setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestDelete setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPreviews
    extends APIRequest<AdPreview> {
        APINodeList<AdPreview> lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_format", "dynamic_creative_spec", "end_date", "height", "locale", "place_page_id", "post", "product_item_ids", "start_date", "width"};
        public static final String[] FIELDS = new String[]{"body"};

        @Override
        public APINodeList<AdPreview> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdPreview> parseResponse(String response) throws APIException {
            return AdPreview.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdPreview> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdPreview> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetPreviews(String nodeId, APIContext context) {
            super(context, nodeId, "/previews", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPreviews setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPreviews setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPreviews setAdFormat(AdPreview.EnumAdFormat adFormat) {
            this.setParam("ad_format", (Object)adFormat);
            return this;
        }

        public APIRequestGetPreviews setAdFormat(String adFormat) {
            this.setParam("ad_format", adFormat);
            return this;
        }

        public APIRequestGetPreviews setDynamicCreativeSpec(Object dynamicCreativeSpec) {
            this.setParam("dynamic_creative_spec", dynamicCreativeSpec);
            return this;
        }

        public APIRequestGetPreviews setDynamicCreativeSpec(String dynamicCreativeSpec) {
            this.setParam("dynamic_creative_spec", dynamicCreativeSpec);
            return this;
        }

        public APIRequestGetPreviews setEndDate(String endDate) {
            this.setParam("end_date", endDate);
            return this;
        }

        public APIRequestGetPreviews setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPreviews setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPreviews setLocale(String locale) {
            this.setParam("locale", locale);
            return this;
        }

        public APIRequestGetPreviews setPlacePageId(Long placePageId) {
            this.setParam("place_page_id", placePageId);
            return this;
        }

        public APIRequestGetPreviews setPlacePageId(String placePageId) {
            this.setParam("place_page_id", placePageId);
            return this;
        }

        public APIRequestGetPreviews setPost(Object post) {
            this.setParam("post", post);
            return this;
        }

        public APIRequestGetPreviews setPost(String post) {
            this.setParam("post", post);
            return this;
        }

        public APIRequestGetPreviews setProductItemIds(List<String> productItemIds) {
            this.setParam("product_item_ids", productItemIds);
            return this;
        }

        public APIRequestGetPreviews setProductItemIds(String productItemIds) {
            this.setParam("product_item_ids", productItemIds);
            return this;
        }

        public APIRequestGetPreviews setStartDate(String startDate) {
            this.setParam("start_date", startDate);
            return this;
        }

        public APIRequestGetPreviews setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPreviews setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPreviews requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPreviews requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPreviews requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPreviews requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPreviews requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPreviews requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPreviews requestBodyField() {
            return this.requestBodyField(true);
        }

        public APIRequestGetPreviews requestBodyField(boolean value) {
            this.requestField("body", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdLabel
    extends APIRequest<AdLabel> {
        AdLabel lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdLabel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdLabel parseResponse(String response) throws APIException {
            return AdLabel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdLabel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdLabel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateAdLabel(String nodeId, APIContext context) {
            super(context, nodeId, "/adlabels", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdLabel setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdLabel requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdLabels
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDeleteAdLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/adlabels", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdLabels setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDeleteAdLabels setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestDeleteAdLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

