/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ProductCatalogDiagnosticGroup
extends APINode {
    @SerializedName(value="affected_channels")
    private List<EnumAffectedChannels> mAffectedChannels = null;
    @SerializedName(value="affected_entity")
    private EnumAffectedEntity mAffectedEntity = null;
    @SerializedName(value="affected_features")
    private List<EnumAffectedFeatures> mAffectedFeatures = null;
    @SerializedName(value="diagnostics")
    private List<Object> mDiagnostics = null;
    @SerializedName(value="error_code")
    private Long mErrorCode = null;
    @SerializedName(value="number_of_affected_entities")
    private Long mNumberOfAffectedEntities = null;
    @SerializedName(value="number_of_affected_items")
    private Long mNumberOfAffectedItems = null;
    @SerializedName(value="severity")
    private EnumSeverity mSeverity = null;
    @SerializedName(value="subtitle")
    private String mSubtitle = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductCatalogDiagnosticGroup loadJSON(String json, APIContext context, String header) {
        ProductCatalogDiagnosticGroup productCatalogDiagnosticGroup = (ProductCatalogDiagnosticGroup)ProductCatalogDiagnosticGroup.getGson().fromJson(json, ProductCatalogDiagnosticGroup.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogDiagnosticGroup.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogDiagnosticGroup.context = context;
        productCatalogDiagnosticGroup.rawValue = json;
        productCatalogDiagnosticGroup.header = header;
        return productCatalogDiagnosticGroup;
    }

    public static APINodeList<ProductCatalogDiagnosticGroup> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogDiagnosticGroup> productCatalogDiagnosticGroups = new APINodeList<ProductCatalogDiagnosticGroup>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productCatalogDiagnosticGroups;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogDiagnosticGroups.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogDiagnosticGroups.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogDiagnosticGroups.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productCatalogDiagnosticGroups;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productCatalogDiagnosticGroups;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogDiagnosticGroups;
                }
                productCatalogDiagnosticGroups.clear();
                productCatalogDiagnosticGroups.add(ProductCatalogDiagnosticGroup.loadJSON(json, context, header));
                return productCatalogDiagnosticGroups;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogDiagnosticGroup.getGson().toJson((Object)this);
    }

    public List<EnumAffectedChannels> getFieldAffectedChannels() {
        return this.mAffectedChannels;
    }

    public ProductCatalogDiagnosticGroup setFieldAffectedChannels(List<EnumAffectedChannels> value) {
        this.mAffectedChannels = value;
        return this;
    }

    public EnumAffectedEntity getFieldAffectedEntity() {
        return this.mAffectedEntity;
    }

    public ProductCatalogDiagnosticGroup setFieldAffectedEntity(EnumAffectedEntity value) {
        this.mAffectedEntity = value;
        return this;
    }

    public List<EnumAffectedFeatures> getFieldAffectedFeatures() {
        return this.mAffectedFeatures;
    }

    public ProductCatalogDiagnosticGroup setFieldAffectedFeatures(List<EnumAffectedFeatures> value) {
        this.mAffectedFeatures = value;
        return this;
    }

    public List<Object> getFieldDiagnostics() {
        return this.mDiagnostics;
    }

    public ProductCatalogDiagnosticGroup setFieldDiagnostics(List<Object> value) {
        this.mDiagnostics = value;
        return this;
    }

    public Long getFieldErrorCode() {
        return this.mErrorCode;
    }

    public ProductCatalogDiagnosticGroup setFieldErrorCode(Long value) {
        this.mErrorCode = value;
        return this;
    }

    public Long getFieldNumberOfAffectedEntities() {
        return this.mNumberOfAffectedEntities;
    }

    public ProductCatalogDiagnosticGroup setFieldNumberOfAffectedEntities(Long value) {
        this.mNumberOfAffectedEntities = value;
        return this;
    }

    public Long getFieldNumberOfAffectedItems() {
        return this.mNumberOfAffectedItems;
    }

    public ProductCatalogDiagnosticGroup setFieldNumberOfAffectedItems(Long value) {
        this.mNumberOfAffectedItems = value;
        return this;
    }

    public EnumSeverity getFieldSeverity() {
        return this.mSeverity;
    }

    public ProductCatalogDiagnosticGroup setFieldSeverity(EnumSeverity value) {
        this.mSeverity = value;
        return this;
    }

    public String getFieldSubtitle() {
        return this.mSubtitle;
    }

    public ProductCatalogDiagnosticGroup setFieldSubtitle(String value) {
        this.mSubtitle = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public ProductCatalogDiagnosticGroup setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public ProductCatalogDiagnosticGroup setFieldType(EnumType value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogDiagnosticGroup copyFrom(ProductCatalogDiagnosticGroup instance) {
        this.mAffectedChannels = instance.mAffectedChannels;
        this.mAffectedEntity = instance.mAffectedEntity;
        this.mAffectedFeatures = instance.mAffectedFeatures;
        this.mDiagnostics = instance.mDiagnostics;
        this.mErrorCode = instance.mErrorCode;
        this.mNumberOfAffectedEntities = instance.mNumberOfAffectedEntities;
        this.mNumberOfAffectedItems = instance.mNumberOfAffectedItems;
        this.mSeverity = instance.mSeverity;
        this.mSubtitle = instance.mSubtitle;
        this.mTitle = instance.mTitle;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogDiagnosticGroup> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogDiagnosticGroup>(){

            @Override
            public APINodeList<ProductCatalogDiagnosticGroup> parseResponse(String response, APIContext context, APIRequest<ProductCatalogDiagnosticGroup> request, String header) throws APIException.MalformedResponseException {
                return ProductCatalogDiagnosticGroup.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumTypes {
        VALUE_AR_VISIBILITY_ISSUES("AR_VISIBILITY_ISSUES"),
        VALUE_ATTRIBUTES_INVALID("ATTRIBUTES_INVALID"),
        VALUE_ATTRIBUTES_MISSING("ATTRIBUTES_MISSING"),
        VALUE_CATEGORY("CATEGORY"),
        VALUE_CHECKOUT("CHECKOUT"),
        VALUE_DA_VISIBILITY_ISSUES("DA_VISIBILITY_ISSUES"),
        VALUE_IMAGE_QUALITY("IMAGE_QUALITY"),
        VALUE_LOW_QUALITY_TITLE_AND_DESCRIPTION("LOW_QUALITY_TITLE_AND_DESCRIPTION"),
        VALUE_POLICY_VIOLATION("POLICY_VIOLATION"),
        VALUE_SHOPS_VISIBILITY_ISSUES("SHOPS_VISIBILITY_ISSUES");

        private String value;

        private EnumTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSeverities {
        VALUE_MUST_FIX("MUST_FIX"),
        VALUE_OPPORTUNITY("OPPORTUNITY");

        private String value;

        private EnumSeverities(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAffectedEntities {
        VALUE_PRODUCT_CATALOG("product_catalog"),
        VALUE_PRODUCT_ITEM("product_item"),
        VALUE_PRODUCT_SET("product_set");

        private String value;

        private EnumAffectedEntities(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumType {
        VALUE_AR_VISIBILITY_ISSUES("AR_VISIBILITY_ISSUES"),
        VALUE_ATTRIBUTES_INVALID("ATTRIBUTES_INVALID"),
        VALUE_ATTRIBUTES_MISSING("ATTRIBUTES_MISSING"),
        VALUE_CATEGORY("CATEGORY"),
        VALUE_CHECKOUT("CHECKOUT"),
        VALUE_DA_VISIBILITY_ISSUES("DA_VISIBILITY_ISSUES"),
        VALUE_IMAGE_QUALITY("IMAGE_QUALITY"),
        VALUE_LOW_QUALITY_TITLE_AND_DESCRIPTION("LOW_QUALITY_TITLE_AND_DESCRIPTION"),
        VALUE_POLICY_VIOLATION("POLICY_VIOLATION"),
        VALUE_SHOPS_VISIBILITY_ISSUES("SHOPS_VISIBILITY_ISSUES");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSeverity {
        VALUE_MUST_FIX("MUST_FIX"),
        VALUE_OPPORTUNITY("OPPORTUNITY");

        private String value;

        private EnumSeverity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAffectedFeatures {
        VALUE_AUGMENTED_REALITY("augmented_reality"),
        VALUE_CHECKOUT("checkout");

        private String value;

        private EnumAffectedFeatures(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAffectedEntity {
        VALUE_PRODUCT_CATALOG("product_catalog"),
        VALUE_PRODUCT_ITEM("product_item"),
        VALUE_PRODUCT_SET("product_set");

        private String value;

        private EnumAffectedEntity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAffectedChannels {
        VALUE_B2C_MARKETPLACE("b2c_marketplace"),
        VALUE_C2C_MARKETPLACE("c2c_marketplace"),
        VALUE_DA("da"),
        VALUE_DAILY_DEALS("daily_deals"),
        VALUE_DAILY_DEALS_LEGACY("daily_deals_legacy"),
        VALUE_IG_PRODUCT_TAGGING("ig_product_tagging"),
        VALUE_MARKETPLACE("marketplace"),
        VALUE_MARKETPLACE_ADS_DEPRECATED("marketplace_ads_deprecated"),
        VALUE_MARKETPLACE_SHOPS("marketplace_shops"),
        VALUE_MINI_SHOPS("mini_shops"),
        VALUE_OFFLINE_CONVERSIONS("offline_conversions"),
        VALUE_SHOPS("shops"),
        VALUE_UNIVERSAL_CHECKOUT("universal_checkout"),
        VALUE_WHATSAPP("whatsapp");

        private String value;

        private EnumAffectedChannels(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

