/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdPlacePageSet;
import com.facebook.ads.sdk.ProductSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdPromotedObject
extends APINode {
    @SerializedName(value="application_id")
    private String mApplicationId = null;
    @SerializedName(value="conversion_goal_id")
    private String mConversionGoalId = null;
    @SerializedName(value="custom_conversion_id")
    private String mCustomConversionId = null;
    @SerializedName(value="custom_event_str")
    private String mCustomEventStr = null;
    @SerializedName(value="custom_event_type")
    private EnumCustomEventType mCustomEventType = null;
    @SerializedName(value="event_id")
    private String mEventId = null;
    @SerializedName(value="fundraiser_campaign_id")
    private String mFundraiserCampaignId = null;
    @SerializedName(value="mcme_conversion_id")
    private String mMcmeConversionId = null;
    @SerializedName(value="object_store_url")
    private String mObjectStoreUrl = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="offline_conversion_data_set_id")
    private String mOfflineConversionDataSetId = null;
    @SerializedName(value="offsite_conversion_event_id")
    private String mOffsiteConversionEventId = null;
    @SerializedName(value="omnichannel_object")
    private Object mOmnichannelObject = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="pixel_aggregation_rule")
    private String mPixelAggregationRule = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    @SerializedName(value="pixel_rule")
    private String mPixelRule = null;
    @SerializedName(value="place_page_set")
    private AdPlacePageSet mPlacePageSet = null;
    @SerializedName(value="place_page_set_id")
    private String mPlacePageSetId = null;
    @SerializedName(value="product_catalog_id")
    private String mProductCatalogId = null;
    @SerializedName(value="product_item_id")
    private String mProductItemId = null;
    @SerializedName(value="product_set")
    private ProductSet mProductSet = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    @SerializedName(value="retention_days")
    private String mRetentionDays = null;
    @SerializedName(value="whatsapp_phone_number")
    private String mWhatsappPhoneNumber = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdPromotedObject loadJSON(String json, APIContext context, String header) {
        AdPromotedObject adPromotedObject = (AdPromotedObject)AdPromotedObject.getGson().fromJson(json, AdPromotedObject.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adPromotedObject.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adPromotedObject.context = context;
        adPromotedObject.rawValue = json;
        adPromotedObject.header = header;
        return adPromotedObject;
    }

    public static APINodeList<AdPromotedObject> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdPromotedObject> adPromotedObjects = new APINodeList<AdPromotedObject>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adPromotedObjects;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adPromotedObjects.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adPromotedObjects.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adPromotedObjects.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adPromotedObjects.add(AdPromotedObject.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adPromotedObjects;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adPromotedObjects;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adPromotedObjects.add(AdPromotedObject.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adPromotedObjects;
                }
                adPromotedObjects.clear();
                adPromotedObjects.add(AdPromotedObject.loadJSON(json, context, header));
                return adPromotedObjects;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdPromotedObject.getGson().toJson((Object)this);
    }

    public String getFieldApplicationId() {
        return this.mApplicationId;
    }

    public AdPromotedObject setFieldApplicationId(String value) {
        this.mApplicationId = value;
        return this;
    }

    public String getFieldConversionGoalId() {
        return this.mConversionGoalId;
    }

    public AdPromotedObject setFieldConversionGoalId(String value) {
        this.mConversionGoalId = value;
        return this;
    }

    public String getFieldCustomConversionId() {
        return this.mCustomConversionId;
    }

    public AdPromotedObject setFieldCustomConversionId(String value) {
        this.mCustomConversionId = value;
        return this;
    }

    public String getFieldCustomEventStr() {
        return this.mCustomEventStr;
    }

    public AdPromotedObject setFieldCustomEventStr(String value) {
        this.mCustomEventStr = value;
        return this;
    }

    public EnumCustomEventType getFieldCustomEventType() {
        return this.mCustomEventType;
    }

    public AdPromotedObject setFieldCustomEventType(EnumCustomEventType value) {
        this.mCustomEventType = value;
        return this;
    }

    public String getFieldEventId() {
        return this.mEventId;
    }

    public AdPromotedObject setFieldEventId(String value) {
        this.mEventId = value;
        return this;
    }

    public String getFieldFundraiserCampaignId() {
        return this.mFundraiserCampaignId;
    }

    public AdPromotedObject setFieldFundraiserCampaignId(String value) {
        this.mFundraiserCampaignId = value;
        return this;
    }

    public String getFieldMcmeConversionId() {
        return this.mMcmeConversionId;
    }

    public AdPromotedObject setFieldMcmeConversionId(String value) {
        this.mMcmeConversionId = value;
        return this;
    }

    public String getFieldObjectStoreUrl() {
        return this.mObjectStoreUrl;
    }

    public AdPromotedObject setFieldObjectStoreUrl(String value) {
        this.mObjectStoreUrl = value;
        return this;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public AdPromotedObject setFieldOfferId(String value) {
        this.mOfferId = value;
        return this;
    }

    public String getFieldOfflineConversionDataSetId() {
        return this.mOfflineConversionDataSetId;
    }

    public AdPromotedObject setFieldOfflineConversionDataSetId(String value) {
        this.mOfflineConversionDataSetId = value;
        return this;
    }

    public String getFieldOffsiteConversionEventId() {
        return this.mOffsiteConversionEventId;
    }

    public AdPromotedObject setFieldOffsiteConversionEventId(String value) {
        this.mOffsiteConversionEventId = value;
        return this;
    }

    public Object getFieldOmnichannelObject() {
        return this.mOmnichannelObject;
    }

    public AdPromotedObject setFieldOmnichannelObject(Object value) {
        this.mOmnichannelObject = value;
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public AdPromotedObject setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public String getFieldPixelAggregationRule() {
        return this.mPixelAggregationRule;
    }

    public AdPromotedObject setFieldPixelAggregationRule(String value) {
        this.mPixelAggregationRule = value;
        return this;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public AdPromotedObject setFieldPixelId(String value) {
        this.mPixelId = value;
        return this;
    }

    public String getFieldPixelRule() {
        return this.mPixelRule;
    }

    public AdPromotedObject setFieldPixelRule(String value) {
        this.mPixelRule = value;
        return this;
    }

    public AdPlacePageSet getFieldPlacePageSet() {
        if (this.mPlacePageSet != null) {
            this.mPlacePageSet.context = this.getContext();
        }
        return this.mPlacePageSet;
    }

    public AdPromotedObject setFieldPlacePageSet(AdPlacePageSet value) {
        this.mPlacePageSet = value;
        return this;
    }

    public AdPromotedObject setFieldPlacePageSet(String value) {
        Type type = new TypeToken<AdPlacePageSet>(){}.getType();
        this.mPlacePageSet = (AdPlacePageSet)AdPlacePageSet.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPlacePageSetId() {
        return this.mPlacePageSetId;
    }

    public AdPromotedObject setFieldPlacePageSetId(String value) {
        this.mPlacePageSetId = value;
        return this;
    }

    public String getFieldProductCatalogId() {
        return this.mProductCatalogId;
    }

    public AdPromotedObject setFieldProductCatalogId(String value) {
        this.mProductCatalogId = value;
        return this;
    }

    public String getFieldProductItemId() {
        return this.mProductItemId;
    }

    public AdPromotedObject setFieldProductItemId(String value) {
        this.mProductItemId = value;
        return this;
    }

    public ProductSet getFieldProductSet() {
        if (this.mProductSet != null) {
            this.mProductSet.context = this.getContext();
        }
        return this.mProductSet;
    }

    public AdPromotedObject setFieldProductSet(ProductSet value) {
        this.mProductSet = value;
        return this;
    }

    public AdPromotedObject setFieldProductSet(String value) {
        Type type = new TypeToken<ProductSet>(){}.getType();
        this.mProductSet = (ProductSet)ProductSet.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public AdPromotedObject setFieldProductSetId(String value) {
        this.mProductSetId = value;
        return this;
    }

    public String getFieldRetentionDays() {
        return this.mRetentionDays;
    }

    public AdPromotedObject setFieldRetentionDays(String value) {
        this.mRetentionDays = value;
        return this;
    }

    public String getFieldWhatsappPhoneNumber() {
        return this.mWhatsappPhoneNumber;
    }

    public AdPromotedObject setFieldWhatsappPhoneNumber(String value) {
        this.mWhatsappPhoneNumber = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdPromotedObject copyFrom(AdPromotedObject instance) {
        this.mApplicationId = instance.mApplicationId;
        this.mConversionGoalId = instance.mConversionGoalId;
        this.mCustomConversionId = instance.mCustomConversionId;
        this.mCustomEventStr = instance.mCustomEventStr;
        this.mCustomEventType = instance.mCustomEventType;
        this.mEventId = instance.mEventId;
        this.mFundraiserCampaignId = instance.mFundraiserCampaignId;
        this.mMcmeConversionId = instance.mMcmeConversionId;
        this.mObjectStoreUrl = instance.mObjectStoreUrl;
        this.mOfferId = instance.mOfferId;
        this.mOfflineConversionDataSetId = instance.mOfflineConversionDataSetId;
        this.mOffsiteConversionEventId = instance.mOffsiteConversionEventId;
        this.mOmnichannelObject = instance.mOmnichannelObject;
        this.mPageId = instance.mPageId;
        this.mPixelAggregationRule = instance.mPixelAggregationRule;
        this.mPixelId = instance.mPixelId;
        this.mPixelRule = instance.mPixelRule;
        this.mPlacePageSet = instance.mPlacePageSet;
        this.mPlacePageSetId = instance.mPlacePageSetId;
        this.mProductCatalogId = instance.mProductCatalogId;
        this.mProductItemId = instance.mProductItemId;
        this.mProductSet = instance.mProductSet;
        this.mProductSetId = instance.mProductSetId;
        this.mRetentionDays = instance.mRetentionDays;
        this.mWhatsappPhoneNumber = instance.mWhatsappPhoneNumber;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdPromotedObject> getParser() {
        return new APIRequest.ResponseParser<AdPromotedObject>(){

            @Override
            public APINodeList<AdPromotedObject> parseResponse(String response, APIContext context, APIRequest<AdPromotedObject> request, String header) throws APIException.MalformedResponseException {
                return AdPromotedObject.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumCustomEventType {
        VALUE_ACHIEVEMENT_UNLOCKED("ACHIEVEMENT_UNLOCKED"),
        VALUE_ADD_PAYMENT_INFO("ADD_PAYMENT_INFO"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_ADD_TO_WISHLIST("ADD_TO_WISHLIST"),
        VALUE_AD_IMPRESSION("AD_IMPRESSION"),
        VALUE_COMPLETE_REGISTRATION("COMPLETE_REGISTRATION"),
        VALUE_CONTACT("CONTACT"),
        VALUE_CONTENT_VIEW("CONTENT_VIEW"),
        VALUE_CUSTOMIZE_PRODUCT("CUSTOMIZE_PRODUCT"),
        VALUE_D2_RETENTION("D2_RETENTION"),
        VALUE_D7_RETENTION("D7_RETENTION"),
        VALUE_DONATE("DONATE"),
        VALUE_FIND_LOCATION("FIND_LOCATION"),
        VALUE_INITIATED_CHECKOUT("INITIATED_CHECKOUT"),
        VALUE_LEAD("LEAD"),
        VALUE_LEVEL_ACHIEVED("LEVEL_ACHIEVED"),
        VALUE_LISTING_INTERACTION("LISTING_INTERACTION"),
        VALUE_MESSAGING_CONVERSATION_STARTED_7D("MESSAGING_CONVERSATION_STARTED_7D"),
        VALUE_OTHER("OTHER"),
        VALUE_PURCHASE("PURCHASE"),
        VALUE_RATE("RATE"),
        VALUE_SCHEDULE("SCHEDULE"),
        VALUE_SEARCH("SEARCH"),
        VALUE_SERVICE_BOOKING_REQUEST("SERVICE_BOOKING_REQUEST"),
        VALUE_SPENT_CREDITS("SPENT_CREDITS"),
        VALUE_START_TRIAL("START_TRIAL"),
        VALUE_SUBMIT_APPLICATION("SUBMIT_APPLICATION"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_TUTORIAL_COMPLETION("TUTORIAL_COMPLETION");

        private String value;

        private EnumCustomEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

