/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CPASBusinessSetupConfig
extends APINode {
    @SerializedName(value="accepted_collab_ads_tos")
    private Boolean mAcceptedCollabAdsTos = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_capabilities_status")
    private List<Map<String, String>> mBusinessCapabilitiesStatus = null;
    @SerializedName(value="capabilities_compliance_status")
    private List<Map<String, Object>> mCapabilitiesComplianceStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CPASBusinessSetupConfig() {
    }

    public CPASBusinessSetupConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CPASBusinessSetupConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CPASBusinessSetupConfig fetch() throws APIException {
        CPASBusinessSetupConfig newInstance = CPASBusinessSetupConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CPASBusinessSetupConfig fetchById(Long id, APIContext context) throws APIException {
        return CPASBusinessSetupConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CPASBusinessSetupConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CPASBusinessSetupConfig.fetchByIdAsync(id.toString(), context);
    }

    public static CPASBusinessSetupConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CPASBusinessSetupConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CPASBusinessSetupConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CPASBusinessSetupConfig>(context, "", "/", "GET", CPASBusinessSetupConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CPASBusinessSetupConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CPASBusinessSetupConfig>(context, "", "/", "GET", CPASBusinessSetupConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASBusinessSetupConfig loadJSON(String json, APIContext context, String header) {
        CPASBusinessSetupConfig cpasBusinessSetupConfig = (CPASBusinessSetupConfig)CPASBusinessSetupConfig.getGson().fromJson(json, CPASBusinessSetupConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasBusinessSetupConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasBusinessSetupConfig.context = context;
        cpasBusinessSetupConfig.rawValue = json;
        cpasBusinessSetupConfig.header = header;
        return cpasBusinessSetupConfig;
    }

    public static APINodeList<CPASBusinessSetupConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASBusinessSetupConfig> cpasBusinessSetupConfigs = new APINodeList<CPASBusinessSetupConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasBusinessSetupConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasBusinessSetupConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasBusinessSetupConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasBusinessSetupConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasBusinessSetupConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasBusinessSetupConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasBusinessSetupConfigs;
                }
                cpasBusinessSetupConfigs.clear();
                cpasBusinessSetupConfigs.add(CPASBusinessSetupConfig.loadJSON(json, context, header));
                return cpasBusinessSetupConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASBusinessSetupConfig.getGson().toJson((Object)this);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldAcceptedCollabAdsTos() {
        return this.mAcceptedCollabAdsTos;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public List<Map<String, String>> getFieldBusinessCapabilitiesStatus() {
        return this.mBusinessCapabilitiesStatus;
    }

    public List<Map<String, Object>> getFieldCapabilitiesComplianceStatus() {
        return this.mCapabilitiesComplianceStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASBusinessSetupConfig copyFrom(CPASBusinessSetupConfig instance) {
        this.mAcceptedCollabAdsTos = instance.mAcceptedCollabAdsTos;
        this.mBusiness = instance.mBusiness;
        this.mBusinessCapabilitiesStatus = instance.mBusinessCapabilitiesStatus;
        this.mCapabilitiesComplianceStatus = instance.mCapabilitiesComplianceStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASBusinessSetupConfig> getParser() {
        return new APIRequest.ResponseParser<CPASBusinessSetupConfig>(){

            @Override
            public APINodeList<CPASBusinessSetupConfig> parseResponse(String response, APIContext context, APIRequest<CPASBusinessSetupConfig> request, String header) throws APIException.MalformedResponseException {
                return CPASBusinessSetupConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CPASBusinessSetupConfig> {
        CPASBusinessSetupConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"accepted_collab_ads_tos", "business", "business_capabilities_status", "capabilities_compliance_status", "id"};

        @Override
        public CPASBusinessSetupConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASBusinessSetupConfig parseResponse(String response, String header) throws APIException {
            return CPASBusinessSetupConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASBusinessSetupConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASBusinessSetupConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASBusinessSetupConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASBusinessSetupConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASBusinessSetupConfig>(){

                public CPASBusinessSetupConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAcceptedCollabAdsTosField() {
            return this.requestAcceptedCollabAdsTosField(true);
        }

        public APIRequestGet requestAcceptedCollabAdsTosField(boolean value) {
            this.requestField("accepted_collab_ads_tos", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestBusinessCapabilitiesStatusField() {
            return this.requestBusinessCapabilitiesStatusField(true);
        }

        public APIRequestGet requestBusinessCapabilitiesStatusField(boolean value) {
            this.requestField("business_capabilities_status", value);
            return this;
        }

        public APIRequestGet requestCapabilitiesComplianceStatusField() {
            return this.requestCapabilitiesComplianceStatusField(true);
        }

        public APIRequestGet requestCapabilitiesComplianceStatusField(boolean value) {
            this.requestField("capabilities_compliance_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "all_capabilities", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "default_dsa_beneficiary", "default_dsa_payor", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_access_expire_time", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAllCapabilitiesField() {
            return this.requestAllCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestAllCapabilitiesField(boolean value) {
            this.requestField("all_capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDefaultDsaBeneficiaryField() {
            return this.requestDefaultDsaBeneficiaryField(true);
        }

        public APIRequestGetAdAccounts requestDefaultDsaBeneficiaryField(boolean value) {
            this.requestField("default_dsa_beneficiary", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDefaultDsaPayorField() {
            return this.requestDefaultDsaPayorField(true);
        }

        public APIRequestGetAdAccounts requestDefaultDsaPayorField(boolean value) {
            this.requestField("default_dsa_payor", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetAdAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetAdAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserAccessExpireTimeField() {
            return this.requestUserAccessExpireTimeField(true);
        }

        public APIRequestGetAdAccounts requestUserAccessExpireTimeField(boolean value) {
            this.requestField("user_access_expire_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetAdAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }
}

