/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.serverside.AppData;
import com.facebook.ads.sdk.serverside.CustomData;
import com.facebook.ads.sdk.serverside.CustomEndpointRequest;
import com.facebook.ads.sdk.serverside.CustomEndpointResponse;
import com.facebook.ads.sdk.serverside.Event;
import com.facebook.ads.sdk.serverside.EventResponse;
import com.facebook.ads.sdk.serverside.HttpMethodEnum;
import com.facebook.ads.sdk.serverside.HttpServiceInterface;
import com.facebook.ads.sdk.serverside.HttpServiceParams;
import com.facebook.ads.utils.AppDataAdapter;
import com.facebook.ads.utils.CustomDataAdapter;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventRequest {
    private static Gson gson = null;
    @SerializedName(value="data")
    private List<Event> data = new ArrayList<Event>();
    @SerializedName(value="test_event_code")
    private String testEventCode = null;
    @SerializedName(value="partner_agent")
    private String partnerAgent = null;
    @SerializedName(value="namespace_id")
    private String namespaceId = null;
    @SerializedName(value="upload_id")
    private String uploadId = null;
    @SerializedName(value="upload_tag")
    private String uploadTag = null;
    @SerializedName(value="upload_source")
    private String uploadSource = null;
    private String pixelId;
    private APIContext context;
    private HttpServiceInterface httpServiceClient;
    private CustomEndpointRequest endpointRequest;

    public EventRequest(String pixelId, APIContext context) {
        this.pixelId = pixelId;
        this.context = context;
    }

    public EventRequest(String pixelId, APIContext context, List<Event> data, String testEventCode, String partnerAgent, String namespaceId, String uploadId, String uploadTag, String uploadSource, HttpServiceInterface httpServiceClient) {
        this.data = data;
        this.testEventCode = testEventCode;
        this.partnerAgent = partnerAgent;
        this.pixelId = pixelId;
        this.context = context;
        this.namespaceId = namespaceId;
        this.uploadId = uploadId;
        this.uploadTag = uploadTag;
        this.uploadSource = uploadSource;
        this.httpServiceClient = httpServiceClient;
        this.endpointRequest = null;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8, 4}).disableHtmlEscaping().registerTypeAdapter(CustomData.class, (Object)new CustomDataAdapter()).registerTypeAdapter(AppData.class, (Object)new AppDataAdapter()).create();
        return gson;
    }

    public EventRequest data(List<Event> data) {
        this.data = data;
        return this;
    }

    public void setCustomEndpoint(CustomEndpointRequest endpointRequest) {
        this.endpointRequest = endpointRequest;
    }

    public EventRequest addDataItem(Event dataItem) {
        this.data.add(dataItem);
        return this;
    }

    public List<Event> getData() {
        return this.data;
    }

    public void setData(List<Event> data) {
        this.data = data;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public EventRequest namespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public EventRequest uploadId(String uploadId) {
        this.uploadId = uploadId;
        return this;
    }

    public String getUploadTag() {
        return this.uploadTag;
    }

    public void setUploadTag(String uploadTag) {
        this.uploadTag = uploadTag;
    }

    public EventRequest uploadTag(String uploadTag) {
        this.uploadTag = uploadTag;
        return this;
    }

    public String getUploadSource() {
        return this.uploadSource;
    }

    public void setUploadSource(String uploadSource) {
        this.uploadSource = uploadSource;
    }

    public EventRequest uploadSource(String uploadSource) {
        this.uploadSource = uploadSource;
        return this;
    }

    public EventRequest testEventCode(String testEventCode) {
        this.testEventCode = testEventCode;
        return this;
    }

    public String getTestEventCode() {
        return this.testEventCode;
    }

    public void setTestEventCode(String testEventCode) {
        this.testEventCode = testEventCode;
    }

    public EventRequest partnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
        return this;
    }

    public String getPartnerAgent() {
        return this.partnerAgent;
    }

    public void setPartnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
    }

    public HttpServiceInterface getHttpServiceClient() {
        return this.httpServiceClient;
    }

    public void setHttpServiceClient(HttpServiceInterface httpServiceClient) {
        this.httpServiceClient = httpServiceClient;
    }

    public EventResponse execute() throws APIException {
        try {
            EventResponse response;
            if (this.endpointRequest != null && this.endpointRequest.isSendToEndpointOnly()) {
                Map<String, CustomEndpointResponse> customEndpointResponses = this.sendEventsToCustomEndpoint();
                this.context.log(String.format("Successfully sent %d event(s) to %s only", this.data.size(), this.endpointRequest.getEndpoint()));
                this.context.log("Skipping CAPI Endpoint");
                EventResponse response2 = new EventResponse(this.data.size(), new ArrayList<String>(), "");
                response2.setCustomEndpointResponses(customEndpointResponses);
                return response2;
            }
            if (this.endpointRequest != null) {
                response = this.sendToCAPIEndpoint();
                Map<String, CustomEndpointResponse> customEndpointResponses = this.sendEventsToCustomEndpoint();
                response.setCustomEndpointResponses(customEndpointResponses);
            } else {
                response = this.sendToCAPIEndpoint();
            }
            this.context.log(String.format("Successfully sent %d event(s)", response.getEventsReceived()));
            return response;
        }
        catch (APIException e) {
            this.context.log(e.getMessage());
            throw e;
        }
    }

    private Map<String, CustomEndpointResponse> sendEventsToCustomEndpoint() throws APIException.FailedRequestException {
        HashMap<String, CustomEndpointResponse> responses = new HashMap<String, CustomEndpointResponse>();
        CustomEndpointResponse customEndpointResponse = this.endpointRequest.sendEvent(this.context, this.pixelId, this.data);
        responses.put(this.endpointRequest.getEndpoint(), customEndpointResponse);
        return responses;
    }

    private EventResponse sendToCAPIEndpoint() throws APIException {
        EventResponse response;
        if (this.httpServiceClient == null) {
            AdsPixel.APIRequestCreateEvent event = this.getPixelCreateEvent();
            APINode pixel = event.execute();
            response = (EventResponse)gson.fromJson(pixel.getRawResponse(), EventResponse.class);
        } else {
            response = this.executeCustomHttpService(this.httpServiceClient);
        }
        return response;
    }

    private ListenableFuture<EventResponse> sendEventAsyncToCustomEndpointOnly() {
        ListenableFuture<CustomEndpointResponse> customEndpointFuture = this.endpointRequest.sendEventAsync(this.context, this.pixelId, this.data);
        return Futures.transformAsync(customEndpointFuture, (AsyncFunction)new AsyncFunction<CustomEndpointResponse, EventResponse>(){

            public ListenableFuture<EventResponse> apply(CustomEndpointResponse response) {
                EventRequest.this.context.log(String.format("Successfully sent %d event(s) to %s only", EventRequest.this.data.size(), EventRequest.this.endpointRequest.getEndpoint()));
                EventRequest.this.context.log("Skipping CAPI Endpoint");
                EventResponse customEndpointResponse = new EventResponse(EventRequest.this.data.size(), new ArrayList<String>(), "");
                HashMap<String, CustomEndpointResponse> endpointResponses = new HashMap<String, CustomEndpointResponse>();
                endpointResponses.put(EventRequest.this.endpointRequest.getEndpoint(), response);
                customEndpointResponse.setCustomEndpointResponses(endpointResponses);
                return Futures.immediateFuture((Object)customEndpointResponse);
            }
        });
    }

    private ListenableFuture<EventResponse> sendEventAsyncToCAPIAndCustomEndpoint() throws APIException {
        AdsPixel.APIRequestCreateEvent event = this.getPixelCreateEvent();
        ListenableFuture<APINode> pixelFuture = event.executeAsync();
        ListenableFuture<CustomEndpointResponse> customEndpointFuture = this.endpointRequest.sendEventAsync(this.context, this.pixelId, this.data);
        ListenableFuture futureOfList = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{pixelFuture, customEndpointFuture});
        return Futures.transformAsync((ListenableFuture)futureOfList, (AsyncFunction)new AsyncFunction<List<Object>, EventResponse>(){

            public ListenableFuture<EventResponse> apply(List<Object> responses) {
                EventResponse capiEventResponse = (EventResponse)gson.fromJson(((APINode)responses.get(0)).getRawResponse(), EventResponse.class);
                CustomEndpointResponse customEndpointResponse = (CustomEndpointResponse)responses.get(1);
                HashMap<String, CustomEndpointResponse> endpointResponses = new HashMap<String, CustomEndpointResponse>();
                endpointResponses.put(EventRequest.this.endpointRequest.getEndpoint(), customEndpointResponse);
                capiEventResponse.setCustomEndpointResponses(endpointResponses);
                EventRequest.this.context.log(String.format("Successfully sent %d event(s)", capiEventResponse.getEventsReceived()));
                return Futures.immediateFuture((Object)capiEventResponse);
            }
        });
    }

    private ListenableFuture<EventResponse> sendEventToCAPIOnly() throws APIException {
        AdsPixel.APIRequestCreateEvent event = this.getPixelCreateEvent();
        ListenableFuture<APINode> nodeFuture = event.executeAsync();
        return Futures.transformAsync(nodeFuture, (AsyncFunction)new AsyncFunction<APINode, EventResponse>(){

            public ListenableFuture<EventResponse> apply(APINode node) {
                EventResponse eventResponse = (EventResponse)gson.fromJson(node.getRawResponse(), EventResponse.class);
                EventRequest.this.context.log(String.format("Successfully sent %d event(s)", eventResponse.getEventsReceived()));
                return Futures.immediateFuture((Object)eventResponse);
            }
        });
    }

    public ListenableFuture<EventResponse> executeAsync() throws APIException {
        try {
            if (this.endpointRequest == null) {
                return this.sendEventToCAPIOnly();
            }
            return this.endpointRequest.isSendToEndpointOnly() ? this.sendEventAsyncToCustomEndpointOnly() : this.sendEventAsyncToCAPIAndCustomEndpoint();
        }
        catch (APIException e) {
            this.context.log(e.getMessage());
            throw e;
        }
    }

    private EventResponse executeCustomHttpService(HttpServiceInterface httpClient) {
        String url = String.format("%s/%s/%s/events", "https://graph.facebook.com", "v18.0", this.pixelId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", "fbbizsdk-java-v18.0.3");
        String appSecretProof = null;
        if (this.context.hasAppSecret()) {
            appSecretProof = this.context.getAppSecretProof();
        }
        HttpServiceParams params = new HttpServiceParams(this.context.getAccessToken(), appSecretProof, this.data, this.testEventCode, this.partnerAgent, this.namespaceId, this.uploadId, this.uploadTag, this.uploadSource);
        return httpClient.executeRequest(url, HttpMethodEnum.POST, headers, params);
    }

    public String getSerializedPayload() {
        List<Event> s2sData = this.getData();
        return EventRequest.getGson().toJson(s2sData);
    }

    private AdsPixel.APIRequestCreateEvent getPixelCreateEvent() {
        AdsPixel.APIRequestCreateEvent event = new AdsPixel.APIRequestCreateEvent(this.pixelId, this.context);
        event.setData(EventRequest.getGson().toJson(this.getData()));
        if (this.getTestEventCode() != null) {
            event.setTestEventCode(this.getTestEventCode());
        }
        if (this.getPartnerAgent() != null) {
            event.setPartnerAgent(this.getPartnerAgent());
        }
        if (this.getNamespaceId() != null) {
            event.setNamespaceId(this.getNamespaceId());
        }
        if (this.getUploadId() != null) {
            event.setUploadId(this.getUploadId());
        }
        if (this.getUploadTag() != null) {
            event.setUploadTag(this.getUploadTag());
        }
        if (this.getUploadSource() != null) {
            event.setUploadSource(this.getUploadSource());
        }
        return event;
    }

    public EventRequest cloneWithoutData() {
        EventRequest cloned = new EventRequest(this.pixelId, this.context);
        cloned.testEventCode(this.testEventCode).partnerAgent(this.partnerAgent).namespaceId(this.namespaceId).uploadId(this.uploadId).uploadTag(this.uploadTag).uploadSource(this.uploadSource);
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventRequest eventRequest = (EventRequest)o;
        return Objects.equals(this.data, eventRequest.data) && Objects.equals(this.testEventCode, eventRequest.testEventCode) && Objects.equals(this.partnerAgent, eventRequest.partnerAgent) && Objects.equals(this.namespaceId, eventRequest.namespaceId) && Objects.equals(this.uploadId, eventRequest.uploadId) && Objects.equals(this.uploadTag, eventRequest.uploadTag) && Objects.equals(this.uploadSource, eventRequest.uploadSource);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.testEventCode, this.partnerAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    testEventCode: ").append(this.toIndentedString(this.testEventCode)).append("\n");
        sb.append("    partnerAgent: ").append(this.toIndentedString(this.partnerAgent)).append("\n");
        sb.append("    namespaceId: ").append(this.toIndentedString(this.namespaceId)).append("\n");
        sb.append("    uploadId: ").append(this.toIndentedString(this.uploadId)).append("\n");
        sb.append("    uploadTag: ").append(this.toIndentedString(this.uploadTag)).append("\n");
        sb.append("    uploadSource: ").append(this.toIndentedString(this.uploadSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

