/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class Stories
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="media_id")
    private String mMediaId = null;
    @SerializedName(value="media_type")
    private String mMediaType = null;
    @SerializedName(value="post_id")
    private String mPostId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static Stories loadJSON(String json, APIContext context, String header) {
        Stories stories = (Stories)Stories.getGson().fromJson(json, Stories.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(stories.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        stories.context = context;
        stories.rawValue = json;
        stories.header = header;
        return stories;
    }

    public static APINodeList<Stories> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Stories> storiess = new APINodeList<Stories>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        storiess.add(Stories.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return storiess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            storiess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        storiess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            storiess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            storiess.add(Stories.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                storiess.add(Stories.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            storiess.add(Stories.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return storiess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        storiess.add(Stories.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return storiess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        storiess.add(Stories.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return storiess;
                }
                storiess.clear();
                storiess.add(Stories.loadJSON(json, context, header));
                return storiess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Stories.getGson().toJson((Object)this);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Stories setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldMediaId() {
        return this.mMediaId;
    }

    public Stories setFieldMediaId(String value) {
        this.mMediaId = value;
        return this;
    }

    public String getFieldMediaType() {
        return this.mMediaType;
    }

    public Stories setFieldMediaType(String value) {
        this.mMediaType = value;
        return this;
    }

    public String getFieldPostId() {
        return this.mPostId;
    }

    public Stories setFieldPostId(String value) {
        this.mPostId = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Stories setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public Stories setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Stories copyFrom(Stories instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mMediaId = instance.mMediaId;
        this.mMediaType = instance.mMediaType;
        this.mPostId = instance.mPostId;
        this.mStatus = instance.mStatus;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Stories> getParser() {
        return new APIRequest.ResponseParser<Stories>(){

            @Override
            public APINodeList<Stories> parseResponse(String response, APIContext context, APIRequest<Stories> request, String header) throws APIException.MalformedResponseException {
                return Stories.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_PUBLISHED("PUBLISHED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

