/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.CurrencyAmount;
import com.facebook.ads.sdk.ExtendedCredit;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendedCreditAllocationConfig
extends APINode {
    @SerializedName(value="currency_amount")
    private CurrencyAmount mCurrencyAmount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="liability_type")
    private String mLiabilityType = null;
    @SerializedName(value="owning_business")
    private Business mOwningBusiness = null;
    @SerializedName(value="owning_credential")
    private ExtendedCredit mOwningCredential = null;
    @SerializedName(value="partition_type")
    private String mPartitionType = null;
    @SerializedName(value="receiving_business")
    private Business mReceivingBusiness = null;
    @SerializedName(value="receiving_credential")
    private ExtendedCredit mReceivingCredential = null;
    @SerializedName(value="request_status")
    private String mRequestStatus = null;
    @SerializedName(value="send_bill_to")
    private String mSendBillTo = null;
    protected static Gson gson = null;

    ExtendedCreditAllocationConfig() {
    }

    public ExtendedCreditAllocationConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ExtendedCreditAllocationConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ExtendedCreditAllocationConfig fetch() throws APIException {
        ExtendedCreditAllocationConfig newInstance = ExtendedCreditAllocationConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ExtendedCreditAllocationConfig fetchById(Long id, APIContext context) throws APIException {
        return ExtendedCreditAllocationConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ExtendedCreditAllocationConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ExtendedCreditAllocationConfig.fetchByIdAsync(id.toString(), context);
    }

    public static ExtendedCreditAllocationConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ExtendedCreditAllocationConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ExtendedCreditAllocationConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ExtendedCreditAllocationConfig>(context, "", "/", "GET", ExtendedCreditAllocationConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ExtendedCreditAllocationConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ExtendedCreditAllocationConfig>(context, "", "/", "GET", ExtendedCreditAllocationConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExtendedCreditAllocationConfig loadJSON(String json, APIContext context, String header) {
        ExtendedCreditAllocationConfig extendedCreditAllocationConfig = (ExtendedCreditAllocationConfig)ExtendedCreditAllocationConfig.getGson().fromJson(json, ExtendedCreditAllocationConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(extendedCreditAllocationConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        extendedCreditAllocationConfig.context = context;
        extendedCreditAllocationConfig.rawValue = json;
        extendedCreditAllocationConfig.header = header;
        return extendedCreditAllocationConfig;
    }

    public static APINodeList<ExtendedCreditAllocationConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExtendedCreditAllocationConfig> extendedCreditAllocationConfigs = new APINodeList<ExtendedCreditAllocationConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return extendedCreditAllocationConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            extendedCreditAllocationConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        extendedCreditAllocationConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            extendedCreditAllocationConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return extendedCreditAllocationConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return extendedCreditAllocationConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return extendedCreditAllocationConfigs;
                }
                extendedCreditAllocationConfigs.clear();
                extendedCreditAllocationConfigs.add(ExtendedCreditAllocationConfig.loadJSON(json, context, header));
                return extendedCreditAllocationConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExtendedCreditAllocationConfig.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public CurrencyAmount getFieldCurrencyAmount() {
        return this.mCurrencyAmount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLiabilityType() {
        return this.mLiabilityType;
    }

    public Business getFieldOwningBusiness() {
        if (this.mOwningBusiness != null) {
            this.mOwningBusiness.context = this.getContext();
        }
        return this.mOwningBusiness;
    }

    public ExtendedCredit getFieldOwningCredential() {
        if (this.mOwningCredential != null) {
            this.mOwningCredential.context = this.getContext();
        }
        return this.mOwningCredential;
    }

    public String getFieldPartitionType() {
        return this.mPartitionType;
    }

    public Business getFieldReceivingBusiness() {
        if (this.mReceivingBusiness != null) {
            this.mReceivingBusiness.context = this.getContext();
        }
        return this.mReceivingBusiness;
    }

    public ExtendedCredit getFieldReceivingCredential() {
        if (this.mReceivingCredential != null) {
            this.mReceivingCredential.context = this.getContext();
        }
        return this.mReceivingCredential;
    }

    public String getFieldRequestStatus() {
        return this.mRequestStatus;
    }

    public String getFieldSendBillTo() {
        return this.mSendBillTo;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExtendedCreditAllocationConfig copyFrom(ExtendedCreditAllocationConfig instance) {
        this.mCurrencyAmount = instance.mCurrencyAmount;
        this.mId = instance.mId;
        this.mLiabilityType = instance.mLiabilityType;
        this.mOwningBusiness = instance.mOwningBusiness;
        this.mOwningCredential = instance.mOwningCredential;
        this.mPartitionType = instance.mPartitionType;
        this.mReceivingBusiness = instance.mReceivingBusiness;
        this.mReceivingCredential = instance.mReceivingCredential;
        this.mRequestStatus = instance.mRequestStatus;
        this.mSendBillTo = instance.mSendBillTo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExtendedCreditAllocationConfig> getParser() {
        return new APIRequest.ResponseParser<ExtendedCreditAllocationConfig>(){

            @Override
            public APINodeList<ExtendedCreditAllocationConfig> parseResponse(String response, APIContext context, APIRequest<ExtendedCreditAllocationConfig> request, String header) throws APIException.MalformedResponseException {
                return ExtendedCreditAllocationConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumSendBillTo {
        VALUE_ADVERTISER("Advertiser"),
        VALUE_AGENCY("Agency");

        private String value;

        private EnumSendBillTo(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPartitionType {
        VALUE_AUTH("AUTH"),
        VALUE_FIXED("FIXED"),
        VALUE_FIXED_WITHOUT_PARTITION("FIXED_WITHOUT_PARTITION");

        private String value;

        private EnumPartitionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumLiabilityType {
        VALUE_MSA("MSA"),
        VALUE_NORMAL("Normal"),
        VALUE_SEQUENTIAL("Sequential");

        private String value;

        private EnumLiabilityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<ExtendedCreditAllocationConfig> {
        ExtendedCreditAllocationConfig lastResponse = null;
        public static final String[] PARAMS = new String[]{"amount"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ExtendedCreditAllocationConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCreditAllocationConfig parseResponse(String response, String header) throws APIException {
            return ExtendedCreditAllocationConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCreditAllocationConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCreditAllocationConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCreditAllocationConfig>(){

                public ExtendedCreditAllocationConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAmount(Object amount) {
            this.setParam("amount", amount);
            return this;
        }

        public APIRequestUpdate setAmount(String amount) {
            this.setParam("amount", amount);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ExtendedCreditAllocationConfig> {
        ExtendedCreditAllocationConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"currency_amount", "id", "liability_type", "owning_business", "owning_credential", "partition_type", "receiving_business", "receiving_credential", "request_status", "send_bill_to"};

        @Override
        public ExtendedCreditAllocationConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCreditAllocationConfig parseResponse(String response, String header) throws APIException {
            return ExtendedCreditAllocationConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCreditAllocationConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCreditAllocationConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCreditAllocationConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCreditAllocationConfig>(){

                public ExtendedCreditAllocationConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCurrencyAmountField() {
            return this.requestCurrencyAmountField(true);
        }

        public APIRequestGet requestCurrencyAmountField(boolean value) {
            this.requestField("currency_amount", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLiabilityTypeField() {
            return this.requestLiabilityTypeField(true);
        }

        public APIRequestGet requestLiabilityTypeField(boolean value) {
            this.requestField("liability_type", value);
            return this;
        }

        public APIRequestGet requestOwningBusinessField() {
            return this.requestOwningBusinessField(true);
        }

        public APIRequestGet requestOwningBusinessField(boolean value) {
            this.requestField("owning_business", value);
            return this;
        }

        public APIRequestGet requestOwningCredentialField() {
            return this.requestOwningCredentialField(true);
        }

        public APIRequestGet requestOwningCredentialField(boolean value) {
            this.requestField("owning_credential", value);
            return this;
        }

        public APIRequestGet requestPartitionTypeField() {
            return this.requestPartitionTypeField(true);
        }

        public APIRequestGet requestPartitionTypeField(boolean value) {
            this.requestField("partition_type", value);
            return this;
        }

        public APIRequestGet requestReceivingBusinessField() {
            return this.requestReceivingBusinessField(true);
        }

        public APIRequestGet requestReceivingBusinessField(boolean value) {
            this.requestField("receiving_business", value);
            return this;
        }

        public APIRequestGet requestReceivingCredentialField() {
            return this.requestReceivingCredentialField(true);
        }

        public APIRequestGet requestReceivingCredentialField(boolean value) {
            this.requestField("receiving_credential", value);
            return this;
        }

        public APIRequestGet requestRequestStatusField() {
            return this.requestRequestStatusField(true);
        }

        public APIRequestGet requestRequestStatusField(boolean value) {
            this.requestField("request_status", value);
            return this;
        }

        public APIRequestGet requestSendBillToField() {
            return this.requestSendBillToField(true);
        }

        public APIRequestGet requestSendBillToField(boolean value) {
            this.requestField("send_bill_to", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

