/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollaborativeAdsShareSettings
extends APINode {
    @SerializedName(value="agency_business")
    private Business mAgencyBusiness = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="product_catalog_proxy_id")
    private String mProductCatalogProxyId = null;
    @SerializedName(value="utm_campaign")
    private String mUtmCampaign = null;
    @SerializedName(value="utm_medium")
    private String mUtmMedium = null;
    @SerializedName(value="utm_source")
    private String mUtmSource = null;
    protected static Gson gson = null;

    CollaborativeAdsShareSettings() {
    }

    public CollaborativeAdsShareSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CollaborativeAdsShareSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CollaborativeAdsShareSettings fetch() throws APIException {
        CollaborativeAdsShareSettings newInstance = CollaborativeAdsShareSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CollaborativeAdsShareSettings fetchById(Long id, APIContext context) throws APIException {
        return CollaborativeAdsShareSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CollaborativeAdsShareSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CollaborativeAdsShareSettings.fetchByIdAsync(id.toString(), context);
    }

    public static CollaborativeAdsShareSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CollaborativeAdsShareSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CollaborativeAdsShareSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CollaborativeAdsShareSettings>(context, "", "/", "GET", CollaborativeAdsShareSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CollaborativeAdsShareSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CollaborativeAdsShareSettings>(context, "", "/", "GET", CollaborativeAdsShareSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CollaborativeAdsShareSettings loadJSON(String json, APIContext context, String header) {
        CollaborativeAdsShareSettings collaborativeAdsShareSettings = (CollaborativeAdsShareSettings)CollaborativeAdsShareSettings.getGson().fromJson(json, CollaborativeAdsShareSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(collaborativeAdsShareSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        collaborativeAdsShareSettings.context = context;
        collaborativeAdsShareSettings.rawValue = json;
        collaborativeAdsShareSettings.header = header;
        return collaborativeAdsShareSettings;
    }

    public static APINodeList<CollaborativeAdsShareSettings> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CollaborativeAdsShareSettings> collaborativeAdsShareSettingss = new APINodeList<CollaborativeAdsShareSettings>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return collaborativeAdsShareSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            collaborativeAdsShareSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        collaborativeAdsShareSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            collaborativeAdsShareSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return collaborativeAdsShareSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return collaborativeAdsShareSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return collaborativeAdsShareSettingss;
                }
                collaborativeAdsShareSettingss.clear();
                collaborativeAdsShareSettingss.add(CollaborativeAdsShareSettings.loadJSON(json, context, header));
                return collaborativeAdsShareSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CollaborativeAdsShareSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldAgencyBusiness() {
        if (this.mAgencyBusiness != null) {
            this.mAgencyBusiness.context = this.getContext();
        }
        return this.mAgencyBusiness;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldProductCatalogProxyId() {
        return this.mProductCatalogProxyId;
    }

    public String getFieldUtmCampaign() {
        return this.mUtmCampaign;
    }

    public String getFieldUtmMedium() {
        return this.mUtmMedium;
    }

    public String getFieldUtmSource() {
        return this.mUtmSource;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CollaborativeAdsShareSettings copyFrom(CollaborativeAdsShareSettings instance) {
        this.mAgencyBusiness = instance.mAgencyBusiness;
        this.mId = instance.mId;
        this.mProductCatalogProxyId = instance.mProductCatalogProxyId;
        this.mUtmCampaign = instance.mUtmCampaign;
        this.mUtmMedium = instance.mUtmMedium;
        this.mUtmSource = instance.mUtmSource;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CollaborativeAdsShareSettings> getParser() {
        return new APIRequest.ResponseParser<CollaborativeAdsShareSettings>(){

            @Override
            public APINodeList<CollaborativeAdsShareSettings> parseResponse(String response, APIContext context, APIRequest<CollaborativeAdsShareSettings> request, String header) throws APIException.MalformedResponseException {
                return CollaborativeAdsShareSettings.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CollaborativeAdsShareSettings> {
        CollaborativeAdsShareSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"agency_business", "id", "product_catalog_proxy_id", "utm_campaign", "utm_medium", "utm_source"};

        @Override
        public CollaborativeAdsShareSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CollaborativeAdsShareSettings parseResponse(String response, String header) throws APIException {
            return CollaborativeAdsShareSettings.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CollaborativeAdsShareSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CollaborativeAdsShareSettings execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CollaborativeAdsShareSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CollaborativeAdsShareSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CollaborativeAdsShareSettings>(){

                public CollaborativeAdsShareSettings apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAgencyBusinessField() {
            return this.requestAgencyBusinessField(true);
        }

        public APIRequestGet requestAgencyBusinessField(boolean value) {
            this.requestField("agency_business", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestProductCatalogProxyIdField() {
            return this.requestProductCatalogProxyIdField(true);
        }

        public APIRequestGet requestProductCatalogProxyIdField(boolean value) {
            this.requestField("product_catalog_proxy_id", value);
            return this;
        }

        public APIRequestGet requestUtmCampaignField() {
            return this.requestUtmCampaignField(true);
        }

        public APIRequestGet requestUtmCampaignField(boolean value) {
            this.requestField("utm_campaign", value);
            return this;
        }

        public APIRequestGet requestUtmMediumField() {
            return this.requestUtmMediumField(true);
        }

        public APIRequestGet requestUtmMediumField(boolean value) {
            this.requestField("utm_medium", value);
            return this;
        }

        public APIRequestGet requestUtmSourceField() {
            return this.requestUtmSourceField(true);
        }

        public APIRequestGet requestUtmSourceField(boolean value) {
            this.requestField("utm_source", value);
            return this;
        }
    }
}

