/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ChatPlugin
extends APINode {
    @SerializedName(value="alignment")
    private String mAlignment = null;
    @SerializedName(value="desktop_bottom_spacing")
    private String mDesktopBottomSpacing = null;
    @SerializedName(value="desktop_side_spacing")
    private String mDesktopSideSpacing = null;
    @SerializedName(value="entry_point_icon")
    private String mEntryPointIcon = null;
    @SerializedName(value="entry_point_label")
    private String mEntryPointLabel = null;
    @SerializedName(value="greeting_dialog_display")
    private String mGreetingDialogDisplay = null;
    @SerializedName(value="guest_chat_mode")
    private String mGuestChatMode = null;
    @SerializedName(value="mobile_bottom_spacing")
    private String mMobileBottomSpacing = null;
    @SerializedName(value="mobile_chat_display")
    private String mMobileChatDisplay = null;
    @SerializedName(value="mobile_side_spacing")
    private String mMobileSideSpacing = null;
    @SerializedName(value="theme_color")
    private String mThemeColor = null;
    @SerializedName(value="welcome_screen_greeting")
    private String mWelcomeScreenGreeting = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ChatPlugin loadJSON(String json, APIContext context, String header) {
        ChatPlugin chatPlugin = (ChatPlugin)ChatPlugin.getGson().fromJson(json, ChatPlugin.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(chatPlugin.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        chatPlugin.context = context;
        chatPlugin.rawValue = json;
        chatPlugin.header = header;
        return chatPlugin;
    }

    public static APINodeList<ChatPlugin> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ChatPlugin> chatPlugins = new APINodeList<ChatPlugin>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        chatPlugins.add(ChatPlugin.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return chatPlugins;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            chatPlugins.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        chatPlugins.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            chatPlugins.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            chatPlugins.add(ChatPlugin.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                chatPlugins.add(ChatPlugin.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            chatPlugins.add(ChatPlugin.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return chatPlugins;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        chatPlugins.add(ChatPlugin.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return chatPlugins;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        chatPlugins.add(ChatPlugin.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return chatPlugins;
                }
                chatPlugins.clear();
                chatPlugins.add(ChatPlugin.loadJSON(json, context, header));
                return chatPlugins;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ChatPlugin.getGson().toJson((Object)this);
    }

    public String getFieldAlignment() {
        return this.mAlignment;
    }

    public ChatPlugin setFieldAlignment(String value) {
        this.mAlignment = value;
        return this;
    }

    public String getFieldDesktopBottomSpacing() {
        return this.mDesktopBottomSpacing;
    }

    public ChatPlugin setFieldDesktopBottomSpacing(String value) {
        this.mDesktopBottomSpacing = value;
        return this;
    }

    public String getFieldDesktopSideSpacing() {
        return this.mDesktopSideSpacing;
    }

    public ChatPlugin setFieldDesktopSideSpacing(String value) {
        this.mDesktopSideSpacing = value;
        return this;
    }

    public String getFieldEntryPointIcon() {
        return this.mEntryPointIcon;
    }

    public ChatPlugin setFieldEntryPointIcon(String value) {
        this.mEntryPointIcon = value;
        return this;
    }

    public String getFieldEntryPointLabel() {
        return this.mEntryPointLabel;
    }

    public ChatPlugin setFieldEntryPointLabel(String value) {
        this.mEntryPointLabel = value;
        return this;
    }

    public String getFieldGreetingDialogDisplay() {
        return this.mGreetingDialogDisplay;
    }

    public ChatPlugin setFieldGreetingDialogDisplay(String value) {
        this.mGreetingDialogDisplay = value;
        return this;
    }

    public String getFieldGuestChatMode() {
        return this.mGuestChatMode;
    }

    public ChatPlugin setFieldGuestChatMode(String value) {
        this.mGuestChatMode = value;
        return this;
    }

    public String getFieldMobileBottomSpacing() {
        return this.mMobileBottomSpacing;
    }

    public ChatPlugin setFieldMobileBottomSpacing(String value) {
        this.mMobileBottomSpacing = value;
        return this;
    }

    public String getFieldMobileChatDisplay() {
        return this.mMobileChatDisplay;
    }

    public ChatPlugin setFieldMobileChatDisplay(String value) {
        this.mMobileChatDisplay = value;
        return this;
    }

    public String getFieldMobileSideSpacing() {
        return this.mMobileSideSpacing;
    }

    public ChatPlugin setFieldMobileSideSpacing(String value) {
        this.mMobileSideSpacing = value;
        return this;
    }

    public String getFieldThemeColor() {
        return this.mThemeColor;
    }

    public ChatPlugin setFieldThemeColor(String value) {
        this.mThemeColor = value;
        return this;
    }

    public String getFieldWelcomeScreenGreeting() {
        return this.mWelcomeScreenGreeting;
    }

    public ChatPlugin setFieldWelcomeScreenGreeting(String value) {
        this.mWelcomeScreenGreeting = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ChatPlugin copyFrom(ChatPlugin instance) {
        this.mAlignment = instance.mAlignment;
        this.mDesktopBottomSpacing = instance.mDesktopBottomSpacing;
        this.mDesktopSideSpacing = instance.mDesktopSideSpacing;
        this.mEntryPointIcon = instance.mEntryPointIcon;
        this.mEntryPointLabel = instance.mEntryPointLabel;
        this.mGreetingDialogDisplay = instance.mGreetingDialogDisplay;
        this.mGuestChatMode = instance.mGuestChatMode;
        this.mMobileBottomSpacing = instance.mMobileBottomSpacing;
        this.mMobileChatDisplay = instance.mMobileChatDisplay;
        this.mMobileSideSpacing = instance.mMobileSideSpacing;
        this.mThemeColor = instance.mThemeColor;
        this.mWelcomeScreenGreeting = instance.mWelcomeScreenGreeting;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ChatPlugin> getParser() {
        return new APIRequest.ResponseParser<ChatPlugin>(){

            @Override
            public APINodeList<ChatPlugin> parseResponse(String response, APIContext context, APIRequest<ChatPlugin> request, String header) throws APIException.MalformedResponseException {
                return ChatPlugin.parseResponse(response, context, request, header);
            }
        };
    }
}

