/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudGame
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner")
    private Profile mOwner = null;
    @SerializedName(value="playable_ad_file_size")
    private Long mPlayableAdFileSize = null;
    @SerializedName(value="playable_ad_orientation")
    private String mPlayableAdOrientation = null;
    @SerializedName(value="playable_ad_package_name")
    private String mPlayableAdPackageName = null;
    @SerializedName(value="playable_ad_reject_reason")
    private String mPlayableAdRejectReason = null;
    @SerializedName(value="playable_ad_status")
    private String mPlayableAdStatus = null;
    @SerializedName(value="playable_ad_upload_time")
    private String mPlayableAdUploadTime = null;
    protected static Gson gson = null;

    CloudGame() {
    }

    public CloudGame(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CloudGame(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CloudGame fetch() throws APIException {
        CloudGame newInstance = CloudGame.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CloudGame fetchById(Long id, APIContext context) throws APIException {
        return CloudGame.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CloudGame> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CloudGame.fetchByIdAsync(id.toString(), context);
    }

    public static CloudGame fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CloudGame> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CloudGame> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CloudGame>(context, "", "/", "GET", CloudGame.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CloudGame>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CloudGame>(context, "", "/", "GET", CloudGame.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CloudGame loadJSON(String json, APIContext context, String header) {
        CloudGame cloudGame = (CloudGame)CloudGame.getGson().fromJson(json, CloudGame.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cloudGame.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cloudGame.context = context;
        cloudGame.rawValue = json;
        cloudGame.header = header;
        return cloudGame;
    }

    public static APINodeList<CloudGame> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CloudGame> cloudGames = new APINodeList<CloudGame>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cloudGames.add(CloudGame.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cloudGames;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cloudGames.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cloudGames.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cloudGames.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cloudGames.add(CloudGame.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cloudGames.add(CloudGame.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cloudGames.add(CloudGame.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cloudGames;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cloudGames.add(CloudGame.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cloudGames;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cloudGames.add(CloudGame.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cloudGames;
                }
                cloudGames.clear();
                cloudGames.add(CloudGame.loadJSON(json, context, header));
                return cloudGames;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CloudGame.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Profile getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public Long getFieldPlayableAdFileSize() {
        return this.mPlayableAdFileSize;
    }

    public String getFieldPlayableAdOrientation() {
        return this.mPlayableAdOrientation;
    }

    public String getFieldPlayableAdPackageName() {
        return this.mPlayableAdPackageName;
    }

    public String getFieldPlayableAdRejectReason() {
        return this.mPlayableAdRejectReason;
    }

    public String getFieldPlayableAdStatus() {
        return this.mPlayableAdStatus;
    }

    public String getFieldPlayableAdUploadTime() {
        return this.mPlayableAdUploadTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CloudGame copyFrom(CloudGame instance) {
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mOwner = instance.mOwner;
        this.mPlayableAdFileSize = instance.mPlayableAdFileSize;
        this.mPlayableAdOrientation = instance.mPlayableAdOrientation;
        this.mPlayableAdPackageName = instance.mPlayableAdPackageName;
        this.mPlayableAdRejectReason = instance.mPlayableAdRejectReason;
        this.mPlayableAdStatus = instance.mPlayableAdStatus;
        this.mPlayableAdUploadTime = instance.mPlayableAdUploadTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CloudGame> getParser() {
        return new APIRequest.ResponseParser<CloudGame>(){

            @Override
            public APINodeList<CloudGame> parseResponse(String response, APIContext context, APIRequest<CloudGame> request, String header) throws APIException.MalformedResponseException {
                return CloudGame.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CloudGame> {
        CloudGame lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name", "owner", "playable_ad_file_size", "playable_ad_orientation", "playable_ad_package_name", "playable_ad_reject_reason", "playable_ad_status", "playable_ad_upload_time"};

        @Override
        public CloudGame getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CloudGame parseResponse(String response, String header) throws APIException {
            return CloudGame.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CloudGame execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CloudGame execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CloudGame> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CloudGame> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CloudGame>(){

                public CloudGame apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestPlayableAdFileSizeField() {
            return this.requestPlayableAdFileSizeField(true);
        }

        public APIRequestGet requestPlayableAdFileSizeField(boolean value) {
            this.requestField("playable_ad_file_size", value);
            return this;
        }

        public APIRequestGet requestPlayableAdOrientationField() {
            return this.requestPlayableAdOrientationField(true);
        }

        public APIRequestGet requestPlayableAdOrientationField(boolean value) {
            this.requestField("playable_ad_orientation", value);
            return this;
        }

        public APIRequestGet requestPlayableAdPackageNameField() {
            return this.requestPlayableAdPackageNameField(true);
        }

        public APIRequestGet requestPlayableAdPackageNameField(boolean value) {
            this.requestField("playable_ad_package_name", value);
            return this;
        }

        public APIRequestGet requestPlayableAdRejectReasonField() {
            return this.requestPlayableAdRejectReasonField(true);
        }

        public APIRequestGet requestPlayableAdRejectReasonField(boolean value) {
            this.requestField("playable_ad_reject_reason", value);
            return this;
        }

        public APIRequestGet requestPlayableAdStatusField() {
            return this.requestPlayableAdStatusField(true);
        }

        public APIRequestGet requestPlayableAdStatusField(boolean value) {
            this.requestField("playable_ad_status", value);
            return this;
        }

        public APIRequestGet requestPlayableAdUploadTimeField() {
            return this.requestPlayableAdUploadTimeField(true);
        }

        public APIRequestGet requestPlayableAdUploadTimeField(boolean value) {
            this.requestField("playable_ad_upload_time", value);
            return this;
        }
    }
}

