/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdsPixelStatsResult;
import com.facebook.ads.sdk.AssignedUser;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.DACheck;
import com.facebook.ads.sdk.OfflineConversionDataSetUpload;
import com.facebook.ads.sdk.OfflineConversionDataSetUsage;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdsPixel
extends APINode {
    @SerializedName(value="automatic_matching_fields")
    private List<String> mAutomaticMatchingFields = null;
    @SerializedName(value="can_proxy")
    private Boolean mCanProxy = null;
    @SerializedName(value="code")
    private String mCode = null;
    @SerializedName(value="config")
    private String mConfig = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="data_use_setting")
    private String mDataUseSetting = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="duplicate_entries")
    private Long mDuplicateEntries = null;
    @SerializedName(value="enable_auto_assign_to_accounts")
    private Boolean mEnableAutoAssignToAccounts = null;
    @SerializedName(value="enable_automatic_matching")
    private Boolean mEnableAutomaticMatching = null;
    @SerializedName(value="event_stats")
    private String mEventStats = null;
    @SerializedName(value="event_time_max")
    private Long mEventTimeMax = null;
    @SerializedName(value="event_time_min")
    private Long mEventTimeMin = null;
    @SerializedName(value="first_party_cookie_status")
    private String mFirstPartyCookieStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_consolidated_container")
    private Boolean mIsConsolidatedContainer = null;
    @SerializedName(value="is_created_by_business")
    private Boolean mIsCreatedByBusiness = null;
    @SerializedName(value="is_crm")
    private Boolean mIsCrm = null;
    @SerializedName(value="is_mta_use")
    private Boolean mIsMtaUse = null;
    @SerializedName(value="is_restricted_use")
    private Boolean mIsRestrictedUse = null;
    @SerializedName(value="is_unavailable")
    private Boolean mIsUnavailable = null;
    @SerializedName(value="last_fired_time")
    private String mLastFiredTime = null;
    @SerializedName(value="last_upload_app")
    private String mLastUploadApp = null;
    @SerializedName(value="last_upload_app_changed_time")
    private Long mLastUploadAppChangedTime = null;
    @SerializedName(value="match_rate_approx")
    private Long mMatchRateApprox = null;
    @SerializedName(value="matched_entries")
    private Long mMatchedEntries = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner_ad_account")
    private AdAccount mOwnerAdAccount = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    @SerializedName(value="usage")
    private OfflineConversionDataSetUsage mUsage = null;
    @SerializedName(value="valid_entries")
    private Long mValidEntries = null;
    protected static Gson gson = null;

    AdsPixel() {
    }

    public AdsPixel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsPixel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsPixel fetch() throws APIException {
        AdsPixel newInstance = AdsPixel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsPixel fetchById(Long id, APIContext context) throws APIException {
        return AdsPixel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsPixel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsPixel.fetchByIdAsync(id.toString(), context);
    }

    public static AdsPixel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsPixel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsPixel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsPixel>(context, "", "/", "GET", AdsPixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsPixel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsPixel>(context, "", "/", "GET", AdsPixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPixel loadJSON(String json, APIContext context, String header) {
        AdsPixel adsPixel = (AdsPixel)AdsPixel.getGson().fromJson(json, AdsPixel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixel.context = context;
        adsPixel.rawValue = json;
        adsPixel.header = header;
        return adsPixel;
    }

    public static APINodeList<AdsPixel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixel> adsPixels = new APINodeList<AdsPixel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixels.add(AdsPixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsPixels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixels.add(AdsPixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixels.add(AdsPixel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixels.add(AdsPixel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsPixels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixels.add(AdsPixel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsPixels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixels.add(AdsPixel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixels;
                }
                adsPixels.clear();
                adsPixels.add(AdsPixel.loadJSON(json, context, header));
                return adsPixels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixel.getGson().toJson((Object)this);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAgencies getAgencies() {
        return new APIRequestGetAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedUsers getAssignedUsers() {
        return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAssignedUser createAssignedUser() {
        return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDaChecks getDaChecks() {
        return new APIRequestGetDaChecks(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateEvent createEvent() {
        return new APIRequestCreateEvent(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMeapitocapiconsolidationhelper createMeapitocapiconsolidationhelper() {
        return new APIRequestCreateMeapitocapiconsolidationhelper(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOfflineEventUploads getOfflineEventUploads() {
        return new APIRequestGetOfflineEventUploads(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateShadowTrafficHelper createShadowTrafficHelper() {
        return new APIRequestCreateShadowTrafficHelper(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteSharedAccounts deleteSharedAccounts() {
        return new APIRequestDeleteSharedAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedAccounts getSharedAccounts() {
        return new APIRequestGetSharedAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSharedAccount createSharedAccount() {
        return new APIRequestCreateSharedAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedAgencies getSharedAgencies() {
        return new APIRequestGetSharedAgencies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetStats getStats() {
        return new APIRequestGetStats(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateTelemetry createTelemetry() {
        return new APIRequestCreateTelemetry(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAutomaticMatchingFields() {
        return this.mAutomaticMatchingFields;
    }

    public Boolean getFieldCanProxy() {
        return this.mCanProxy;
    }

    public String getFieldCode() {
        return this.mCode;
    }

    public String getFieldConfig() {
        return this.mConfig;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldDataUseSetting() {
        return this.mDataUseSetting;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Long getFieldDuplicateEntries() {
        return this.mDuplicateEntries;
    }

    public Boolean getFieldEnableAutoAssignToAccounts() {
        return this.mEnableAutoAssignToAccounts;
    }

    public Boolean getFieldEnableAutomaticMatching() {
        return this.mEnableAutomaticMatching;
    }

    public String getFieldEventStats() {
        return this.mEventStats;
    }

    public Long getFieldEventTimeMax() {
        return this.mEventTimeMax;
    }

    public Long getFieldEventTimeMin() {
        return this.mEventTimeMin;
    }

    public String getFieldFirstPartyCookieStatus() {
        return this.mFirstPartyCookieStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsConsolidatedContainer() {
        return this.mIsConsolidatedContainer;
    }

    public Boolean getFieldIsCreatedByBusiness() {
        return this.mIsCreatedByBusiness;
    }

    public Boolean getFieldIsCrm() {
        return this.mIsCrm;
    }

    public Boolean getFieldIsMtaUse() {
        return this.mIsMtaUse;
    }

    public Boolean getFieldIsRestrictedUse() {
        return this.mIsRestrictedUse;
    }

    public Boolean getFieldIsUnavailable() {
        return this.mIsUnavailable;
    }

    public String getFieldLastFiredTime() {
        return this.mLastFiredTime;
    }

    public String getFieldLastUploadApp() {
        return this.mLastUploadApp;
    }

    public Long getFieldLastUploadAppChangedTime() {
        return this.mLastUploadAppChangedTime;
    }

    public Long getFieldMatchRateApprox() {
        return this.mMatchRateApprox;
    }

    public Long getFieldMatchedEntries() {
        return this.mMatchedEntries;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdAccount getFieldOwnerAdAccount() {
        if (this.mOwnerAdAccount != null) {
            this.mOwnerAdAccount.context = this.getContext();
        }
        return this.mOwnerAdAccount;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    public OfflineConversionDataSetUsage getFieldUsage() {
        return this.mUsage;
    }

    public Long getFieldValidEntries() {
        return this.mValidEntries;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixel copyFrom(AdsPixel instance) {
        this.mAutomaticMatchingFields = instance.mAutomaticMatchingFields;
        this.mCanProxy = instance.mCanProxy;
        this.mCode = instance.mCode;
        this.mConfig = instance.mConfig;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mDataUseSetting = instance.mDataUseSetting;
        this.mDescription = instance.mDescription;
        this.mDuplicateEntries = instance.mDuplicateEntries;
        this.mEnableAutoAssignToAccounts = instance.mEnableAutoAssignToAccounts;
        this.mEnableAutomaticMatching = instance.mEnableAutomaticMatching;
        this.mEventStats = instance.mEventStats;
        this.mEventTimeMax = instance.mEventTimeMax;
        this.mEventTimeMin = instance.mEventTimeMin;
        this.mFirstPartyCookieStatus = instance.mFirstPartyCookieStatus;
        this.mId = instance.mId;
        this.mIsConsolidatedContainer = instance.mIsConsolidatedContainer;
        this.mIsCreatedByBusiness = instance.mIsCreatedByBusiness;
        this.mIsCrm = instance.mIsCrm;
        this.mIsMtaUse = instance.mIsMtaUse;
        this.mIsRestrictedUse = instance.mIsRestrictedUse;
        this.mIsUnavailable = instance.mIsUnavailable;
        this.mLastFiredTime = instance.mLastFiredTime;
        this.mLastUploadApp = instance.mLastUploadApp;
        this.mLastUploadAppChangedTime = instance.mLastUploadAppChangedTime;
        this.mMatchRateApprox = instance.mMatchRateApprox;
        this.mMatchedEntries = instance.mMatchedEntries;
        this.mName = instance.mName;
        this.mOwnerAdAccount = instance.mOwnerAdAccount;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.mUsage = instance.mUsage;
        this.mValidEntries = instance.mValidEntries;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixel> getParser() {
        return new APIRequest.ResponseParser<AdsPixel>(){

            @Override
            public APINodeList<AdsPixel> parseResponse(String response, APIContext context, APIRequest<AdsPixel> request, String header) throws APIException.MalformedResponseException {
                return AdsPixel.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumTasks {
        VALUE_AA_ANALYZE("AA_ANALYZE"),
        VALUE_ADVERTISE("ADVERTISE"),
        VALUE_ANALYZE("ANALYZE"),
        VALUE_EDIT("EDIT"),
        VALUE_UPLOAD("UPLOAD");

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumFirstPartyCookieStatus {
        VALUE_EMPTY("EMPTY"),
        VALUE_FIRST_PARTY_COOKIE_DISABLED("FIRST_PARTY_COOKIE_DISABLED"),
        VALUE_FIRST_PARTY_COOKIE_ENABLED("FIRST_PARTY_COOKIE_ENABLED");

        private String value;

        private EnumFirstPartyCookieStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDataUseSetting {
        VALUE_ADVERTISING_AND_ANALYTICS("ADVERTISING_AND_ANALYTICS"),
        VALUE_ANALYTICS_ONLY("ANALYTICS_ONLY"),
        VALUE_EMPTY("EMPTY");

        private String value;

        private EnumDataUseSetting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAutomaticMatchingFields {
        VALUE_COUNTRY("country"),
        VALUE_CT("ct"),
        VALUE_DB("db"),
        VALUE_EM("em"),
        VALUE_EXTERNAL_ID("external_id"),
        VALUE_FN("fn"),
        VALUE_GE("ge"),
        VALUE_LN("ln"),
        VALUE_PH("ph"),
        VALUE_ST("st"),
        VALUE_ZP("zp");

        private String value;

        private EnumAutomaticMatchingFields(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSortBy {
        VALUE_LAST_FIRED_TIME("LAST_FIRED_TIME"),
        VALUE_NAME("NAME");

        private String value;

        private EnumSortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"automatic_matching_fields", "data_use_setting", "enable_automatic_matching", "first_party_cookie_status", "name", "server_events_business_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAutomaticMatchingFields(List<EnumAutomaticMatchingFields> automaticMatchingFields) {
            this.setParam("automatic_matching_fields", automaticMatchingFields);
            return this;
        }

        public APIRequestUpdate setAutomaticMatchingFields(String automaticMatchingFields) {
            this.setParam("automatic_matching_fields", automaticMatchingFields);
            return this;
        }

        public APIRequestUpdate setDataUseSetting(EnumDataUseSetting dataUseSetting) {
            this.setParam("data_use_setting", (Object)dataUseSetting);
            return this;
        }

        public APIRequestUpdate setDataUseSetting(String dataUseSetting) {
            this.setParam("data_use_setting", dataUseSetting);
            return this;
        }

        public APIRequestUpdate setEnableAutomaticMatching(Boolean enableAutomaticMatching) {
            this.setParam("enable_automatic_matching", enableAutomaticMatching);
            return this;
        }

        public APIRequestUpdate setEnableAutomaticMatching(String enableAutomaticMatching) {
            this.setParam("enable_automatic_matching", enableAutomaticMatching);
            return this;
        }

        public APIRequestUpdate setFirstPartyCookieStatus(EnumFirstPartyCookieStatus firstPartyCookieStatus) {
            this.setParam("first_party_cookie_status", (Object)firstPartyCookieStatus);
            return this;
        }

        public APIRequestUpdate setFirstPartyCookieStatus(String firstPartyCookieStatus) {
            this.setParam("first_party_cookie_status", firstPartyCookieStatus);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setServerEventsBusinessIds(List<String> serverEventsBusinessIds) {
            this.setParam("server_events_business_ids", serverEventsBusinessIds);
            return this;
        }

        public APIRequestUpdate setServerEventsBusinessIds(String serverEventsBusinessIds) {
            this.setParam("server_events_business_ids", serverEventsBusinessIds);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"automatic_matching_fields", "can_proxy", "code", "config", "creation_time", "creator", "data_use_setting", "description", "duplicate_entries", "enable_auto_assign_to_accounts", "enable_automatic_matching", "event_stats", "event_time_max", "event_time_min", "first_party_cookie_status", "id", "is_consolidated_container", "is_created_by_business", "is_crm", "is_mta_use", "is_restricted_use", "is_unavailable", "last_fired_time", "last_upload_app", "last_upload_app_changed_time", "match_rate_approx", "matched_entries", "name", "owner_ad_account", "owner_business", "usage", "valid_entries"};

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAutomaticMatchingFieldsField() {
            return this.requestAutomaticMatchingFieldsField(true);
        }

        public APIRequestGet requestAutomaticMatchingFieldsField(boolean value) {
            this.requestField("automatic_matching_fields", value);
            return this;
        }

        public APIRequestGet requestCanProxyField() {
            return this.requestCanProxyField(true);
        }

        public APIRequestGet requestCanProxyField(boolean value) {
            this.requestField("can_proxy", value);
            return this;
        }

        public APIRequestGet requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGet requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGet requestConfigField() {
            return this.requestConfigField(true);
        }

        public APIRequestGet requestConfigField(boolean value) {
            this.requestField("config", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestDataUseSettingField() {
            return this.requestDataUseSettingField(true);
        }

        public APIRequestGet requestDataUseSettingField(boolean value) {
            this.requestField("data_use_setting", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGet requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGet requestEnableAutoAssignToAccountsField() {
            return this.requestEnableAutoAssignToAccountsField(true);
        }

        public APIRequestGet requestEnableAutoAssignToAccountsField(boolean value) {
            this.requestField("enable_auto_assign_to_accounts", value);
            return this;
        }

        public APIRequestGet requestEnableAutomaticMatchingField() {
            return this.requestEnableAutomaticMatchingField(true);
        }

        public APIRequestGet requestEnableAutomaticMatchingField(boolean value) {
            this.requestField("enable_automatic_matching", value);
            return this;
        }

        public APIRequestGet requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGet requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGet requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGet requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGet requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGet requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGet requestFirstPartyCookieStatusField() {
            return this.requestFirstPartyCookieStatusField(true);
        }

        public APIRequestGet requestFirstPartyCookieStatusField(boolean value) {
            this.requestField("first_party_cookie_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsConsolidatedContainerField() {
            return this.requestIsConsolidatedContainerField(true);
        }

        public APIRequestGet requestIsConsolidatedContainerField(boolean value) {
            this.requestField("is_consolidated_container", value);
            return this;
        }

        public APIRequestGet requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGet requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGet requestIsCrmField() {
            return this.requestIsCrmField(true);
        }

        public APIRequestGet requestIsCrmField(boolean value) {
            this.requestField("is_crm", value);
            return this;
        }

        public APIRequestGet requestIsMtaUseField() {
            return this.requestIsMtaUseField(true);
        }

        public APIRequestGet requestIsMtaUseField(boolean value) {
            this.requestField("is_mta_use", value);
            return this;
        }

        public APIRequestGet requestIsRestrictedUseField() {
            return this.requestIsRestrictedUseField(true);
        }

        public APIRequestGet requestIsRestrictedUseField(boolean value) {
            this.requestField("is_restricted_use", value);
            return this;
        }

        public APIRequestGet requestIsUnavailableField() {
            return this.requestIsUnavailableField(true);
        }

        public APIRequestGet requestIsUnavailableField(boolean value) {
            this.requestField("is_unavailable", value);
            return this;
        }

        public APIRequestGet requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGet requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGet requestLastUploadAppField() {
            return this.requestLastUploadAppField(true);
        }

        public APIRequestGet requestLastUploadAppField(boolean value) {
            this.requestField("last_upload_app", value);
            return this;
        }

        public APIRequestGet requestLastUploadAppChangedTimeField() {
            return this.requestLastUploadAppChangedTimeField(true);
        }

        public APIRequestGet requestLastUploadAppChangedTimeField(boolean value) {
            this.requestField("last_upload_app_changed_time", value);
            return this;
        }

        public APIRequestGet requestMatchRateApproxField() {
            return this.requestMatchRateApproxField(true);
        }

        public APIRequestGet requestMatchRateApproxField(boolean value) {
            this.requestField("match_rate_approx", value);
            return this;
        }

        public APIRequestGet requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGet requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGet requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGet requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGet requestUsageField() {
            return this.requestUsageField(true);
        }

        public APIRequestGet requestUsageField(boolean value) {
            this.requestField("usage", value);
            return this;
        }

        public APIRequestGet requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGet requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    public static class APIRequestCreateTelemetry
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateTelemetry(String nodeId, APIContext context) {
            super(context, nodeId, "/telemetry", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateTelemetry setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateTelemetry setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateTelemetry requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateTelemetry requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateTelemetry requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetStats
    extends APIRequest<AdsPixelStatsResult> {
        APINodeList<AdsPixelStatsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"aggregation", "end_time", "event", "event_source", "start_time"};
        public static final String[] FIELDS = new String[]{"aggregation", "data", "start_time"};

        @Override
        public APINodeList<AdsPixelStatsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixelStatsResult> parseResponse(String response, String header) throws APIException {
            return AdsPixelStatsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdsPixelStatsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixelStatsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsPixelStatsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsPixelStatsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdsPixelStatsResult>>(){

                public APINodeList<AdsPixelStatsResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetStats(String nodeId, APIContext context) {
            super(context, nodeId, "/stats", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetStats setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetStats setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetStats setAggregation(AdsPixelStatsResult.EnumAggregation aggregation) {
            this.setParam("aggregation", (Object)aggregation);
            return this;
        }

        public APIRequestGetStats setAggregation(String aggregation) {
            this.setParam("aggregation", aggregation);
            return this;
        }

        public APIRequestGetStats setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetStats setEvent(String event) {
            this.setParam("event", event);
            return this;
        }

        public APIRequestGetStats setEventSource(String eventSource) {
            this.setParam("event_source", eventSource);
            return this;
        }

        public APIRequestGetStats setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetStats requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetStats requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetStats requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetStats requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetStats requestAggregationField() {
            return this.requestAggregationField(true);
        }

        public APIRequestGetStats requestAggregationField(boolean value) {
            this.requestField("aggregation", value);
            return this;
        }

        public APIRequestGetStats requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetStats requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetStats requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetStats requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }
    }

    public static class APIRequestGetSharedAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "collaborative_ads_managed_partner_business_info", "collaborative_ads_managed_partner_eligibility", "collaborative_ads_partner_premium_options", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetSharedAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField() {
            return this.requestCollaborativeAdsManagedPartnerBusinessInfoField(true);
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_business_info", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsManagedPartnerEligibilityField() {
            return this.requestCollaborativeAdsManagedPartnerEligibilityField(true);
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsManagedPartnerEligibilityField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_eligibility", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsPartnerPremiumOptionsField() {
            return this.requestCollaborativeAdsPartnerPremiumOptionsField(true);
        }

        public APIRequestGetSharedAgencies requestCollaborativeAdsPartnerPremiumOptionsField(boolean value) {
            this.requestField("collaborative_ads_partner_premium_options", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetSharedAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetSharedAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetSharedAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetSharedAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetSharedAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetSharedAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetSharedAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetSharedAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetSharedAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetSharedAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetSharedAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetSharedAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetSharedAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    public static class APIRequestCreateSharedAccount
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateSharedAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSharedAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSharedAccount setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestCreateSharedAccount setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateSharedAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSharedAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetSharedAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_advertiser_opted_in_odax", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetSharedAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetSharedAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetSharedAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetSharedAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetSharedAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetSharedAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetSharedAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetSharedAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetSharedAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetSharedAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetSharedAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetSharedAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetSharedAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetSharedAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetSharedAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetSharedAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetSharedAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetSharedAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetSharedAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetSharedAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetSharedAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetSharedAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestHasAdvertiserOptedInOdaxField() {
            return this.requestHasAdvertiserOptedInOdaxField(true);
        }

        public APIRequestGetSharedAccounts requestHasAdvertiserOptedInOdaxField(boolean value) {
            this.requestField("has_advertiser_opted_in_odax", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetSharedAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetSharedAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetSharedAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetSharedAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetSharedAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetSharedAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetSharedAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetSharedAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetSharedAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetSharedAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetSharedAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetSharedAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetSharedAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetSharedAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetSharedAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetSharedAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetSharedAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetSharedAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetSharedAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetSharedAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetSharedAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetSharedAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetSharedAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetSharedAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetSharedAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetSharedAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetSharedAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetSharedAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetSharedAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }

    public static class APIRequestDeleteSharedAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteSharedAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteSharedAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteSharedAccounts setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestDeleteSharedAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteSharedAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteSharedAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteSharedAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteSharedAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateShadowTrafficHelper
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateShadowTrafficHelper(String nodeId, APIContext context) {
            super(context, nodeId, "/shadowtraffichelper", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateShadowTrafficHelper setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateShadowTrafficHelper setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateShadowTrafficHelper requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateShadowTrafficHelper requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateShadowTrafficHelper requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateShadowTrafficHelper requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateShadowTrafficHelper requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateShadowTrafficHelper requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetOfflineEventUploads
    extends APIRequest<OfflineConversionDataSetUpload> {
        APINodeList<OfflineConversionDataSetUpload> lastResponse = null;
        public static final String[] PARAMS = new String[]{"end_time", "order", "sort_by", "start_time", "upload_tag"};
        public static final String[] FIELDS = new String[]{"api_calls", "creation_time", "duplicate_entries", "event_stats", "event_time_max", "event_time_min", "first_upload_time", "id", "is_excluded_for_lift", "last_upload_time", "match_rate_approx", "matched_entries", "upload_tag", "valid_entries"};

        @Override
        public APINodeList<OfflineConversionDataSetUpload> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OfflineConversionDataSetUpload> parseResponse(String response, String header) throws APIException {
            return OfflineConversionDataSetUpload.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OfflineConversionDataSetUpload> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OfflineConversionDataSetUpload> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSetUpload>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSetUpload>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OfflineConversionDataSetUpload>>(){

                public APINodeList<OfflineConversionDataSetUpload> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOfflineEventUploads(String nodeId, APIContext context) {
            super(context, nodeId, "/offline_event_uploads", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOfflineEventUploads setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOfflineEventUploads setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOfflineEventUploads setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetOfflineEventUploads setOrder(OfflineConversionDataSetUpload.EnumOrder order) {
            this.setParam("order", (Object)order);
            return this;
        }

        public APIRequestGetOfflineEventUploads setOrder(String order) {
            this.setParam("order", order);
            return this;
        }

        public APIRequestGetOfflineEventUploads setSortBy(OfflineConversionDataSetUpload.EnumSortBy sortBy) {
            this.setParam("sort_by", (Object)sortBy);
            return this;
        }

        public APIRequestGetOfflineEventUploads setSortBy(String sortBy) {
            this.setParam("sort_by", sortBy);
            return this;
        }

        public APIRequestGetOfflineEventUploads setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetOfflineEventUploads setUploadTag(String uploadTag) {
            this.setParam("upload_tag", uploadTag);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOfflineEventUploads requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineEventUploads requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOfflineEventUploads requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineEventUploads requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOfflineEventUploads requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestApiCallsField() {
            return this.requestApiCallsField(true);
        }

        public APIRequestGetOfflineEventUploads requestApiCallsField(boolean value) {
            this.requestField("api_calls", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetOfflineEventUploads requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGetOfflineEventUploads requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGetOfflineEventUploads requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGetOfflineEventUploads requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGetOfflineEventUploads requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestFirstUploadTimeField() {
            return this.requestFirstUploadTimeField(true);
        }

        public APIRequestGetOfflineEventUploads requestFirstUploadTimeField(boolean value) {
            this.requestField("first_upload_time", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOfflineEventUploads requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestIsExcludedForLiftField() {
            return this.requestIsExcludedForLiftField(true);
        }

        public APIRequestGetOfflineEventUploads requestIsExcludedForLiftField(boolean value) {
            this.requestField("is_excluded_for_lift", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestLastUploadTimeField() {
            return this.requestLastUploadTimeField(true);
        }

        public APIRequestGetOfflineEventUploads requestLastUploadTimeField(boolean value) {
            this.requestField("last_upload_time", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestMatchRateApproxField() {
            return this.requestMatchRateApproxField(true);
        }

        public APIRequestGetOfflineEventUploads requestMatchRateApproxField(boolean value) {
            this.requestField("match_rate_approx", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGetOfflineEventUploads requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestUploadTagField() {
            return this.requestUploadTagField(true);
        }

        public APIRequestGetOfflineEventUploads requestUploadTagField(boolean value) {
            this.requestField("upload_tag", value);
            return this;
        }

        public APIRequestGetOfflineEventUploads requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGetOfflineEventUploads requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    public static class APIRequestCreateMeapitocapiconsolidationhelper
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMeapitocapiconsolidationhelper(String nodeId, APIContext context) {
            super(context, nodeId, "/meapitocapiconsolidationhelper", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMeapitocapiconsolidationhelper setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMeapitocapiconsolidationhelper setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMeapitocapiconsolidationhelper requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMeapitocapiconsolidationhelper requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMeapitocapiconsolidationhelper requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMeapitocapiconsolidationhelper requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMeapitocapiconsolidationhelper requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMeapitocapiconsolidationhelper requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateEvent
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"data", "namespace_id", "partner_agent", "platforms", "test_event_code", "trace", "upload_id", "upload_source", "upload_tag"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateEvent(String nodeId, APIContext context) {
            super(context, nodeId, "/events", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateEvent setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateEvent setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateEvent setData(List<String> data) {
            this.setParam("data", data);
            return this;
        }

        public APIRequestCreateEvent setData(String data) {
            this.setParam("data", data);
            return this;
        }

        public APIRequestCreateEvent setNamespaceId(String namespaceId) {
            this.setParam("namespace_id", namespaceId);
            return this;
        }

        public APIRequestCreateEvent setPartnerAgent(String partnerAgent) {
            this.setParam("partner_agent", partnerAgent);
            return this;
        }

        public APIRequestCreateEvent setPlatforms(List<Map<String, String>> platforms) {
            this.setParam("platforms", platforms);
            return this;
        }

        public APIRequestCreateEvent setPlatforms(String platforms) {
            this.setParam("platforms", platforms);
            return this;
        }

        public APIRequestCreateEvent setTestEventCode(String testEventCode) {
            this.setParam("test_event_code", testEventCode);
            return this;
        }

        public APIRequestCreateEvent setTrace(Long trace) {
            this.setParam("trace", trace);
            return this;
        }

        public APIRequestCreateEvent setTrace(String trace) {
            this.setParam("trace", trace);
            return this;
        }

        public APIRequestCreateEvent setUploadId(String uploadId) {
            this.setParam("upload_id", uploadId);
            return this;
        }

        public APIRequestCreateEvent setUploadSource(String uploadSource) {
            this.setParam("upload_source", uploadSource);
            return this;
        }

        public APIRequestCreateEvent setUploadTag(String uploadTag) {
            this.setParam("upload_tag", uploadTag);
            return this;
        }

        public APIRequestCreateEvent requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateEvent requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEvent requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateEvent requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEvent requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateEvent requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetDaChecks
    extends APIRequest<DACheck> {
        APINodeList<DACheck> lastResponse = null;
        public static final String[] PARAMS = new String[]{"checks", "connection_method"};
        public static final String[] FIELDS = new String[]{"action_uri", "description", "key", "result", "title", "user_message"};

        @Override
        public APINodeList<DACheck> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DACheck> parseResponse(String response, String header) throws APIException {
            return DACheck.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<DACheck> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DACheck> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DACheck>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DACheck>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<DACheck>>(){

                public APINodeList<DACheck> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDaChecks(String nodeId, APIContext context) {
            super(context, nodeId, "/da_checks", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDaChecks setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDaChecks setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDaChecks setChecks(List<String> checks) {
            this.setParam("checks", checks);
            return this;
        }

        public APIRequestGetDaChecks setChecks(String checks) {
            this.setParam("checks", checks);
            return this;
        }

        public APIRequestGetDaChecks setConnectionMethod(DACheck.EnumConnectionMethod connectionMethod) {
            this.setParam("connection_method", (Object)connectionMethod);
            return this;
        }

        public APIRequestGetDaChecks setConnectionMethod(String connectionMethod) {
            this.setParam("connection_method", connectionMethod);
            return this;
        }

        public APIRequestGetDaChecks requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDaChecks requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDaChecks requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDaChecks requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDaChecks requestActionUriField() {
            return this.requestActionUriField(true);
        }

        public APIRequestGetDaChecks requestActionUriField(boolean value) {
            this.requestField("action_uri", value);
            return this;
        }

        public APIRequestGetDaChecks requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetDaChecks requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetDaChecks requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetDaChecks requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetDaChecks requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGetDaChecks requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGetDaChecks requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetDaChecks requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetDaChecks requestUserMessageField() {
            return this.requestUserMessageField(true);
        }

        public APIRequestGetDaChecks requestUserMessageField(boolean value) {
            this.requestField("user_message", value);
            return this;
        }
    }

    public static class APIRequestCreateAssignedUser
    extends APIRequest<AdsPixel> {
        AdsPixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"tasks", "user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdsPixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixel parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdsPixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdsPixel>(){

                public AdsPixel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAssignedUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAssignedUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAssignedUsers
    extends APIRequest<AssignedUser> {
        APINodeList<AssignedUser> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "id", "name", "user_type"};

        @Override
        public APINodeList<AssignedUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AssignedUser> parseResponse(String response, String header) throws APIException {
            return AssignedUser.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AssignedUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AssignedUser>>(){

                public APINodeList<AssignedUser> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestUserTypeField() {
            return this.requestUserTypeField(true);
        }

        public APIRequestGetAssignedUsers requestUserTypeField(boolean value) {
            this.requestField("user_type", value);
            return this;
        }
    }

    public static class APIRequestGetAgencies
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "collaborative_ads_managed_partner_business_info", "collaborative_ads_managed_partner_eligibility", "collaborative_ads_partner_premium_options", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAgencies(String nodeId, APIContext context) {
            super(context, nodeId, "/agencies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAgencies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAgencies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAgencies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAgencies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAgencies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAgencies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetAgencies requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField() {
            return this.requestCollaborativeAdsManagedPartnerBusinessInfoField(true);
        }

        public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_business_info", value);
            return this;
        }

        public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerEligibilityField() {
            return this.requestCollaborativeAdsManagedPartnerEligibilityField(true);
        }

        public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerEligibilityField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_eligibility", value);
            return this;
        }

        public APIRequestGetAgencies requestCollaborativeAdsPartnerPremiumOptionsField() {
            return this.requestCollaborativeAdsPartnerPremiumOptionsField(true);
        }

        public APIRequestGetAgencies requestCollaborativeAdsPartnerPremiumOptionsField(boolean value) {
            this.requestField("collaborative_ads_partner_premium_options", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAgencies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAgencies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAgencies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAgencies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAgencies requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetAgencies requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetAgencies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAgencies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAgencies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAgencies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAgencies requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetAgencies requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetAgencies requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetAgencies requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetAgencies requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAgencies requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAgencies requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetAgencies requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetAgencies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetAgencies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAgencies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAgencies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetAgencies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetAgencies requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetAgencies requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetAgencies requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_advertiser_opted_in_odax", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetAdAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasAdvertiserOptedInOdaxField() {
            return this.requestHasAdvertiserOptedInOdaxField(true);
        }

        public APIRequestGetAdAccounts requestHasAdvertiserOptedInOdaxField(boolean value) {
            this.requestField("has_advertiser_opted_in_odax", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetAdAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetAdAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }
}

