/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnifiedThread
extends APINode {
    @SerializedName(value="can_reply")
    private Boolean mCanReply = null;
    @SerializedName(value="folder")
    private String mFolder = null;
    @SerializedName(value="former_participants")
    private Object mFormerParticipants = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_subscribed")
    private Boolean mIsSubscribed = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message_count")
    private Long mMessageCount = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="participants")
    private Object mParticipants = null;
    @SerializedName(value="scoped_thread_key")
    private String mScopedThreadKey = null;
    @SerializedName(value="senders")
    private Object mSenders = null;
    @SerializedName(value="snippet")
    private String mSnippet = null;
    @SerializedName(value="subject")
    private String mSubject = null;
    @SerializedName(value="unread_count")
    private Long mUnreadCount = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="wallpaper")
    private String mWallpaper = null;
    protected static Gson gson = null;

    UnifiedThread() {
    }

    public UnifiedThread(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public UnifiedThread(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public UnifiedThread fetch() throws APIException {
        UnifiedThread newInstance = UnifiedThread.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static UnifiedThread fetchById(Long id, APIContext context) throws APIException {
        return UnifiedThread.fetchById(id.toString(), context);
    }

    public static ListenableFuture<UnifiedThread> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return UnifiedThread.fetchByIdAsync(id.toString(), context);
    }

    public static UnifiedThread fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<UnifiedThread> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<UnifiedThread> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<UnifiedThread>(context, "", "/", "GET", UnifiedThread.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<UnifiedThread>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<UnifiedThread>(context, "", "/", "GET", UnifiedThread.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UnifiedThread loadJSON(String json, APIContext context, String header) {
        UnifiedThread unifiedThread = (UnifiedThread)UnifiedThread.getGson().fromJson(json, UnifiedThread.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(unifiedThread.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        unifiedThread.context = context;
        unifiedThread.rawValue = json;
        unifiedThread.header = header;
        return unifiedThread;
    }

    public static APINodeList<UnifiedThread> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UnifiedThread> unifiedThreads = new APINodeList<UnifiedThread>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        unifiedThreads.add(UnifiedThread.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return unifiedThreads;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            unifiedThreads.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        unifiedThreads.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            unifiedThreads.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            unifiedThreads.add(UnifiedThread.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                unifiedThreads.add(UnifiedThread.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            unifiedThreads.add(UnifiedThread.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return unifiedThreads;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        unifiedThreads.add(UnifiedThread.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return unifiedThreads;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        unifiedThreads.add(UnifiedThread.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return unifiedThreads;
                }
                unifiedThreads.clear();
                unifiedThreads.add(UnifiedThread.loadJSON(json, context, header));
                return unifiedThreads;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UnifiedThread.getGson().toJson((Object)this);
    }

    public APIRequestGetMessages getMessages() {
        return new APIRequestGetMessages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCanReply() {
        return this.mCanReply;
    }

    public String getFieldFolder() {
        return this.mFolder;
    }

    public Object getFieldFormerParticipants() {
        return this.mFormerParticipants;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsSubscribed() {
        return this.mIsSubscribed;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public Long getFieldMessageCount() {
        return this.mMessageCount;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Object getFieldParticipants() {
        return this.mParticipants;
    }

    public String getFieldScopedThreadKey() {
        return this.mScopedThreadKey;
    }

    public Object getFieldSenders() {
        return this.mSenders;
    }

    public String getFieldSnippet() {
        return this.mSnippet;
    }

    public String getFieldSubject() {
        return this.mSubject;
    }

    public Long getFieldUnreadCount() {
        return this.mUnreadCount;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public String getFieldWallpaper() {
        return this.mWallpaper;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UnifiedThread copyFrom(UnifiedThread instance) {
        this.mCanReply = instance.mCanReply;
        this.mFolder = instance.mFolder;
        this.mFormerParticipants = instance.mFormerParticipants;
        this.mId = instance.mId;
        this.mIsSubscribed = instance.mIsSubscribed;
        this.mLink = instance.mLink;
        this.mMessageCount = instance.mMessageCount;
        this.mName = instance.mName;
        this.mParticipants = instance.mParticipants;
        this.mScopedThreadKey = instance.mScopedThreadKey;
        this.mSenders = instance.mSenders;
        this.mSnippet = instance.mSnippet;
        this.mSubject = instance.mSubject;
        this.mUnreadCount = instance.mUnreadCount;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mWallpaper = instance.mWallpaper;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UnifiedThread> getParser() {
        return new APIRequest.ResponseParser<UnifiedThread>(){

            @Override
            public APINodeList<UnifiedThread> parseResponse(String response, APIContext context, APIRequest<UnifiedThread> request, String header) throws APIException.MalformedResponseException {
                return UnifiedThread.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumSource {
        VALUE_ALL("ALL"),
        VALUE_PARTICIPANTS("PARTICIPANTS");

        private String value;

        private EnumSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPlatform {
        VALUE_INSTAGRAM("INSTAGRAM"),
        VALUE_MESSENGER("MESSENGER");

        private String value;

        private EnumPlatform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<UnifiedThread> {
        UnifiedThread lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_reply", "folder", "former_participants", "id", "is_subscribed", "link", "message_count", "name", "participants", "scoped_thread_key", "senders", "snippet", "subject", "unread_count", "updated_time", "wallpaper"};

        @Override
        public UnifiedThread getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public UnifiedThread parseResponse(String response, String header) throws APIException {
            return UnifiedThread.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public UnifiedThread execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public UnifiedThread execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<UnifiedThread> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<UnifiedThread> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, UnifiedThread>(){

                public UnifiedThread apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanReplyField() {
            return this.requestCanReplyField(true);
        }

        public APIRequestGet requestCanReplyField(boolean value) {
            this.requestField("can_reply", value);
            return this;
        }

        public APIRequestGet requestFolderField() {
            return this.requestFolderField(true);
        }

        public APIRequestGet requestFolderField(boolean value) {
            this.requestField("folder", value);
            return this;
        }

        public APIRequestGet requestFormerParticipantsField() {
            return this.requestFormerParticipantsField(true);
        }

        public APIRequestGet requestFormerParticipantsField(boolean value) {
            this.requestField("former_participants", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsSubscribedField() {
            return this.requestIsSubscribedField(true);
        }

        public APIRequestGet requestIsSubscribedField(boolean value) {
            this.requestField("is_subscribed", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestMessageCountField() {
            return this.requestMessageCountField(true);
        }

        public APIRequestGet requestMessageCountField(boolean value) {
            this.requestField("message_count", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestParticipantsField() {
            return this.requestParticipantsField(true);
        }

        public APIRequestGet requestParticipantsField(boolean value) {
            this.requestField("participants", value);
            return this;
        }

        public APIRequestGet requestScopedThreadKeyField() {
            return this.requestScopedThreadKeyField(true);
        }

        public APIRequestGet requestScopedThreadKeyField(boolean value) {
            this.requestField("scoped_thread_key", value);
            return this;
        }

        public APIRequestGet requestSendersField() {
            return this.requestSendersField(true);
        }

        public APIRequestGet requestSendersField(boolean value) {
            this.requestField("senders", value);
            return this;
        }

        public APIRequestGet requestSnippetField() {
            return this.requestSnippetField(true);
        }

        public APIRequestGet requestSnippetField(boolean value) {
            this.requestField("snippet", value);
            return this;
        }

        public APIRequestGet requestSubjectField() {
            return this.requestSubjectField(true);
        }

        public APIRequestGet requestSubjectField(boolean value) {
            this.requestField("subject", value);
            return this;
        }

        public APIRequestGet requestUnreadCountField() {
            return this.requestUnreadCountField(true);
        }

        public APIRequestGet requestUnreadCountField(boolean value) {
            this.requestField("unread_count", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestWallpaperField() {
            return this.requestWallpaperField(true);
        }

        public APIRequestGet requestWallpaperField(boolean value) {
            this.requestField("wallpaper", value);
            return this;
        }
    }

    public static class APIRequestGetMessages
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"source"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMessages(String nodeId, APIContext context) {
            super(context, nodeId, "/messages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMessages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMessages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMessages setSource(EnumSource source) {
            this.setParam("source", (Object)source);
            return this;
        }

        public APIRequestGetMessages setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestGetMessages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMessages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMessages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMessages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

